/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.region;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import mapwriter.region.IChunk;
import mapwriter.region.RegionFile;
import mapwriter.region.RegionFileCache;
import mapwriter.util.Logging;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class MwChunk
implements IChunk {
    public static final int SIZE = 16;
    public final int x;
    public final int z;
    public final int dimension;
    public ExtendedBlockStorage[] dataArray = new ExtendedBlockStorage[16];
    public final Map<BlockPos, TileEntity> tileentityMap;
    public final byte[] biomeArray;
    public final int maxY;
    private static Method CarpenterMethod = null;
    private static Method FMPMethodParts = null;
    private static Method FMPMethodMaterial = null;
    private static Field FMPFieldBlock = null;
    private static Field FMPFieldMeta = null;

    public MwChunk(int x, int z, int dimension, ExtendedBlockStorage[] data, byte[] biomeArray, Map<BlockPos, TileEntity> TileEntityMap) {
        this.x = x;
        this.z = z;
        this.dimension = dimension;
        this.biomeArray = biomeArray;
        this.tileentityMap = TileEntityMap;
        this.dataArray = data;
        int maxY = 0;
        for (int y = 0; y < 16; ++y) {
            if (data[y] == null) continue;
            maxY = (y << 4) + 15;
        }
        this.maxY = maxY;
    }

    public String toString() {
        return String.format("(%d, %d) dim%d", this.x, this.z, this.dimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static MwChunk read(int x, int z, int dimension, RegionFileCache regionFileCache) {
        HashMap<BlockPos, TileEntity> TileEntityMap;
        ExtendedBlockStorage[] data;
        byte[] biomeArray;
        block18: {
            Boolean flag = true;
            biomeArray = null;
            data = new ExtendedBlockStorage[16];
            TileEntityMap = new HashMap<BlockPos, TileEntity>();
            FilterInputStream dis = null;
            RegionFile regionFile = regionFileCache.getRegionFile(x << 4, z << 4, dimension);
            if (!regionFile.isOpen() && regionFile.exists()) {
                regionFile.open();
            }
            if (regionFile.isOpen()) {
                dis = regionFile.getChunkDataInputStream(x & 0x1F, z & 0x1F);
            }
            if (dis != null) {
                block17: {
                    NBTTagCompound nbttagcompound = CompressedStreamTools.func_74794_a(dis);
                    NBTTagCompound level = nbttagcompound.func_74775_l("Level");
                    int xNbt = level.func_74762_e("xPos");
                    int zNbt = level.func_74762_e("zPos");
                    if (xNbt != x || zNbt != z) {
                        Logging.logWarning("chunk (%d, %d) has NBT coords (%d, %d)", x, z, xNbt, zNbt);
                    }
                    NBTTagList sections = level.func_150295_c("Sections", 10);
                    for (int k = 0; k < sections.func_74745_c(); ++k) {
                        NBTTagCompound section = sections.func_150305_b(k);
                        byte y = section.func_74771_c("Y");
                        ExtendedBlockStorage extendedblockstorage = new ExtendedBlockStorage(y << 4, flag.booleanValue());
                        byte[] abyte = nbttagcompound.func_74770_j("Blocks");
                        NibbleArray nibblearray = new NibbleArray(nbttagcompound.func_74770_j("Data"));
                        NibbleArray nibblearray1 = nbttagcompound.func_150297_b("Add", 7) ? new NibbleArray(nbttagcompound.func_74770_j("Add")) : null;
                        extendedblockstorage.func_186049_g().func_186019_a(abyte, nibblearray, nibblearray1);
                        extendedblockstorage.func_76659_c(new NibbleArray(nbttagcompound.func_74770_j("BlockLight")));
                        if (flag.booleanValue()) {
                            extendedblockstorage.func_76666_d(new NibbleArray(nbttagcompound.func_74770_j("SkyLight")));
                        }
                        extendedblockstorage.func_76672_e();
                        data[y] = extendedblockstorage;
                    }
                    biomeArray = level.func_74770_j("Biomes");
                    NBTTagList nbttaglist2 = level.func_150295_c("TileEntities", 10);
                    if (nbttaglist2 == null) break block17;
                    for (int i1 = 0; i1 < nbttaglist2.func_74745_c(); ++i1) {
                        NBTTagCompound nbttagcompound4 = nbttaglist2.func_150305_b(i1);
                        TileEntity tileentity = TileEntity.func_189514_c((NBTTagCompound)nbttagcompound4);
                        if (tileentity == null) continue;
                        TileEntityMap.put(tileentity.func_174877_v(), tileentity);
                    }
                }
                try {
                    dis.close();
                }
                catch (IOException e) {
                    Logging.logError("MwChunk.read: %s while closing input stream", e);
                }
                break block18;
                catch (IOException e) {
                    try {
                        Logging.logError("%s: could not read chunk (%d, %d) from region file\n", e, x, z);
                    }
                    catch (Throwable throwable) {
                        try {
                            dis.close();
                        }
                        catch (IOException e2) {
                            Logging.logError("MwChunk.read: %s while closing input stream", e2);
                        }
                        throw throwable;
                    }
                    try {
                        dis.close();
                    }
                    catch (IOException e3) {
                        Logging.logError("MwChunk.read: %s while closing input stream", e3);
                    }
                }
            }
        }
        return new MwChunk(x, z, dimension, data, biomeArray, TileEntityMap);
    }

    public boolean isEmpty() {
        return this.maxY <= 0;
    }

    @Override
    public int getBiome(int x, int y, int z) {
        int j = z & 0xF;
        int i = x & 0xF;
        int k = this.biomeArray[j << 4 | i] & 0xFF;
        if (k == 255) {
            Biome biome = Minecraft.func_71410_x().field_71441_e.func_72959_q().func_180300_a(new BlockPos(k, k, k), Biomes.field_76772_c);
            k = Biome.func_185362_a((Biome)biome);
        }
        return k;
    }

    @Override
    public int getLightValue(int x, int y, int z) {
        return 15;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    public static void carpenterdata() {
        try {
            Class<?> act = Class.forName("com.carpentersblocks.tileentity.TEBase");
            CarpenterMethod = act.getMethod("getAttribute", Byte.TYPE);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static void FMPdata() {
        try {
            Class<?> act = Class.forName("codechicken.multipart.TileMultipart");
            FMPMethodParts = act.getMethod("jPartList", new Class[0]);
            act = Class.forName("codechicken.microblock.Microblock");
            FMPMethodMaterial = act.getMethod("getIMaterial", new Class[0]);
            act = Class.forName("codechicken.microblock.BlockMicroMaterial");
            FMPFieldBlock = act.getDeclaredField("block");
            FMPFieldBlock.setAccessible(true);
            FMPFieldMeta = act.getDeclaredField("meta");
            FMPFieldMeta.setAccessible(true);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    @Override
    public IBlockState getBlockState(int x, int y, int z) {
        int yi = y >> 4 & 0xF;
        return this.dataArray != null && this.dataArray[yi] != null ? this.dataArray[yi].func_186049_g().func_186016_a(x & 0xF, y & 0xF, z & 0xF) : Blocks.field_150350_a.func_176223_P();
    }

    private NBTTagCompound writeChunkToNBT() {
        NBTTagCompound level = new NBTTagCompound();
        NBTTagCompound compound = new NBTTagCompound();
        level.func_74782_a("Level", (NBTBase)compound);
        compound.func_74768_a("xPos", this.x);
        compound.func_74768_a("zPos", this.z);
        ExtendedBlockStorage[] aextendedblockstorage = this.dataArray;
        NBTTagList nbttaglist = new NBTTagList();
        boolean flag = true;
        for (ExtendedBlockStorage extendedblockstorage : aextendedblockstorage) {
            if (extendedblockstorage == Chunk.field_186036_a) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Y", (byte)(extendedblockstorage.func_76662_d() >> 4 & 0xFF));
            byte[] abyte = new byte[4096];
            NibbleArray nibblearray = new NibbleArray();
            NibbleArray nibblearray1 = extendedblockstorage.func_186049_g().func_186017_a(abyte, nibblearray);
            nbttagcompound.func_74773_a("Blocks", abyte);
            nbttagcompound.func_74773_a("Data", nibblearray.func_177481_a());
            if (nibblearray1 != null) {
                nbttagcompound.func_74773_a("Add", nibblearray1.func_177481_a());
            }
            nbttagcompound.func_74773_a("BlockLight", extendedblockstorage.func_76661_k().func_177481_a());
            if (extendedblockstorage.func_76671_l() != null && extendedblockstorage.func_76671_l().func_177481_a() != null) {
                nbttagcompound.func_74773_a("SkyLight", extendedblockstorage.func_76671_l().func_177481_a());
            } else {
                nbttagcompound.func_74773_a("SkyLight", new byte[extendedblockstorage.func_76661_k().func_177481_a().length]);
            }
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Sections", (NBTBase)nbttaglist);
        compound.func_74773_a("Biomes", this.biomeArray);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (TileEntity tileentity : this.tileentityMap.values()) {
            try {
                NBTTagCompound nbttagcompound3 = tileentity.func_189515_b(new NBTTagCompound());
                nbttaglist2.func_74742_a((NBTBase)nbttagcompound3);
            }
            catch (Exception exception) {}
        }
        compound.func_74782_a("TileEntities", (NBTBase)nbttaglist2);
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized boolean write(RegionFileCache regionFileCache) {
        boolean error;
        block11: {
            block12: {
                block13: {
                    error = false;
                    RegionFile regionFile = regionFileCache.getRegionFile(this.x << 4, this.z << 4, this.dimension);
                    if (!regionFile.isOpen()) {
                        error = regionFile.open();
                    }
                    if (error) break block12;
                    DataOutputStream dos = regionFile.getChunkDataOutputStream(this.x & 0x1F, this.z & 0x1F);
                    if (dos == null) break block13;
                    CompressedStreamTools.func_74800_a((NBTTagCompound)this.writeChunkToNBT(), (DataOutput)dos);
                    try {
                        dos.close();
                    }
                    catch (IOException e) {
                        Logging.logError("%s while closing chunk data output stream", e);
                    }
                    break block11;
                    catch (IOException e) {
                        try {
                            Logging.logError("%s: could not write chunk (%d, %d) to region file", e, this.x, this.z);
                            error = true;
                        }
                        catch (Throwable throwable) {
                            try {
                                dos.close();
                            }
                            catch (IOException e2) {
                                Logging.logError("%s while closing chunk data output stream", e2);
                            }
                            throw throwable;
                        }
                        try {
                            dos.close();
                        }
                        catch (IOException e3) {
                            Logging.logError("%s while closing chunk data output stream", e3);
                        }
                        break block11;
                    }
                }
                Logging.logError("error: could not get output stream for chunk (%d, %d)", this.x, this.z);
                break block11;
            }
            Logging.logError("error: could not open region file for chunk (%d, %d)", this.x, this.z);
        }
        return error;
    }

    public Long getCoordIntPair() {
        return ChunkPos.func_77272_a((int)this.x, (int)this.z);
    }
}

