/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.tasks;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import mapwriter.Mw;
import mapwriter.map.MapTexture;
import mapwriter.region.MwChunk;
import mapwriter.region.RegionManager;
import mapwriter.tasks.Task;
import net.minecraft.util.math.ChunkPos;

public class UpdateSurfaceChunksTask
extends Task {
    private MwChunk chunk;
    private RegionManager regionManager;
    private MapTexture mapTexture;
    private AtomicBoolean Running = new AtomicBoolean();
    private static Map chunksUpdating = new HashMap();

    public UpdateSurfaceChunksTask(Mw mw, MwChunk chunk) {
        this.mapTexture = mw.mapTexture;
        this.regionManager = mw.regionManager;
        this.chunk = chunk;
    }

    @Override
    public void run() {
        this.Running.set(true);
        if (this.chunk != null) {
            this.regionManager.updateChunk(this.chunk);
            this.mapTexture.updateArea(this.regionManager, this.chunk.x << 4, this.chunk.z << 4, 16, 16, this.chunk.dimension);
        }
    }

    @Override
    public void onComplete() {
        Long coords = this.chunk.getCoordIntPair();
        chunksUpdating.remove(coords);
        this.Running.set(false);
    }

    public void UpdateChunkData(MwChunk chunk) {
        this.chunk = chunk;
    }

    @Override
    public boolean CheckForDuplicate() {
        Long coords = ChunkPos.func_77272_a((int)this.chunk.x, (int)this.chunk.z);
        if (!chunksUpdating.containsKey(coords)) {
            chunksUpdating.put(coords, this);
            return false;
        }
        UpdateSurfaceChunksTask task2 = (UpdateSurfaceChunksTask)chunksUpdating.get(coords);
        if (task2.Running.get()) {
            chunksUpdating.put(coords, this);
            return false;
        }
        task2.UpdateChunkData(this.chunk);
        return true;
    }
}

