/*
 * Decompiled with CFR 0.152.
 */
package nex.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nex.block.BlockNetherEx;
import nex.block.BlockNetherrack;
import nex.init.NetherExBlocks;

public class BlockNetherrackPath
extends BlockNetherEx {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    private static final AxisAlignedBB PATH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);

    public BlockNetherrackPath() {
        super("block_netherrack_path", Material.field_151576_e);
        this.func_149713_g(255);
        this.func_149711_c(0.4f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PATH_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        switch (facing) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState testState = world.func_180495_p(pos.func_177972_a(facing));
                Block block = testState.func_177230_c();
                return !testState.func_185914_p() && block != Blocks.field_150458_ak && block != Blocks.field_185774_da && block != NetherExBlocks.BLOCK_NETHERRACK_PATH;
            }
        }
        return super.func_176225_a(state, world, pos, facing);
    }

    public void func_149666_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumType type : EnumType.values()) {
            list.add((Object)new ItemStack(item, 1, type.ordinal()));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this.func_180660_a(state, player.func_70681_au(), 0), 1, this.func_180651_a(state));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            if (state.func_177229_b(TYPE) == EnumType.NORMAL) {
                world.func_175656_a(pos, Blocks.field_150424_aL.func_176223_P());
            } else {
                world.func_175656_a(pos, NetherExBlocks.BLOCK_NETHERRACK.func_176223_P().func_177226_a(BlockNetherrack.TYPE, (Comparable)((Object)BlockNetherrack.EnumType.fromMeta(((EnumType)((Object)state.func_177229_b(TYPE))).ordinal() - 1))));
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            if (state.func_177229_b(TYPE) == EnumType.NORMAL) {
                world.func_175656_a(pos, Blocks.field_150424_aL.func_176223_P());
            } else {
                world.func_175656_a(pos, NetherExBlocks.BLOCK_NETHERRACK.func_176223_P().func_177226_a(BlockNetherrack.TYPE, (Comparable)((Object)BlockNetherrack.EnumType.fromMeta(((EnumType)((Object)state.func_177229_b(TYPE))).ordinal() - 1))));
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(TYPE) == EnumType.NORMAL ? Item.func_150898_a((Block)Blocks.field_150424_aL) : Item.func_150898_a((Block)NetherExBlocks.BLOCK_NETHERRACK);
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177229_b(TYPE) == EnumType.NORMAL ? ((EnumType)((Object)state.func_177229_b(TYPE))).ordinal() : ((EnumType)((Object)state.func_177229_b(TYPE))).ordinal() - 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public static enum EnumType implements IStringSerializable
    {
        NORMAL,
        FIERY,
        ICY,
        LIVELY,
        GLOOMY;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= EnumType.values().length) {
                meta = 0;
            }
            return EnumType.values()[meta];
        }
    }
}

