/*
 * Decompiled with CFR 0.152.
 */
package nex.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import nex.block.BlockTileEntity;
import nex.init.NetherExEffects;
import nex.tileentity.TileEntityUrnOfSorrow;

public class BlockUrnOfSorrow
extends BlockTileEntity<TileEntityUrnOfSorrow> {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    private static final AxisAlignedBB URN_AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);

    public BlockUrnOfSorrow() {
        super("tile_urn_sorrow", Material.field_151576_e, TileEntityUrnOfSorrow.class);
        this.func_149711_c(0.5f);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return URN_AABB;
    }

    public void func_149666_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumType type : EnumType.values()) {
            list.add((Object)new ItemStack(item, 1, type.ordinal()));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityUrnOfSorrow altar = (TileEntityUrnOfSorrow)world.func_175625_s(pos);
        if (altar == null) {
            return false;
        }
        ItemStackHandler inventory = altar.getInventory();
        ItemStack inventoryStack = inventory.getStackInSlot(0);
        ItemStack heldStack = player.func_184614_ca();
        if (!player.func_70093_af()) {
            if (heldStack.func_77973_b() == Items.field_151068_bn && state.func_177229_b(TYPE) == EnumType.EMPTY) {
                for (PotionEffect effect : PotionUtils.func_185189_a((ItemStack)heldStack)) {
                    if (effect.func_188419_a() != NetherExEffects.LOST) continue;
                    player.func_184614_ca().func_190918_g(1);
                    world.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumType.FULL)));
                }
            } else if (inventoryStack.func_190926_b() && !player.func_184614_ca().func_190926_b()) {
                inventory.setStackInSlot(0, player.func_184614_ca().func_77979_a(1));
            }
        } else if (!inventoryStack.func_190926_b() && altar.getSummoningTime() == 0) {
            if (!world.field_72995_K) {
                altar.spawnItemStack(world, pos.func_177984_a(), inventory.getStackInSlot(0));
            }
            inventory.setStackInSlot(0, ItemStack.field_190927_a);
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TileEntityUrnOfSorrow altar = (TileEntityUrnOfSorrow)world.func_175625_s(pos);
        if (altar == null) {
            return 0.5f;
        }
        return altar.canBreak() ? 0.5f : -1.0f;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public static enum EnumType implements IStringSerializable
    {
        EMPTY,
        FULL;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= EnumType.values().length) {
                meta = 0;
            }
            return EnumType.values()[meta];
        }
    }
}

