/*
 * Decompiled with CFR 0.152.
 */
package nex.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemapHandler {
    private static final Map<String, String> customNames = ImmutableMap.builder().build();
    private static List<Predicate<FMLMissingMappingsEvent.MissingMapping>> mappingsToFix = ImmutableList.of(RemapHandler::remapRegistryName);
    private static final Logger LOGGER = LogManager.getLogger((String)"NetherEx|RemapHandler");

    public static void remap(List<FMLMissingMappingsEvent.MissingMapping> mappings) {
        LOGGER.info("Fix Missing Mappings started.");
        for (FMLMissingMappingsEvent.MissingMapping mapping : mappings) {
            for (Predicate<FMLMissingMappingsEvent.MissingMapping> remappingFunction : mappingsToFix) {
                if (remappingFunction.test(mapping)) break;
            }
        }
        LOGGER.info("Fix Missing Mappings completed.");
    }

    private static boolean attemptRemap(FMLMissingMappingsEvent.MissingMapping mapping, ResourceLocation registryName) {
        switch (mapping.type) {
            case BLOCK: {
                IForgeRegistry blockRegistry = ForgeRegistries.BLOCKS;
                if (!blockRegistry.containsKey(registryName)) break;
                mapping.remap((Block)blockRegistry.getValue(registryName));
                return true;
            }
            case ITEM: {
                IForgeRegistry itemRegistry = ForgeRegistries.ITEMS;
                if (!itemRegistry.containsKey(registryName)) break;
                mapping.remap((Item)itemRegistry.getValue(registryName));
                return true;
            }
        }
        return false;
    }

    private static boolean remapRegistryName(FMLMissingMappingsEvent.MissingMapping mapping) {
        String missingPath = mapping.resourceLocation.func_110623_a();
        if (!customNames.containsKey(missingPath)) {
            return false;
        }
        String newPath = customNames.get(missingPath);
        ResourceLocation registryName = new ResourceLocation(mapping.resourceLocation.func_110624_b() + newPath);
        return RemapHandler.attemptRemap(mapping, registryName);
    }
}

