/*
 * Decompiled with CFR 0.152.
 */
package nex.init;

import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import nex.world.WorldProviderNether;
import nex.world.biome.BiomeArcticAbyss;
import nex.world.biome.BiomeFungiForest;
import nex.world.biome.BiomeHell;
import nex.world.biome.BiomeRuthlessSands;
import nex.world.biome.BiomeTorridWasteland;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@GameRegistry.ObjectHolder(value="nex")
public class NetherExBiomes {
    @GameRegistry.ObjectHolder(value="hell")
    public static final BiomeHell HELL = null;
    @GameRegistry.ObjectHolder(value="ruthless_sands")
    public static final BiomeRuthlessSands RUTHLESS_SANDS = null;
    @GameRegistry.ObjectHolder(value="fungi_forest")
    public static final BiomeFungiForest FUNGI_FOREST = null;
    @GameRegistry.ObjectHolder(value="torrid_wasteland")
    public static final BiomeTorridWasteland TORRID_WASTELAND = null;
    @GameRegistry.ObjectHolder(value="arctic_abyss")
    public static final BiomeArcticAbyss ARCTIC_ABYSS = null;
    private static final Logger LOGGER = LogManager.getLogger((String)"NetherEx|NetherExBiomes");

    public static void init() {
        BiomeDictionary.addTypes((Biome)HELL, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY});
        BiomeDictionary.addTypes((Biome)RUTHLESS_SANDS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY});
        BiomeDictionary.addTypes((Biome)FUNGI_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.MUSHROOM});
        BiomeDictionary.addTypes((Biome)TORRID_WASTELAND, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.addTypes((Biome)ARCTIC_ABYSS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER, BiomeDictionary.Type.WET, BiomeDictionary.Type.COLD});
    }

    public static void postInit() {
        DimensionManager.unregisterDimension((int)-1);
        DimensionType nether = DimensionType.register((String)"Nether", (String)"_nether", (int)-1, WorldProviderNether.class, (boolean)false);
        DimensionManager.registerDimension((int)-1, (DimensionType)nether);
        LOGGER.info("The Nether has been overridden.");
    }

    @Mod.EventBusSubscriber(modid="nex")
    public static class EventHandler {
        @SubscribeEvent
        public static void onRegisterBiomes(RegistryEvent.Register<Biome> event) {
            LOGGER.info("Biome registration started.");
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Biome[]{new BiomeHell(), new BiomeRuthlessSands(), new BiomeFungiForest(), new BiomeTorridWasteland(), new BiomeArcticAbyss()});
            LOGGER.info("Biome registration completed.");
        }
    }
}

