/*
 * Decompiled with CFR 0.152.
 */
package nex.init;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraftforge.oredict.ShapedOreRecipe;
import nex.block.BlockBasalt;
import nex.block.BlockNetherrack;
import nex.init.NetherExBlocks;
import nex.init.NetherExEffectTypes;
import nex.init.NetherExItems;
import nex.util.NBTUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetherExRecipes {
    private static final Logger LOGGER = LogManager.getLogger((String)"NetherEx|NetherExRecipes");

    public static void init() {
        LOGGER.info("Recipe registration started.");
        NBTTagCompound variant = new NBTTagCompound();
        variant.func_74757_a("Variant", true);
        NetherExRecipes.removeRecipe(Item.func_150898_a((Block)Blocks.field_150386_bk));
        NetherExRecipes.add1x1Recipe(new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, 0), new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, 1));
        NetherExRecipes.add1x1Recipe(new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, 1), new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, 2));
        NetherExRecipes.add1x1Recipe(new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, 2), new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, 3));
        NetherExRecipes.add2x2Recipe(new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 4, 1), new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, 0));
        NetherExRecipes.add2x2Recipe(new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 4, 2), new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, 1));
        NetherExRecipes.add2x2Recipe(new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 4, 3), new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, 2));
        for (BlockNetherrack.EnumType enumType : BlockNetherrack.EnumType.values()) {
            NetherExRecipes.addSmelting(new ItemStack((Item)NetherExItems.ITEM_BRICK_NETHER, 1, enumType.ordinal()), new ItemStack((Block)NetherExBlocks.BLOCK_NETHERRACK, 1, enumType.ordinal()), 0.5f);
            NetherExRecipes.add2x2Recipe(new ItemStack((Block)NetherExBlocks.BLOCK_BRICK_NETHER, 4, enumType.ordinal()), new ItemStack((Item)NetherExItems.ITEM_BRICK_NETHER, 1, enumType.ordinal()));
            NetherExRecipes.addSlabRecipe(new ItemStack((Block)NetherExBlocks.SLAB_BRICK_NETHER, 6, enumType.ordinal()), new ItemStack((Block)NetherExBlocks.BLOCK_BRICK_NETHER, 1, enumType.ordinal()));
            NetherExRecipes.addWallRecipe(new ItemStack((Block)NetherExBlocks.WALL_BRICK_NETHER, 6, enumType.ordinal()), new ItemStack((Block)NetherExBlocks.BLOCK_BRICK_NETHER, 1, enumType.ordinal()));
        }
        NetherExRecipes.addSmelting(new ItemStack((Block)NetherExBlocks.BLOCK_GLASS_SOUL, 1, 0), new ItemStack(Blocks.field_150425_aM, 1, 0), 0.5f);
        NetherExRecipes.addPaneRecipe(new ItemStack((Block)NetherExBlocks.BLOCK_GLASS_PANE_SOUL, 16, 0), new ItemStack((Block)NetherExBlocks.BLOCK_GLASS_SOUL, 1, 0));
        NetherExRecipes.add3x3Recipe(new ItemStack((Block)NetherExBlocks.BLOCK_RIME, 1, 0), new ItemStack((Item)NetherExItems.ITEM_CRYSTAL_RIME, 1, 0));
        NetherExRecipes.add3x3Recipe(new ItemStack((Block)NetherExBlocks.BLOCK_AMETHYST, 1, 0), new ItemStack((Item)NetherExItems.ITEM_CRYSTAL_AMETHYST, 1, 0));
        NetherExRecipes.add2x3Recipe(new ItemStack((Block)NetherExBlocks.BLOCK_BONE_SLIVER, 1, 0), new ItemStack(Items.field_151100_aR, 6, EnumDyeColor.WHITE.func_176767_b()));
        NetherExRecipes.add1x3Recipe(new ItemStack((Block)NetherExBlocks.BLOCK_BONE_CHUNK, 1, 0), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.WHITE.func_176767_b()));
        NetherExRecipes.addSlabRecipe(new ItemStack((Block)NetherExBlocks.SLAB_VANILLA, 6, 0), new ItemStack(Blocks.field_189879_dh, 1, 0));
        for (Enum enum_ : BlockBasalt.EnumType.values()) {
            NetherExRecipes.addSlabRecipe(new ItemStack((Block)NetherExBlocks.SLAB_BASALT, 6, enum_.ordinal()), new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, enum_.ordinal()));
            NetherExRecipes.addWallRecipe(new ItemStack((Block)NetherExBlocks.WALL_BASALT, 6, enum_.ordinal()), new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, enum_.ordinal()));
        }
        NetherExRecipes.addStairRecipe(new ItemStack((Block)NetherExBlocks.STAIRS_RED_BRICK_NETHER, 8, 0), new ItemStack(Blocks.field_189879_dh, 3, 0));
        NetherExRecipes.addStairRecipe(new ItemStack((Block)NetherExBlocks.STAIRS_BASALT_NORMAL, 8, 0), new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 3, 0));
        NetherExRecipes.addStairRecipe(new ItemStack((Block)NetherExBlocks.STAIRS_BASALT_SMOOTH, 8, 0), new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 3, 1));
        NetherExRecipes.addStairRecipe(new ItemStack((Block)NetherExBlocks.STAIRS_BASALT_BRICK, 8, 0), new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 3, 2));
        NetherExRecipes.addStairRecipe(new ItemStack((Block)NetherExBlocks.STAIRS_BASALT_PILLAR, 8, 0), new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 3, 3));
        NetherExRecipes.addStairRecipe(new ItemStack((Block)NetherExBlocks.STAIRS_BRICK_NETHER_FIERY, 8, 0), new ItemStack((Block)NetherExBlocks.BLOCK_BRICK_NETHER, 3, 0));
        NetherExRecipes.addStairRecipe(new ItemStack((Block)NetherExBlocks.STAIRS_BRICK_NETHER_ICY, 8, 0), new ItemStack((Block)NetherExBlocks.BLOCK_BRICK_NETHER, 3, 1));
        NetherExRecipes.addStairRecipe(new ItemStack((Block)NetherExBlocks.STAIRS_BRICK_NETHER_LIVELY, 8, 0), new ItemStack((Block)NetherExBlocks.BLOCK_BRICK_NETHER, 3, 2));
        NetherExRecipes.addStairRecipe(new ItemStack((Block)NetherExBlocks.STAIRS_BRICK_NETHER_GLOOMY, 8, 0), new ItemStack((Block)NetherExBlocks.BLOCK_BRICK_NETHER, 3, 3));
        NetherExRecipes.addWallRecipe(new ItemStack((Block)NetherExBlocks.WALL_VANILLA, 6, 0), new ItemStack(Blocks.field_150371_ca, 1, 0));
        NetherExRecipes.addWallRecipe(new ItemStack((Block)NetherExBlocks.WALL_VANILLA, 6, 1), new ItemStack(Blocks.field_150385_bj, 1, 0));
        NetherExRecipes.addWallRecipe(new ItemStack((Block)NetherExBlocks.WALL_VANILLA, 6, 2), new ItemStack(Blocks.field_189879_dh, 1, 0));
        NetherExRecipes.addFenceRecipe(new ItemStack((Block)NetherExBlocks.FENCE_VANILLA, 4, 0), new ItemStack((Block)NetherExBlocks.FENCE_GATE_QUARTZ, 4, 0), new ItemStack(Blocks.field_150371_ca, 1, 0), new ItemStack((Block)Blocks.field_150333_U, 1, 7));
        NetherExRecipes.addFenceRecipe(new ItemStack(Blocks.field_150386_bk, 4, 0), new ItemStack((Block)NetherExBlocks.FENCE_GATE_BRICK_NETHER, 4, 0), new ItemStack(Blocks.field_150385_bj, 1, 0), new ItemStack((Block)Blocks.field_150333_U, 1, 6));
        NetherExRecipes.addFenceRecipe(new ItemStack((Block)NetherExBlocks.FENCE_VANILLA, 4, 1), new ItemStack((Block)NetherExBlocks.FENCE_GATE_RED_BRICK_NETHER, 4, 0), new ItemStack(Blocks.field_189879_dh, 1, 0), new ItemStack((Block)NetherExBlocks.SLAB_VANILLA, 1, 0));
        NetherExRecipes.addFenceRecipe(new ItemStack((Block)NetherExBlocks.FENCE_BASALT, 4, 0), new ItemStack((Block)NetherExBlocks.FENCE_GATE_BASALT, 4, 0), new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, 0), new ItemStack((Block)NetherExBlocks.SLAB_BASALT, 1, 0));
        NetherExRecipes.addFenceRecipe(new ItemStack((Block)NetherExBlocks.FENCE_BASALT, 4, 1), new ItemStack((Block)NetherExBlocks.FENCE_GATE_BASALT_SMOOTH, 4, 0), new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, 1), new ItemStack((Block)NetherExBlocks.SLAB_BASALT, 1, 1));
        NetherExRecipes.addFenceRecipe(new ItemStack((Block)NetherExBlocks.FENCE_BASALT, 4, 2), new ItemStack((Block)NetherExBlocks.FENCE_GATE_BASALT_BRICK, 4, 0), new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, 2), new ItemStack((Block)NetherExBlocks.SLAB_BASALT, 1, 2));
        NetherExRecipes.addFenceRecipe(new ItemStack((Block)NetherExBlocks.FENCE_BASALT, 4, 3), new ItemStack((Block)NetherExBlocks.FENCE_GATE_BASALT_PILLAR, 4, 0), new ItemStack((Block)NetherExBlocks.BLOCK_BASALT, 1, 3), new ItemStack((Block)NetherExBlocks.SLAB_BASALT, 1, 3));
        NetherExRecipes.addFenceRecipe(new ItemStack((Block)NetherExBlocks.FENCE_BRICK_NETHER, 4, 0), new ItemStack((Block)NetherExBlocks.FENCE_GATE_BRICK_NETHER_FIERY, 4, 0), new ItemStack((Block)NetherExBlocks.BLOCK_BRICK_NETHER, 1, 0), new ItemStack((Block)NetherExBlocks.SLAB_BRICK_NETHER, 1, 0));
        NetherExRecipes.addFenceRecipe(new ItemStack((Block)NetherExBlocks.FENCE_BRICK_NETHER, 4, 1), new ItemStack((Block)NetherExBlocks.FENCE_GATE_BRICK_NETHER_ICY, 4, 0), new ItemStack((Block)NetherExBlocks.BLOCK_BRICK_NETHER, 1, 1), new ItemStack((Block)NetherExBlocks.SLAB_BRICK_NETHER, 1, 1));
        NetherExRecipes.addFenceRecipe(new ItemStack((Block)NetherExBlocks.FENCE_BRICK_NETHER, 4, 2), new ItemStack((Block)NetherExBlocks.FENCE_GATE_BRICK_NETHER_LIVELY, 4, 0), new ItemStack((Block)NetherExBlocks.BLOCK_BRICK_NETHER, 1, 2), new ItemStack((Block)NetherExBlocks.SLAB_BRICK_NETHER, 1, 2));
        NetherExRecipes.addFenceRecipe(new ItemStack((Block)NetherExBlocks.FENCE_BRICK_NETHER, 4, 3), new ItemStack((Block)NetherExBlocks.FENCE_GATE_BRICK_NETHER_GLOOMY, 4, 0), new ItemStack((Block)NetherExBlocks.BLOCK_BRICK_NETHER, 1, 3), new ItemStack((Block)NetherExBlocks.SLAB_BRICK_NETHER, 1, 3));
        NetherExRecipes.addShapeless(new ItemStack(Items.field_151100_aR, 6, EnumDyeColor.WHITE.func_176767_b()), new ItemStack((Block)NetherExBlocks.BLOCK_BONE_SLIVER, 1, 0));
        NetherExRecipes.addShapeless(new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.WHITE.func_176767_b()), new ItemStack((Block)NetherExBlocks.BLOCK_BONE_CHUNK, 1, 0));
        NetherExRecipes.add1x1Recipe(new ItemStack((Item)NetherExItems.ITEM_DUST_WITHER, 3, 0), new ItemStack((Item)NetherExItems.ITEM_BONE_WITHER, 1, 0));
        NetherExRecipes.add1x1Recipe(new ItemStack((Item)NetherExItems.ITEM_CRYSTAL_RIME, 9, 0), new ItemStack((Block)NetherExBlocks.BLOCK_RIME, 1, 0));
        NetherExRecipes.add1x1Recipe(new ItemStack((Item)NetherExItems.ITEM_CRYSTAL_AMETHYST, 9, 0), new ItemStack((Block)NetherExBlocks.BLOCK_AMETHYST, 1, 0));
        NetherExRecipes.addBoatRecipe(new ItemStack((Item)NetherExItems.ITEM_BOAT_OBSIDIAN, 1, 0), new ItemStack(Blocks.field_150343_Z, 1, 0));
        NetherExRecipes.addShapeless(new ItemStack((Item)NetherExItems.ITEM_CRYSTAL_RIME_STEEL, 1, 0), new ItemStack(Items.field_151033_d, 1, 0), new ItemStack((Item)NetherExItems.ITEM_CRYSTAL_RIME, 1, 0));
        NetherExRecipes.addSmelting(new ItemStack(Items.field_151128_bU, 1, 0), new ItemStack((Block)NetherExBlocks.ORE_QUARTZ, 1, 0), 0.0f);
        NetherExRecipes.addSmelting(new ItemStack((Item)NetherExItems.ITEM_CRYSTAL_AMETHYST, 1, 0), new ItemStack((Block)NetherExBlocks.ORE_AMETHYST, 1, 0), 0.0f);
        NetherExRecipes.addSmelting(new ItemStack((Item)NetherExItems.ITEM_CRYSTAL_RIME, 1, 0), new ItemStack((Block)NetherExBlocks.ORE_RIME, 1, 0), 0.0f);
        NetherExRecipes.addSmelting(new ItemStack((Item)NetherExItems.FOOD_MEAT_GHAST_COOKED, 1, 0), new ItemStack((Item)NetherExItems.FOOD_MEAT_GHAST_RAW, 1, 0), 0.5f);
        NetherExRecipes.addSmelting(new ItemStack((Item)NetherExItems.FOOD_MAGMA_CREAM_CONGEALED, 1, 0), new ItemStack(Items.field_151064_bs, 1, 0), 0.5f);
        NetherExRecipes.addSwordRecipe(new ItemStack((Item)NetherExItems.TOOL_SWORD_BONE, 1, 0), new ItemStack(Items.field_151043_k, 1, 0), new ItemStack((Item)NetherExItems.ITEM_BONE_WITHER, 1, 0));
        NetherExRecipes.addPickaxeRecipe(new ItemStack((Item)NetherExItems.TOOL_PICKAXE_BONE, 1, 0), new ItemStack(Items.field_151043_k, 1, 0), new ItemStack((Item)NetherExItems.ITEM_BONE_WITHER, 1, 0));
        NetherExRecipes.addShovelRecipe(new ItemStack((Item)NetherExItems.TOOL_SHOVEL_BONE, 1, 0), new ItemStack(Items.field_151043_k, 1, 0), new ItemStack((Item)NetherExItems.ITEM_BONE_WITHER, 1, 0));
        NetherExRecipes.addAxeRecipe(new ItemStack((Item)NetherExItems.TOOL_AXE_BONE, 1, 0), new ItemStack(Items.field_151043_k, 1, 0), new ItemStack((Item)NetherExItems.ITEM_BONE_WITHER, 1, 0));
        NetherExRecipes.addHoeRecipe(new ItemStack((Item)NetherExItems.TOOL_HOE_BONE, 1, 0), new ItemStack(Items.field_151043_k, 1, 0), new ItemStack((Item)NetherExItems.ITEM_BONE_WITHER, 1, 0));
        NetherExRecipes.addPickaxeRecipe(new ItemStack((Item)NetherExItems.TOOL_HAMMER_BONE, 1, 0), new ItemStack(Blocks.field_150340_R, 1, 0), new ItemStack((Item)NetherExItems.ITEM_BONE_WITHER, 1, 0));
        NetherExRecipes.addShovelRecipe(new ItemStack((Item)NetherExItems.TOOL_SWORD_BONE, 1, 0), new ItemStack(Items.field_151010_B, 1, 0), new ItemStack((Item)NetherExItems.ITEM_BONE_WITHER, 1, 0));
        NetherExRecipes.addShovelRecipe(new ItemStack((Item)NetherExItems.TOOL_PICKAXE_BONE, 1, 0), new ItemStack(Items.field_151005_D, 1, 0), new ItemStack((Item)NetherExItems.ITEM_BONE_WITHER, 1, 0));
        NetherExRecipes.addShovelRecipe(new ItemStack((Item)NetherExItems.TOOL_SHOVEL_BONE, 1, 0), new ItemStack(Items.field_151011_C, 1, 0), new ItemStack((Item)NetherExItems.ITEM_BONE_WITHER, 1, 0));
        NetherExRecipes.addShovelRecipe(new ItemStack((Item)NetherExItems.TOOL_AXE_BONE, 1, 0), new ItemStack(Items.field_151006_E, 1, 0), new ItemStack((Item)NetherExItems.ITEM_BONE_WITHER, 1, 0));
        NetherExRecipes.addShovelRecipe(new ItemStack((Item)NetherExItems.TOOL_HOE_BONE, 1, 0), new ItemStack(Items.field_151013_M, 1, 0), new ItemStack((Item)NetherExItems.ITEM_BONE_WITHER, 1, 0));
        NetherExRecipes.addHelmetRecipe(new ItemStack((Item)NetherExItems.ARMOR_HELMET_BONE, 1, 0), new ItemStack((Item)NetherExItems.ITEM_BONE_WITHER, 1, 0));
        NetherExRecipes.addChestplateRecipe(new ItemStack((Item)NetherExItems.ARMOR_CHESTPLATE_BONE, 1, 0), new ItemStack((Item)NetherExItems.ITEM_BONE_WITHER, 1, 0));
        NetherExRecipes.addLeggingsRecipe(new ItemStack((Item)NetherExItems.ARMOR_LEGGINGS_BONE, 1, 0), new ItemStack((Item)NetherExItems.ITEM_BONE_WITHER, 1, 0));
        NetherExRecipes.addBootsRecipe(new ItemStack((Item)NetherExItems.ARMOR_BOOTS_BONE, 1, 0), new ItemStack((Item)NetherExItems.ITEM_BONE_WITHER, 1, 0));
        NetherExRecipes.addHelmetRecipe(new ItemStack((Item)NetherExItems.ARMOR_HELMET_HIDE_SALAMANDER, 1, 0), new ItemStack((Item)NetherExItems.ITEM_HIDE_SALAMANDER, 1, 0));
        NetherExRecipes.addChestplateRecipe(new ItemStack((Item)NetherExItems.ARMOR_CHESTPLATE_HIDE_SALAMANDER, 1, 0), new ItemStack((Item)NetherExItems.ITEM_HIDE_SALAMANDER, 1, 0));
        NetherExRecipes.addLeggingsRecipe(new ItemStack((Item)NetherExItems.ARMOR_LEGGINGS_HIDE_SALAMANDER, 1, 0), new ItemStack((Item)NetherExItems.ITEM_HIDE_SALAMANDER, 1, 0));
        NetherExRecipes.addBootsRecipe(new ItemStack((Item)NetherExItems.ARMOR_BOOTS_HIDE_SALAMANDER, 1, 0), new ItemStack((Item)NetherExItems.ITEM_HIDE_SALAMANDER, 1, 0));
        NetherExRecipes.addHelmetRecipe(NBTUtil.setTag(new ItemStack((Item)NetherExItems.ARMOR_HELMET_HIDE_SALAMANDER, 1, 0), variant), new ItemStack((Item)NetherExItems.ITEM_HIDE_SALAMANDER, 1, 1));
        NetherExRecipes.addChestplateRecipe(NBTUtil.setTag(new ItemStack((Item)NetherExItems.ARMOR_CHESTPLATE_HIDE_SALAMANDER, 1, 0), variant), new ItemStack((Item)NetherExItems.ITEM_HIDE_SALAMANDER, 1, 1));
        NetherExRecipes.addLeggingsRecipe(NBTUtil.setTag(new ItemStack((Item)NetherExItems.ARMOR_LEGGINGS_HIDE_SALAMANDER, 1, 0), variant), new ItemStack((Item)NetherExItems.ITEM_HIDE_SALAMANDER, 1, 1));
        NetherExRecipes.addBootsRecipe(NBTUtil.setTag(new ItemStack((Item)NetherExItems.ARMOR_BOOTS_HIDE_SALAMANDER, 1, 0), variant), new ItemStack((Item)NetherExItems.ITEM_HIDE_SALAMANDER, 1, 1));
        NetherExRecipes.addBrewing(PotionTypes.field_185233_e, NetherExItems.ITEM_CRYSTAL_RIME, NetherExEffectTypes.NORMAL_FREEZE);
        NetherExRecipes.addBrewing(PotionTypes.field_185233_e, NetherExItems.ITEM_FANG_SPIDER_BONE, NetherExEffectTypes.NORMAL_FROSTBITE);
        NetherExRecipes.addBrewing(PotionTypes.field_185233_e, NetherExItems.ITEM_SPORE, NetherExEffectTypes.NORMAL_SPORE);
        NetherExRecipes.addBrewing(PotionTypes.field_185233_e, (Item)NetherExItems.FOOD_MEAT_GHAST_RAW, NetherExEffectTypes.NORMAL_LOST);
        LOGGER.info("Recipe registration completed.");
    }

    private static void addShaped(ItemStack result, Object ... input) {
        CraftingManager.func_77594_a().func_180302_a((IRecipe)new ShapedOreRecipe(result, input));
    }

    private static void addShapeless(ItemStack result, Object ... input) {
        CraftingManager.func_77594_a().func_77596_b(result, input);
    }

    private static void addSmelting(ItemStack output, ItemStack input, float xp) {
        FurnaceRecipes.func_77602_a().func_151394_a(input, output, xp);
    }

    private static void addBrewing(PotionType input, Item reagent, PotionType output) {
        PotionHelper.func_185204_a((PotionType)input, (Predicate)new PotionHelper.ItemPredicateInstance(reagent), (PotionType)output);
    }

    private static void add1x1Recipe(ItemStack result, ItemStack input) {
        NetherExRecipes.addShaped(result, "#", Character.valueOf('#'), input);
    }

    private static void add1x3Recipe(ItemStack result, ItemStack input) {
        NetherExRecipes.addShaped(result, "#", "#", "#", Character.valueOf('#'), input);
    }

    private static void add2x2Recipe(ItemStack result, ItemStack input) {
        NetherExRecipes.addShaped(result, "##", "##", Character.valueOf('#'), input);
    }

    private static void add2x3Recipe(ItemStack result, ItemStack input) {
        NetherExRecipes.addShaped(result, "##", "##", "##", Character.valueOf('#'), input);
    }

    private static void add3x3Recipe(ItemStack result, ItemStack input) {
        NetherExRecipes.addShaped(result, "###", "###", "###", Character.valueOf('#'), input);
    }

    private static void addPaneRecipe(ItemStack result, ItemStack input) {
        NetherExRecipes.addShaped(result, "###", "###", Character.valueOf('#'), input);
    }

    private static void addSurroundedRecipe(ItemStack result, ItemStack surrounding, ItemStack core) {
        NetherExRecipes.addShaped(result, "###", "#X#", "###", Character.valueOf('#'), surrounding, Character.valueOf('X'), core);
    }

    private static void addSlabRecipe(ItemStack result, ItemStack input) {
        NetherExRecipes.addShaped(result, "###", Character.valueOf('#'), input);
        NetherExRecipes.addShaped(input, "##", Character.valueOf('#'), result);
    }

    private static void addStairRecipe(ItemStack result, ItemStack input) {
        NetherExRecipes.addShaped(result, "#  ", "## ", "###", Character.valueOf('#'), input);
        NetherExRecipes.addShaped(input, "##", "##", Character.valueOf('#'), result);
    }

    private static void addFenceRecipe(ItemStack ... stacks) {
        NetherExRecipes.addShaped(stacks[0], "#X#", "#X#", Character.valueOf('#'), stacks[2], Character.valueOf('X'), stacks[3]);
        NetherExRecipes.addShaped(stacks[1], "#X#", "#X#", Character.valueOf('#'), stacks[3], Character.valueOf('X'), stacks[2]);
    }

    private static void addWallRecipe(ItemStack result, ItemStack input) {
        NetherExRecipes.addShaped(result, "###", "###", Character.valueOf('#'), input);
        NetherExRecipes.addShaped(input, "#", Character.valueOf('#'), result);
    }

    private static void addSwordRecipe(ItemStack result, ItemStack core, ItemStack handle) {
        NetherExRecipes.addShaped(result, " # ", " # ", " X ", Character.valueOf('#'), core, Character.valueOf('X'), handle);
    }

    private static void addPickaxeRecipe(ItemStack result, ItemStack core, ItemStack handle) {
        NetherExRecipes.addShaped(result, "###", " X ", " X ", Character.valueOf('#'), core, Character.valueOf('X'), handle);
    }

    private static void addShovelRecipe(ItemStack result, ItemStack core, ItemStack handle) {
        NetherExRecipes.addShaped(result, " # ", " X ", " X ", Character.valueOf('#'), core, Character.valueOf('X'), handle);
    }

    private static void addAxeRecipe(ItemStack result, ItemStack core, ItemStack handle) {
        NetherExRecipes.addShaped(result, "##", "#X", " X", Character.valueOf('#'), core, Character.valueOf('X'), handle);
    }

    private static void addHoeRecipe(ItemStack result, ItemStack core, ItemStack handle) {
        NetherExRecipes.addShaped(result, "##", " X", " X", Character.valueOf('#'), core, Character.valueOf('X'), handle);
    }

    private static void addHelmetRecipe(ItemStack result, ItemStack input) {
        NetherExRecipes.addShaped(result, "###", "# #", Character.valueOf('#'), input);
    }

    private static void addChestplateRecipe(ItemStack result, ItemStack input) {
        NetherExRecipes.addShaped(result, "# #", "###", "###", Character.valueOf('#'), input);
    }

    private static void addLeggingsRecipe(ItemStack result, ItemStack input) {
        NetherExRecipes.addShaped(result, "###", "# #", "# #", Character.valueOf('#'), input);
    }

    private static void addBootsRecipe(ItemStack result, ItemStack input) {
        NetherExRecipes.addShaped(result, "# #", "# #", Character.valueOf('#'), input);
    }

    private static void addBoatRecipe(ItemStack result, ItemStack input) {
        NetherExRecipes.addShaped(result, "# #", "###", Character.valueOf('#'), input);
    }

    private static void removeRecipe(Item output) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        Iterator iter = recipes.iterator();
        while (iter.hasNext()) {
            ItemStack stack = ((IRecipe)iter.next()).func_77571_b();
            if (stack.func_190926_b() || stack.func_77973_b() != output) continue;
            iter.remove();
        }
        LOGGER.info("Removed original recipe for %s", new Object[]{output.getRegistryName()});
    }
}

