/*
 * Decompiled with CFR 0.152.
 */
package nex.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import nex.init.NetherExBlocks;
import nex.init.NetherExMaterials;
import nex.item.ItemNetherExHoe;
import nex.util.NBTUtil;

public class ItemBoneHoe
extends ItemNetherExHoe {
    public ItemBoneHoe() {
        super("tool_hoe_bone", NetherExMaterials.TOOL_BONE_WITHERED_GOLD);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        NBTTagCompound compound = new NBTTagCompound();
        if (entity.field_71093_bK == DimensionType.NETHER.func_186068_a()) {
            compound.func_74757_a("Nether", true);
        } else {
            compound.func_74757_a("Nether", false);
        }
        NBTUtil.setTag(stack, compound);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        int hook = ForgeEventFactory.onHoeUse((ItemStack)stack, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (hook != 0) {
            return hook > 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (facing != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a())) {
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                this.func_185071_a(stack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                return EnumActionResult.SUCCESS;
            }
            if (block == Blocks.field_150346_d) {
                switch ((BlockDirt.DirtType)state.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        this.func_185071_a(stack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                        return EnumActionResult.SUCCESS;
                    }
                    case COARSE_DIRT: {
                        this.func_185071_a(stack, player, world, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                        return EnumActionResult.SUCCESS;
                    }
                }
            }
            if (block == Blocks.field_150425_aM) {
                this.func_185071_a(stack, player, world, pos, NetherExBlocks.BLOCK_SAND_SOUL_TILLED.func_176223_P());
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, EntityPlayer player, IBlockState state) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("Nether") && stack.func_77978_p().func_74767_n("Nether")) {
            return Item.ToolMaterial.IRON.func_77996_d();
        }
        return Item.ToolMaterial.GOLD.func_77996_d();
    }

    public void setDamage(ItemStack stack, int damage) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("Nether") && !stack.func_77978_p().func_74767_n("Nether")) {
            damage += 15;
            if (this.getDamage(stack) - 16 == 0) {
                ++damage;
            }
        }
        super.setDamage(stack, damage);
    }
}

