/*
 * Decompiled with CFR 0.152.
 */
package nex.util;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;
import nex.util.WorldUtil;
import nex.world.biome.NetherBiome;

public class BlockUtil {
    public static IBlockState getBlock(NetherBiome.BiomeBlock block, String fallback) {
        return Block.func_149684_b((String)(block.getId() == null || block.getId().isEmpty() || Block.func_149684_b((String)block.getId()) == null ? fallback : block.getId())).func_176203_a(block.getMeta());
    }

    public static Block getBlock(String blockId, String fallback) {
        return Block.func_149684_b((String)(blockId == null || blockId.isEmpty() || Block.func_149684_b((String)blockId) == null ? fallback : blockId));
    }

    public static boolean mine3x3(World world, ItemStack stack, BlockPos pos, EntityPlayer player) {
        BlockPos endPos;
        BlockPos startPos;
        RayTraceResult traceResult = WorldUtil.rayTraceFromEntity(world, (Entity)player, false, 4.5);
        if (traceResult == null) {
            return true;
        }
        EnumFacing sideHit = traceResult.field_178784_b;
        if (sideHit.func_176740_k() == EnumFacing.Axis.X) {
            startPos = new BlockPos(0, 1, 1);
            endPos = new BlockPos(0, -1, -1);
        } else if (sideHit.func_176740_k() == EnumFacing.Axis.Y) {
            startPos = new BlockPos(1, 0, 1);
            endPos = new BlockPos(-1, 0, -1);
        } else {
            startPos = new BlockPos(1, 1, 0);
            endPos = new BlockPos(-1, -1, 0);
        }
        Iterable posIter = BlockPos.func_177980_a((BlockPos)startPos, (BlockPos)endPos);
        IBlockState originalState = world.func_180495_p(pos);
        float originalStrength = ForgeHooks.blockStrength((IBlockState)originalState, (EntityPlayer)player, (World)world, (BlockPos)pos);
        boolean canHarvestBedrock = false;
        if (originalState.func_177230_c() == Blocks.field_150357_h && player.field_71093_bK == DimensionType.NETHER.func_186068_a() && pos.func_177956_o() >= 120) {
            canHarvestBedrock = true;
        }
        for (BlockPos testPos : posIter) {
            if ((testPos = testPos.func_177971_a((Vec3i)pos)).equals((Object)pos)) continue;
            IBlockState testState = world.func_180495_p(testPos);
            float testStrength = ForgeHooks.blockStrength((IBlockState)testState, (EntityPlayer)player, (World)world, (BlockPos)testPos);
            boolean canBeHarvested = ForgeHooks.canHarvestBlock((Block)testState.func_177230_c(), (EntityPlayer)player, (IBlockAccess)world, (BlockPos)testPos);
            if (!(originalState.func_185904_a() == testState.func_185904_a() && testStrength > 0.0f && originalStrength / testStrength <= 10.0f) && !canHarvestBedrock || (!canBeHarvested || !stack.func_150998_b(originalState)) && !canBeHarvested) continue;
            BlockUtil.tryToHarvest(world, testState, testPos, player, sideHit);
        }
        if (canHarvestBedrock) {
            BlockUtil.tryToHarvest(world, originalState, pos, player, sideHit);
        }
        return false;
    }

    public static boolean tryToHarvest(World world, IBlockState state, BlockPos pos, EntityPlayer player, EnumFacing side) {
        ItemStack stack;
        Block block = state.func_177230_c();
        if (world.func_175623_d(pos)) {
            return false;
        }
        EntityPlayerMP playerMP = null;
        if (player instanceof EntityPlayerMP) {
            playerMP = (EntityPlayerMP)player;
        }
        if ((stack = player.func_184614_ca()) == null || stack.func_77973_b() == null) {
            return false;
        }
        if (!stack.func_77973_b().getToolClasses(stack).contains(block.getHarvestTool(state)) && !(stack.func_77973_b().func_150893_a(stack, state) > 1.0f)) {
            return false;
        }
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos)) {
            return false;
        }
        int event = 0;
        if (playerMP != null && (event = ForgeHooks.onBlockBreakEvent((World)world, (GameType)world.func_72912_H().func_76077_q(), (EntityPlayerMP)playerMP, (BlockPos)pos)) == -1) {
            return false;
        }
        world.func_180498_a((EntityPlayer)playerMP, 2001, pos, Block.func_176210_f((IBlockState)state));
        if (player.field_71075_bZ.field_75098_d) {
            if (!world.field_72995_K) {
                block.func_176208_a(world, pos, state, player);
            }
            if (block.removedByPlayer(state, world, pos, player, false)) {
                block.func_176206_d(world, pos, state);
            }
            if (!world.field_72995_K) {
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            } else {
                Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, side));
            }
            return true;
        }
        if (!world.field_72995_K) {
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
                block.func_180657_a(world, player, pos, state, null, stack);
                block.func_180637_b(world, pos, event);
            }
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, side));
        }
        return true;
    }

    public static boolean isOreDict(String id, Block block) {
        for (ItemStack stack : OreDictionary.getOres((String)id)) {
            if (!(stack.func_77973_b() instanceof ItemBlock) || ((ItemBlock)stack.func_77973_b()).func_179223_d() != block) continue;
            return true;
        }
        return false;
    }
}

