/*
 * Decompiled with CFR 0.152.
 */
package nex.util;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.BlockRotationProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import nex.block.BlockUrnOfSorrow;
import nex.entity.passive.EntityPigtificate;
import nex.entity.passive.EntityPigtificateLeader;
import nex.tileentity.TileEntityUrnOfSorrow;

public class WorldGenUtil {
    private static final Field FIELD_BLOCKS = ReflectionHelper.findField(Template.class, (String[])new String[]{"field_186270_a", "blocks"});
    private static final Field FIELD_ENTITIES = ReflectionHelper.findField(Template.class, (String[])new String[]{"field_186271_b", "entities"});

    public static BlockPos getSuitableGroundPos(World world, BlockPos pos, BlockPos structureSize, float percentage) {
        block0: while (pos.func_177956_o() > 32) {
            float sizeX = structureSize.func_177958_n();
            float sizeY = structureSize.func_177956_o();
            float sizeZ = structureSize.func_177952_p();
            int topBlocks = 0;
            int x = 0;
            while ((float)x <= MathHelper.func_76135_e((float)sizeX)) {
                int z = 0;
                while ((float)z <= MathHelper.func_76135_e((float)sizeZ)) {
                    int posX = (int)(sizeX > 0.0f ? sizeX - (float)x : sizeX + (float)x);
                    int posZ = (int)(sizeZ > 0.0f ? sizeZ - (float)z : sizeZ + (float)z);
                    BlockPos newPos = pos.func_177982_a(posX, 0, posZ);
                    IBlockState state = world.func_180495_p(newPos);
                    if (!world.func_180495_p(newPos).func_185904_a().func_76222_j() && !world.func_180495_p(newPos.func_177977_b()).func_185904_a().func_76222_j() && world.func_180495_p(newPos.func_177984_a()).func_185904_a().func_76222_j()) {
                        ++topBlocks;
                    } else if (state != Blocks.field_150350_a.func_176223_P()) {
                        pos = pos.func_177977_b();
                        continue block0;
                    }
                    ++z;
                }
                ++x;
            }
            int replaceableBlocks = 0;
            if ((float)topBlocks >= MathHelper.func_76135_e((float)(sizeX * sizeZ)) * percentage) {
                int y = 1;
                while ((float)y < sizeY) {
                    int x2 = 0;
                    while ((float)x2 <= MathHelper.func_76135_e((float)sizeX)) {
                        int z = 0;
                        while ((float)z <= MathHelper.func_76135_e((float)sizeZ)) {
                            int posX = (int)(sizeX > 0.0f ? sizeX - (float)x2 : sizeX + (float)x2);
                            int posZ = (int)(sizeZ > 0.0f ? sizeZ - (float)z : sizeZ + (float)z);
                            BlockPos newPos = pos.func_177982_a(posX, y, posZ);
                            IBlockState state = world.func_180495_p(newPos);
                            if (world.func_180495_p(newPos).func_185904_a().func_76222_j()) {
                                ++replaceableBlocks;
                            } else if (state != Blocks.field_150350_a.func_176223_P()) {
                                pos = pos.func_177977_b();
                                continue block0;
                            }
                            ++z;
                        }
                        ++x2;
                    }
                    ++y;
                }
            }
            if ((float)replaceableBlocks > MathHelper.func_76135_e((float)(sizeX * sizeY * sizeZ)) * 0.875f) {
                return pos;
            }
            pos = pos.func_177977_b();
        }
        return BlockPos.field_177992_a;
    }

    public static BlockPos getSuitableWallPos(World world, BlockPos pos, BlockPos structureSize, float percentage) {
        while (pos.func_177956_o() > 32) {
            float sizeX = structureSize.func_177958_n();
            float sizeZ = structureSize.func_177952_p();
            float sizeY = structureSize.func_177956_o();
            int wallBlocks = 0;
            int x = 0;
            while ((float)x <= MathHelper.func_76135_e((float)sizeX)) {
                int z = 0;
                while ((float)z <= MathHelper.func_76135_e((float)sizeZ)) {
                    int y = 0;
                    while ((float)y <= sizeY) {
                        int posZ;
                        int posX = (int)(sizeX > 0.0f ? sizeX - (float)x : sizeX + (float)x);
                        BlockPos newPos = pos.func_177982_a(posX, y, posZ = (int)(sizeZ > 0.0f ? sizeZ - (float)z : sizeZ + (float)z));
                        if (!world.func_180495_p(newPos).func_185904_a().func_76222_j()) {
                            ++wallBlocks;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++x;
            }
            if ((float)wallBlocks >= MathHelper.func_76135_e((float)(sizeX * sizeY * sizeZ)) * percentage) {
                return pos;
            }
            pos = pos.func_177977_b();
        }
        return BlockPos.field_177992_a;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static BlockPos getSuitableCeilingPos(World world, BlockPos pos, BlockPos structureSize) {
        block0: while (pos.func_177956_o() < 128) {
            float sizeX = structureSize.func_177958_n();
            float sizeZ = structureSize.func_177952_p();
            float sizeY = structureSize.func_177956_o();
            int ceilingBlocks = 0;
            int replaceableBlocks = 0;
            int x = 0;
            block1: while (true) {
                if (!((float)x <= MathHelper.func_76135_e((float)sizeX))) {
                    if ((float)replaceableBlocks >= MathHelper.func_76135_e((float)(sizeX * (sizeY - 1.0f) * sizeZ)) && (float)ceilingBlocks >= MathHelper.func_76135_e((float)(sizeX * sizeZ))) {
                        return pos.func_177963_a(0.0, (double)(-sizeY), 0.0);
                    }
                    pos = pos.func_177984_a();
                    continue block0;
                }
                int z = 0;
                while (true) {
                    int y;
                    if ((float)z <= MathHelper.func_76135_e((float)sizeZ)) {
                        y = 0;
                    } else {
                        ++x;
                        continue block1;
                    }
                    while ((float)y <= sizeY) {
                        block14: {
                            int posX = (int)(sizeX > 0.0f ? sizeX - (float)x : sizeX + (float)x);
                            int posZ = (int)(sizeZ > 0.0f ? sizeZ - (float)z : sizeZ + (float)z);
                            BlockPos newPos = pos.func_177982_a(posX, -y, posZ);
                            if (y == 0) {
                                if (world.func_180495_p(newPos).isSideSolid((IBlockAccess)world, newPos, EnumFacing.DOWN)) {
                                    ++ceilingBlocks;
                                    break block14;
                                } else {
                                    pos = pos.func_177984_a();
                                    continue block0;
                                }
                            }
                            if (world.func_180495_p(newPos).func_177230_c().func_176200_f((IBlockAccess)world, newPos)) {
                                ++replaceableBlocks;
                            } else {
                                pos = pos.func_177984_a();
                                continue block0;
                            }
                        }
                        ++y;
                    }
                    ++z;
                }
                break;
            }
            break;
        }
        return BlockPos.field_177992_a;
    }

    public static BlockPos getSuitableAirPos(World world, BlockPos pos, BlockPos structureSize) {
        block0: while (pos.func_177956_o() > 32) {
            float sizeX = structureSize.func_177958_n();
            float sizeZ = structureSize.func_177952_p();
            float sizeY = structureSize.func_177956_o();
            int replaceableBlocks = 0;
            int x = 0;
            while ((float)x <= MathHelper.func_76135_e((float)sizeX)) {
                int z = 0;
                while ((float)z <= MathHelper.func_76135_e((float)sizeZ)) {
                    int y = 0;
                    while ((float)y <= sizeY) {
                        int posZ;
                        int posX = (int)(sizeX > 0.0f ? sizeX - (float)x : sizeX + (float)x);
                        BlockPos newPos = pos.func_177982_a(posX, y, posZ = (int)(sizeZ > 0.0f ? sizeZ - (float)z : sizeZ + (float)z));
                        if (world.func_180495_p(newPos).func_185904_a().func_76222_j()) {
                            ++replaceableBlocks;
                        } else {
                            pos = pos.func_177977_b();
                            continue block0;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++x;
            }
            if ((float)replaceableBlocks >= MathHelper.func_76135_e((float)(sizeX * sizeY * sizeZ))) {
                return pos;
            }
            pos = pos.func_177977_b();
        }
        return BlockPos.field_177992_a;
    }

    public static void generateStructure(World world, BlockPos pos, Random rand, Template template, PlacementSettings placementSettings, List<ResourceLocation> lootTables, List<ResourceLocation> spawnerMobs) {
        try {
            List blocks = (List)FIELD_BLOCKS.get(template);
            List entities = (List)FIELD_ENTITIES.get(template);
            if (!(blocks.isEmpty() && (placementSettings.func_186221_e() || entities.isEmpty()) || template.func_186259_a().func_177958_n() < 1 || template.func_186259_a().func_177956_o() < 1 || template.func_186259_a().func_177952_p() < 1)) {
                BlockRotationProcessor processor = new BlockRotationProcessor(pos, placementSettings);
                Block block = placementSettings.func_186219_f();
                StructureBoundingBox boundingBox = placementSettings.func_186213_g();
                for (Template.BlockInfo blockInfo : blocks) {
                    TileEntity tileEntity;
                    BlockPos blockPos = Template.func_186266_a((PlacementSettings)placementSettings, (BlockPos)blockInfo.field_186242_a).func_177971_a((Vec3i)pos);
                    Template.BlockInfo blockInfo1 = processor != null ? processor.func_189943_a(world, blockPos, blockInfo) : blockInfo;
                    if (blockInfo1 == null) continue;
                    Block block1 = blockInfo1.field_186243_b.func_177230_c();
                    if (block != null && block == block1 || placementSettings.func_186227_h() && block1 == Blocks.field_185779_df || boundingBox != null && !boundingBox.func_175898_b((Vec3i)blockPos)) continue;
                    IBlockState state = blockInfo1.field_186243_b.func_185902_a(placementSettings.func_186212_b()).func_185907_a(placementSettings.func_186215_c());
                    if (blockInfo1.field_186244_c != null && (tileEntity = world.func_175625_s(blockPos)) != null) {
                        if (tileEntity instanceof IInventory) {
                            ((IInventory)tileEntity).func_174888_l();
                        }
                        world.func_180501_a(blockPos, Blocks.field_180401_cv.func_176223_P(), 4);
                    }
                    if (!world.func_180501_a(blockPos, state, 3) || blockInfo1.field_186244_c == null || (tileEntity = world.func_175625_s(blockPos)) == null) continue;
                    blockInfo1.field_186244_c.func_74768_a("x", blockPos.func_177958_n());
                    blockInfo1.field_186244_c.func_74768_a("y", blockPos.func_177956_o());
                    blockInfo1.field_186244_c.func_74768_a("z", blockPos.func_177952_p());
                    tileEntity.func_145839_a(blockInfo1.field_186244_c);
                    tileEntity.func_189668_a(placementSettings.func_186212_b());
                    tileEntity.func_189667_a(placementSettings.func_186215_c());
                    if (state.func_177230_c() instanceof BlockChest) {
                        ((TileEntityChest)tileEntity).func_189404_a(lootTables.get(rand.nextInt(lootTables.size())), rand.nextLong());
                        continue;
                    }
                    if (state.func_177230_c() instanceof BlockMobSpawner) {
                        MobSpawnerBaseLogic logic = ((TileEntityMobSpawner)tileEntity).func_145881_a();
                        NBTTagCompound compound = new NBTTagCompound();
                        logic.func_189530_b(compound);
                        compound.func_82580_o("SpawnPotentials");
                        logic.func_98270_a(compound);
                        logic.func_190894_a(spawnerMobs.get(rand.nextInt(spawnerMobs.size())));
                        tileEntity.func_70296_d();
                        world.func_184138_a(pos, state, state, 3);
                        continue;
                    }
                    if (!(state.func_177230_c() instanceof BlockUrnOfSorrow)) continue;
                    ((TileEntityUrnOfSorrow)tileEntity).setCanBreak(false);
                }
                for (Template.BlockInfo blockInfo2 : blocks) {
                    TileEntity tileEntity;
                    if (block != null && block == blockInfo2.field_186243_b.func_177230_c()) continue;
                    BlockPos blockPos1 = Template.func_186266_a((PlacementSettings)placementSettings, (BlockPos)blockInfo2.field_186242_a).func_177971_a((Vec3i)pos);
                    if (boundingBox != null && !boundingBox.func_175898_b((Vec3i)blockPos1)) continue;
                    world.func_175722_b(blockPos1, blockInfo2.field_186243_b.func_177230_c(), false);
                    if (blockInfo2.field_186244_c == null || (tileEntity = world.func_175625_s(blockPos1)) == null) continue;
                    tileEntity.func_70296_d();
                }
                if (!placementSettings.func_186221_e()) {
                    WorldGenUtil.addEntitiesToWorld(world, pos, placementSettings, entities, boundingBox);
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static void addEntitiesToWorld(World world, BlockPos pos, PlacementSettings placementSettings, List<Template.EntityInfo> entities, StructureBoundingBox boundingBox) {
        for (Template.EntityInfo entityInfo : entities) {
            Object entity;
            BlockPos blockPos = Template.func_186266_a((PlacementSettings)placementSettings, (BlockPos)entityInfo.field_186248_b).func_177971_a((Vec3i)pos);
            if (boundingBox != null && !boundingBox.func_175898_b((Vec3i)blockPos)) continue;
            NBTTagCompound compound = entityInfo.field_186249_c;
            Vec3d vec3d = WorldGenUtil.transformedVec3d(entityInfo.field_186247_a, placementSettings.func_186212_b(), placementSettings.func_186215_c());
            Vec3d vec3d1 = vec3d.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            NBTTagList tagList = new NBTTagList();
            tagList.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72450_a));
            tagList.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72448_b));
            tagList.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72449_c));
            compound.func_74782_a("Pos", (NBTBase)tagList);
            compound.func_186854_a("UUID", UUID.randomUUID());
            try {
                entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)world);
            }
            catch (Exception var15) {
                entity = null;
            }
            if (entity == null) continue;
            if (entity instanceof EntityPigtificateLeader) {
                entity = new EntityPigtificateLeader(world);
            } else if (entity instanceof EntityPigtificate) {
                entity = new EntityPigtificate(world);
            }
            float f = entity.func_184217_a(placementSettings.func_186212_b());
            entity.func_70012_b(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, f += entity.field_70177_z - entity.func_184229_a(placementSettings.func_186215_c()), entity.field_70125_A);
            world.func_72838_d(entity);
        }
    }

    private static Vec3d transformedVec3d(Vec3d vec, Mirror mirror, Rotation rotation) {
        double xCoord = vec.field_72450_a;
        double yCoord = vec.field_72448_b;
        double zCoord = vec.field_72449_c;
        boolean flag = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                zCoord = 1.0 - zCoord;
                break;
            }
            case FRONT_BACK: {
                xCoord = 1.0 - xCoord;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d(zCoord, yCoord, 1.0 - xCoord);
            }
            case CLOCKWISE_90: {
                return new Vec3d(1.0 - zCoord, yCoord, xCoord);
            }
            case CLOCKWISE_180: {
                return new Vec3d(1.0 - xCoord, yCoord, 1.0 - zCoord);
            }
        }
        return flag ? new Vec3d(xCoord, yCoord, zCoord) : vec;
    }
}

