/*
 * Decompiled with CFR 0.152.
 */
package nex.village;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import nex.entity.neutral.EntityGoldGolem;
import nex.entity.passive.EntityPigtificate;
import nex.village.PigtificateVillageFenceGateInfo;

public class PigtificateVillage {
    private World world;
    private final List<PigtificateVillageFenceGateInfo> villageFenceGateInfoList = Lists.newArrayList();
    private BlockPos centerHelper = BlockPos.field_177992_a;
    private BlockPos center = BlockPos.field_177992_a;
    private int villageRadius;
    private int lastAddFenceGateTimestamp;
    private int tickCounter;
    private int numPigtificates;
    private int noBreedTicks;
    private final Map<UUID, Integer> playerReputation = Maps.newHashMap();
    private final List<VillageAggressor> villageAggressors = Lists.newArrayList();
    private int numGoldGolems;

    public PigtificateVillage() {
    }

    public PigtificateVillage(World worldIn) {
        this.world = worldIn;
    }

    public void setWorld(World worldIn) {
        this.world = worldIn;
    }

    public void tick(int tickCounterIn) {
        Vec3d vec3d;
        int i;
        this.tickCounter = tickCounterIn;
        this.removeDeadAndOutOfRangeFenceGates();
        this.removeDeadAndOldAggressors();
        if (tickCounterIn % 20 == 0) {
            this.updateNumPigtificates();
        }
        if (tickCounterIn % 30 == 0) {
            this.updateNumGoldGolems();
        }
        if (this.numGoldGolems < (i = this.numPigtificates / 10) && this.villageFenceGateInfoList.size() > 20 && this.world.field_73012_v.nextInt(7000) == 0 && (vec3d = this.findRandomSpawnPos(this.center, 2, 4, 2)) != null) {
            EntityGoldGolem golem = new EntityGoldGolem(this.world);
            golem.func_70107_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            this.world.func_72838_d((Entity)golem);
            ++this.numGoldGolems;
        }
    }

    private Vec3d findRandomSpawnPos(BlockPos pos, int x, int y, int z) {
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos = pos.func_177982_a(this.world.field_73012_v.nextInt(16) - 8, this.world.field_73012_v.nextInt(6) - 3, this.world.field_73012_v.nextInt(16) - 8);
            if (!this.isBlockPosWithinSqVillageRadius(blockpos) || !this.isAreaClearAround(new BlockPos(x, y, z), blockpos)) continue;
            return new Vec3d((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
        }
        return null;
    }

    private boolean isAreaClearAround(BlockPos blockSize, BlockPos blockLocation) {
        if (!this.world.func_180495_p(blockLocation.func_177977_b()).isSideSolid((IBlockAccess)this.world, blockLocation, EnumFacing.UP)) {
            return false;
        }
        int i = blockLocation.func_177958_n() - blockSize.func_177958_n() / 2;
        int j = blockLocation.func_177952_p() - blockSize.func_177952_p() / 2;
        for (int k = i; k < i + blockSize.func_177958_n(); ++k) {
            for (int l = blockLocation.func_177956_o(); l < blockLocation.func_177956_o() + blockSize.func_177956_o(); ++l) {
                for (int i1 = j; i1 < j + blockSize.func_177952_p(); ++i1) {
                    if (!this.world.func_180495_p(new BlockPos(k, l, i1)).func_185915_l()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void updateNumGoldGolems() {
        List list = this.world.func_72872_a(EntityGoldGolem.class, new AxisAlignedBB((double)(this.center.func_177958_n() - this.villageRadius), (double)(this.center.func_177956_o() - 4), (double)(this.center.func_177952_p() - this.villageRadius), (double)(this.center.func_177958_n() + this.villageRadius), (double)(this.center.func_177956_o() + 4), (double)(this.center.func_177952_p() + this.villageRadius)));
        this.numGoldGolems = list.size();
    }

    private void updateNumPigtificates() {
        List list = this.world.func_72872_a(EntityPigtificate.class, new AxisAlignedBB((double)(this.center.func_177958_n() - this.villageRadius), (double)(this.center.func_177956_o() - 4), (double)(this.center.func_177952_p() - this.villageRadius), (double)(this.center.func_177958_n() + this.villageRadius), (double)(this.center.func_177956_o() + 4), (double)(this.center.func_177952_p() + this.villageRadius)));
        this.numPigtificates = list.size();
        if (this.numPigtificates == 0) {
            this.playerReputation.clear();
        }
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public int getVillageRadius() {
        return this.villageRadius;
    }

    public int getNumVillageFenceGates() {
        return this.villageFenceGateInfoList.size();
    }

    public int getTicksSinceLastFenceGateAdding() {
        return this.tickCounter - this.lastAddFenceGateTimestamp;
    }

    public int getNumPigtificates() {
        return this.numPigtificates;
    }

    public boolean isBlockPosWithinSqVillageRadius(BlockPos pos) {
        return this.center.func_177951_i((Vec3i)pos) < (double)(this.villageRadius * this.villageRadius);
    }

    public List<PigtificateVillageFenceGateInfo> getVillageFenceGateInfoList() {
        return this.villageFenceGateInfoList;
    }

    public PigtificateVillageFenceGateInfo getNearestFenceGate(BlockPos pos) {
        PigtificateVillageFenceGateInfo fenceGateInfo = null;
        int i = Integer.MAX_VALUE;
        for (PigtificateVillageFenceGateInfo fenceGateInfo1 : this.villageFenceGateInfoList) {
            int j = fenceGateInfo1.getDistanceToFenceGateBlockSq(pos);
            if (j >= i) continue;
            fenceGateInfo = fenceGateInfo1;
            i = j;
        }
        return fenceGateInfo;
    }

    public PigtificateVillageFenceGateInfo getFenceGateInfo(BlockPos pos) {
        PigtificateVillageFenceGateInfo fenceGateInfo = null;
        int i = Integer.MAX_VALUE;
        for (PigtificateVillageFenceGateInfo fenceGateInfo1 : this.villageFenceGateInfoList) {
            EnumFacing enumfacing;
            BlockPos blockpos;
            int j = fenceGateInfo1.getDistanceToFenceGateBlockSq(pos);
            j = j > 256 ? (j *= 1000) : fenceGateInfo1.getFenceGateOpeningRestrictionCounter();
            if (j >= i || !this.world.func_180495_p((blockpos = fenceGateInfo1.getFenceGateBlockPos()).func_177967_a(enumfacing = fenceGateInfo1.getInsideDirection(), 1)).func_177230_c().func_176205_b((IBlockAccess)this.world, blockpos.func_177967_a(enumfacing, 1)) || !this.world.func_180495_p(blockpos.func_177967_a(enumfacing, -1)).func_177230_c().func_176205_b((IBlockAccess)this.world, blockpos.func_177967_a(enumfacing, -1)) || !this.world.func_180495_p(blockpos.func_177984_a().func_177967_a(enumfacing, 1)).func_177230_c().func_176205_b((IBlockAccess)this.world, blockpos.func_177984_a().func_177967_a(enumfacing, 1)) || !this.world.func_180495_p(blockpos.func_177984_a().func_177967_a(enumfacing, -1)).func_177230_c().func_176205_b((IBlockAccess)this.world, blockpos.func_177984_a().func_177967_a(enumfacing, -1))) continue;
            fenceGateInfo = fenceGateInfo1;
            i = j;
        }
        return fenceGateInfo;
    }

    public PigtificateVillageFenceGateInfo getExistedFenceGate(BlockPos fenceGateBlock) {
        if (this.center.func_177951_i((Vec3i)fenceGateBlock) > (double)(this.villageRadius * this.villageRadius)) {
            return null;
        }
        for (PigtificateVillageFenceGateInfo fenceGateInfo : this.villageFenceGateInfoList) {
            if (fenceGateInfo.getFenceGateBlockPos().func_177958_n() != fenceGateBlock.func_177958_n() || fenceGateInfo.getFenceGateBlockPos().func_177952_p() != fenceGateBlock.func_177952_p() || Math.abs(fenceGateInfo.getFenceGateBlockPos().func_177956_o() - fenceGateBlock.func_177956_o()) > 1) continue;
            return fenceGateInfo;
        }
        return null;
    }

    public void addVillageFenceGateInfo(PigtificateVillageFenceGateInfo fenceGateInfo) {
        this.villageFenceGateInfoList.add(fenceGateInfo);
        this.centerHelper = this.centerHelper.func_177971_a((Vec3i)fenceGateInfo.getFenceGateBlockPos());
        this.updateVillageRadiusAndCenter();
        this.lastAddFenceGateTimestamp = fenceGateInfo.getLastActivityTimestamp();
    }

    public boolean isAnnihilated() {
        return this.villageFenceGateInfoList.isEmpty();
    }

    public void addOrRenewAggressor(EntityLivingBase entitylivingbaseIn) {
        for (VillageAggressor aggressor : this.villageAggressors) {
            if (aggressor.aggressor != entitylivingbaseIn) continue;
            aggressor.aggressionTime = this.tickCounter;
            return;
        }
        this.villageAggressors.add(new VillageAggressor(entitylivingbaseIn, this.tickCounter));
    }

    public EntityLivingBase findNearestVillageAggressor(EntityLivingBase entitylivingbaseIn) {
        double d0 = Double.MAX_VALUE;
        VillageAggressor aggressor = null;
        Iterator<VillageAggressor> iterator = this.villageAggressors.iterator();
        while (iterator.hasNext()) {
            VillageAggressor villageAggressor;
            VillageAggressor aggressor1 = villageAggressor = iterator.next();
            double d1 = aggressor1.aggressor.func_70068_e((Entity)entitylivingbaseIn);
            if (!(d1 <= d0)) continue;
            aggressor = aggressor1;
            d0 = d1;
        }
        return aggressor == null ? null : aggressor.aggressor;
    }

    public EntityPlayer getNearestTargetPlayer(EntityLivingBase villageDefender) {
        double d0 = Double.MAX_VALUE;
        EntityPlayer entityplayer = null;
        for (UUID s : this.playerReputation.keySet()) {
            double d1;
            EntityPlayer entityplayer1;
            if (!this.isPlayerReputationTooLow(s) || (entityplayer1 = this.world.func_152378_a(s)) == null || !((d1 = entityplayer1.func_70068_e((Entity)villageDefender)) <= d0)) continue;
            entityplayer = entityplayer1;
            d0 = d1;
        }
        return entityplayer;
    }

    private void removeDeadAndOldAggressors() {
        this.villageAggressors.removeIf(aggressor -> !aggressor.aggressor.func_70089_S() || Math.abs(this.tickCounter - aggressor.aggressionTime) > 300);
    }

    private void removeDeadAndOutOfRangeFenceGates() {
        boolean flag = false;
        boolean flag1 = this.world.field_73012_v.nextInt(50) == 0;
        Iterator<PigtificateVillageFenceGateInfo> iterator = this.villageFenceGateInfoList.iterator();
        while (iterator.hasNext()) {
            PigtificateVillageFenceGateInfo fenceGateInfo = iterator.next();
            if (flag1) {
                fenceGateInfo.resetFenceGateOpeningRestrictionCounter();
            }
            if (Math.abs(this.tickCounter - fenceGateInfo.getLastActivityTimestamp()) <= 1200) continue;
            this.centerHelper = this.centerHelper.func_177973_b((Vec3i)fenceGateInfo.getFenceGateBlockPos());
            flag = true;
            fenceGateInfo.setIsDetachedFromVillageFlag(true);
            iterator.remove();
        }
        if (flag) {
            this.updateVillageRadiusAndCenter();
        }
    }

    private void updateVillageRadiusAndCenter() {
        int i = this.villageFenceGateInfoList.size();
        if (i == 0) {
            this.center = BlockPos.field_177992_a;
            this.villageRadius = 0;
        } else {
            this.center = new BlockPos(this.centerHelper.func_177958_n() / i, this.centerHelper.func_177956_o() / i, this.centerHelper.func_177952_p() / i);
            int j = 0;
            for (PigtificateVillageFenceGateInfo fenceGateInfo : this.villageFenceGateInfoList) {
                j = Math.max(fenceGateInfo.getDistanceToFenceGateBlockSq(this.center), j);
            }
            this.villageRadius = Math.max(32, (int)Math.sqrt(j) + 1);
        }
    }

    public int getPlayerReputation(UUID playerName) {
        Integer integer = this.playerReputation.get(playerName);
        return integer == null ? 0 : integer;
    }

    private UUID findUUID(String name) {
        if (this.world == null || this.world.func_73046_m() == null) {
            return EntityPlayer.func_175147_b((String)name);
        }
        GameProfile profile = this.world.func_73046_m().func_152358_ax().func_152655_a(name);
        return profile == null ? EntityPlayer.func_175147_b((String)name) : profile.getId();
    }

    public int modifyPlayerReputation(UUID playerName, int reputation) {
        int i = this.getPlayerReputation(playerName);
        int j = MathHelper.func_76125_a((int)(i + reputation), (int)-30, (int)10);
        this.playerReputation.put(playerName, j);
        return j;
    }

    public boolean isPlayerReputationTooLow(UUID uuid) {
        return this.getPlayerReputation(uuid) <= -15;
    }

    public void readVillageDataFromNBT(NBTTagCompound compound) {
        this.numPigtificates = compound.func_74762_e("PopSize");
        this.villageRadius = compound.func_74762_e("Radius");
        this.numGoldGolems = compound.func_74762_e("Golems");
        this.lastAddFenceGateTimestamp = compound.func_74762_e("Stable");
        this.tickCounter = compound.func_74762_e("Tick");
        this.noBreedTicks = compound.func_74762_e("MTick");
        this.center = new BlockPos(compound.func_74762_e("CX"), compound.func_74762_e("CY"), compound.func_74762_e("CZ"));
        this.centerHelper = new BlockPos(compound.func_74762_e("ACX"), compound.func_74762_e("ACY"), compound.func_74762_e("ACZ"));
        NBTTagList nbttaglist = compound.func_150295_c("FenceGates", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = nbttaglist.func_150305_b(i);
            PigtificateVillageFenceGateInfo fenceGateInfo = new PigtificateVillageFenceGateInfo(new BlockPos(tagCompound.func_74762_e("X"), tagCompound.func_74762_e("Y"), tagCompound.func_74762_e("Z")), tagCompound.func_74762_e("IDX"), tagCompound.func_74762_e("IDZ"), tagCompound.func_74762_e("TS"));
            this.villageFenceGateInfoList.add(fenceGateInfo);
        }
        NBTTagList tagList = compound.func_150295_c("Players", 10);
        for (int j = 0; j < tagList.func_74745_c(); ++j) {
            NBTTagCompound tagCompound1 = tagList.func_150305_b(j);
            if (tagCompound1.func_74764_b("UUID")) {
                this.playerReputation.put(UUID.fromString(tagCompound1.func_74779_i("UUID")), tagCompound1.func_74762_e("S"));
                continue;
            }
            this.playerReputation.put(this.findUUID(tagCompound1.func_74779_i("Name")), tagCompound1.func_74762_e("S"));
        }
    }

    public void writeVillageDataToNBT(NBTTagCompound compound) {
        compound.func_74768_a("PopSize", this.numPigtificates);
        compound.func_74768_a("Radius", this.villageRadius);
        compound.func_74768_a("Golems", this.numGoldGolems);
        compound.func_74768_a("Stable", this.lastAddFenceGateTimestamp);
        compound.func_74768_a("Tick", this.tickCounter);
        compound.func_74768_a("MTick", this.noBreedTicks);
        compound.func_74768_a("CX", this.center.func_177958_n());
        compound.func_74768_a("CY", this.center.func_177956_o());
        compound.func_74768_a("CZ", this.center.func_177952_p());
        compound.func_74768_a("ACX", this.centerHelper.func_177958_n());
        compound.func_74768_a("ACY", this.centerHelper.func_177956_o());
        compound.func_74768_a("ACZ", this.centerHelper.func_177952_p());
        NBTTagList nbttaglist = new NBTTagList();
        for (PigtificateVillageFenceGateInfo fenceGateInfo : this.villageFenceGateInfoList) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("X", fenceGateInfo.getFenceGateBlockPos().func_177958_n());
            tagCompound.func_74768_a("Y", fenceGateInfo.getFenceGateBlockPos().func_177956_o());
            tagCompound.func_74768_a("Z", fenceGateInfo.getFenceGateBlockPos().func_177952_p());
            tagCompound.func_74768_a("IDX", fenceGateInfo.getInsideOffsetX());
            tagCompound.func_74768_a("IDZ", fenceGateInfo.getInsideOffsetZ());
            tagCompound.func_74768_a("TS", fenceGateInfo.getLastActivityTimestamp());
            nbttaglist.func_74742_a((NBTBase)tagCompound);
        }
        compound.func_74782_a("FenceGates", (NBTBase)nbttaglist);
        NBTTagList tagList = new NBTTagList();
        for (UUID s : this.playerReputation.keySet()) {
            NBTTagCompound tagCompound1 = new NBTTagCompound();
            try {
                tagCompound1.func_74778_a("UUID", s.toString());
                tagCompound1.func_74768_a("S", this.playerReputation.get(s).intValue());
                tagList.func_74742_a((NBTBase)tagCompound1);
            }
            catch (RuntimeException runtimeException) {}
        }
        compound.func_74782_a("Players", (NBTBase)tagList);
    }

    public void endMatingSeason() {
        this.noBreedTicks = this.tickCounter;
    }

    public boolean isMatingSeason() {
        return this.noBreedTicks == 0 || this.tickCounter - this.noBreedTicks >= 3600;
    }

    public void setDefaultPlayerReputation(int defaultReputation) {
        for (UUID s : this.playerReputation.keySet()) {
            this.modifyPlayerReputation(s, defaultReputation);
        }
    }

    class VillageAggressor {
        public EntityLivingBase aggressor;
        public int aggressionTime;

        VillageAggressor(EntityLivingBase aggressorIn, int aggressionTimeIn) {
            this.aggressor = aggressorIn;
            this.aggressionTime = aggressionTimeIn;
        }
    }
}

