/*
 * Decompiled with CFR 0.152.
 */
package nex.village;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class PigtificateVillageFenceGateInfo {
    private final BlockPos fenceGateBlockPos;
    private final BlockPos insideBlock;
    private final EnumFacing insideDirection;
    private int lastActivityTimestamp;
    private boolean isDetachedFromVillageFlag;
    private int fenceGateOpeningRestrictionCounter;

    public PigtificateVillageFenceGateInfo(BlockPos pos, int deltaX, int deltaZ, int timestamp) {
        this(pos, PigtificateVillageFenceGateInfo.getFaceDirection(deltaX, deltaZ), timestamp);
    }

    private static EnumFacing getFaceDirection(int deltaX, int deltaZ) {
        return deltaX < 0 ? EnumFacing.WEST : (deltaX > 0 ? EnumFacing.EAST : (deltaZ < 0 ? EnumFacing.NORTH : EnumFacing.SOUTH));
    }

    public PigtificateVillageFenceGateInfo(BlockPos pos, EnumFacing facing, int timestamp) {
        this.fenceGateBlockPos = pos;
        this.insideDirection = facing;
        this.insideBlock = pos.func_177967_a(facing, 3);
        this.lastActivityTimestamp = timestamp;
    }

    public int getDistanceSquared(int x, int y, int z) {
        return (int)this.fenceGateBlockPos.func_177954_c((double)x, (double)y, (double)z);
    }

    public int getDistanceToFenceGateBlockSq(BlockPos pos) {
        return (int)pos.func_177951_i((Vec3i)this.getFenceGateBlockPos());
    }

    public int getDistanceToInsideBlockSq(BlockPos pos) {
        return (int)this.insideBlock.func_177951_i((Vec3i)pos);
    }

    public boolean isInsideSide(BlockPos pos) {
        int i = pos.func_177958_n() - this.fenceGateBlockPos.func_177958_n();
        int j = pos.func_177952_p() - this.fenceGateBlockPos.func_177956_o();
        return i * this.insideDirection.func_82601_c() + j * this.insideDirection.func_82599_e() >= 0;
    }

    public void resetFenceGateOpeningRestrictionCounter() {
        this.fenceGateOpeningRestrictionCounter = 0;
    }

    public void incrementFenceGateOpeningRestrictionCounter() {
        ++this.fenceGateOpeningRestrictionCounter;
    }

    public int getFenceGateOpeningRestrictionCounter() {
        return this.fenceGateOpeningRestrictionCounter;
    }

    public BlockPos getFenceGateBlockPos() {
        return this.fenceGateBlockPos;
    }

    public BlockPos getInsideBlockPos() {
        return this.insideBlock;
    }

    public int getInsideOffsetX() {
        return this.insideDirection.func_82601_c() * 2;
    }

    public int getInsideOffsetZ() {
        return this.insideDirection.func_82599_e() * 2;
    }

    public int getLastActivityTimestamp() {
        return this.lastActivityTimestamp;
    }

    public void setLastActivityTimestamp(int timestamp) {
        this.lastActivityTimestamp = timestamp;
    }

    public boolean getIsDetachedFromVillageFlag() {
        return this.isDetachedFromVillageFlag;
    }

    public void setIsDetachedFromVillageFlag(boolean detached) {
        this.isDetachedFromVillageFlag = detached;
    }

    public EnumFacing getInsideDirection() {
        return this.insideDirection;
    }
}

