/*
 * Decompiled with CFR 0.152.
 */
package nex.village;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import nex.village.PigtificateVillageCollection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PigtificateVillageManager {
    private static final Map<World, PigtificateVillageCollection> pigtificateVillages = Maps.newHashMap();
    private static final Logger LOGGER = LogManager.getLogger((String)"NetherEx|PigtificateVillageManager");

    public static void init(World world) {
        String dimension = world.field_73011_w.func_186058_p().name().toLowerCase();
        String id = PigtificateVillageCollection.fileNameForProvider(world.field_73011_w);
        PigtificateVillageCollection pigtificateVillageCollection = (PigtificateVillageCollection)world.getPerWorldStorage().func_75742_a(PigtificateVillageCollection.class, id);
        if (pigtificateVillageCollection == null) {
            LOGGER.info("The Pigtificate Village data for " + dimension + " was created successfully.");
            pigtificateVillages.put(world, new PigtificateVillageCollection(world));
            world.getPerWorldStorage().func_75745_a(id, (WorldSavedData)pigtificateVillages.get(world));
        } else {
            LOGGER.info("The Pigtificate Village data for " + dimension + " was read successfully.");
            pigtificateVillages.put(world, pigtificateVillageCollection);
            pigtificateVillages.get(world).setWorldsForAll(world);
        }
    }

    public static PigtificateVillageCollection getPigtificateVillages(World world) {
        return pigtificateVillages.get(world);
    }
}

