/*
 * Decompiled with CFR 0.152.
 */
package nex.world.biome;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import nex.block.BlockNetherrack;
import nex.handler.ConfigHandler;
import nex.init.NetherExBlocks;
import nex.util.RandomUtil;
import nex.world.biome.BiomeNetherEx;
import nex.world.gen.feature.WorldGenElderMushroom;
import nex.world.gen.feature.WorldGenEnokiMushroom;

public class BiomeFungiForest
extends BiomeNetherEx {
    private final WorldGenerator elderMushroom = new WorldGenElderMushroom(WorldGenElderMushroom.allVariants, true);
    private final WorldGenerator enokiMushroom = new WorldGenEnokiMushroom();

    public BiomeFungiForest() {
        super(new Biome.BiomeProperties("Fungi Forest").func_185410_a(1.1f).func_185395_b(0.0f).func_185396_a(), "fungi_forest");
        this.field_76752_A = NetherExBlocks.BLOCK_HYPHAE.func_176223_P();
        this.field_76753_B = NetherExBlocks.BLOCK_NETHERRACK.func_176223_P().func_177226_a(BlockNetherrack.TYPE, (Comparable)((Object)BlockNetherrack.EnumType.LIVELY));
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        int i;
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(world, rand, pos));
        if (ConfigHandler.biome.fungiForest.generateElderMushrooms) {
            for (i = 0; i < ConfigHandler.biome.fungiForest.elderMushroomRarity * 16; ++i) {
                this.elderMushroom.func_180709_b(world, rand, pos.func_177982_a(rand.nextInt(16) + 8, RandomUtil.getNumberInRange(32, 112, rand), rand.nextInt(16) + 8));
            }
        }
        if (ConfigHandler.biome.fungiForest.generateEnokiMushrooms) {
            for (i = 0; i < ConfigHandler.biome.fungiForest.enokiMushroomRarity * 16; ++i) {
                this.enokiMushroom.func_180709_b(world, rand, pos.func_177982_a(rand.nextInt(16) + 8, RandomUtil.getNumberInRange(32, 128, rand), rand.nextInt(16) + 8));
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(world, rand, pos));
    }
}

