/*
 * Decompiled with CFR 0.152.
 */
package nex.world.biome;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import nex.NetherEx;
import nex.util.BlockUtil;
import nex.util.FileUtil;
import nex.world.biome.NetherBiome;
import nex.world.gen.feature.Feature;
import nex.world.gen.feature.FeatureClumped;
import nex.world.gen.feature.FeatureFluid;
import nex.world.gen.feature.FeatureOre;
import nex.world.gen.feature.FeaturePool;
import nex.world.gen.feature.FeatureScattered;
import nex.world.gen.feature.FeatureStructure;
import nex.world.gen.layer.GenLayerNetherEx;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetherBiomeManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"NetherEx|NetherBiomeManager");

    public static void postInit(File directory) {
        try {
            if (!directory.exists()) {
                directory.mkdirs();
            }
            LOGGER.info("Copying the Biome List Directory to the config folder.");
            if (NetherEx.IS_DEV_ENV) {
                FileUtils.copyDirectory((File)new File(NetherEx.class.getResource("/assets/nex/biome_lists").getFile()), (File)directory);
            } else {
                FileUtil.extractFromJar("/assets/nex/biome_lists", directory.getPath());
            }
        }
        catch (IOException e) {
            LOGGER.fatal("The attempt to copy the Biome List Directory to the config folder was unsuccessful.");
            LOGGER.fatal((Object)e);
        }
        Gson gson = new Gson();
        ArrayList netherBiomeFiles = Lists.newArrayList((Object[])directory.listFiles());
        try {
            for (File netherBiomeFile : netherBiomeFiles) {
                String jsonText = Files.toString((File)netherBiomeFile, (Charset)Charsets.UTF_8);
                NetherBiome.BiomeList biomeList = (NetherBiome.BiomeList)gson.fromJson(jsonText, NetherBiome.BiomeList.class);
                LOGGER.info("Adding biomes from the " + biomeList.getName() + ".");
                for (NetherBiome.Mod biomeMod : biomeList.getMods()) {
                    for (NetherBiome netherBiome : biomeMod.getBiomes()) {
                        IBlockState state;
                        ResourceLocation biomeRegistryName = new ResourceLocation(biomeMod.getId() + ":" + netherBiome.getId());
                        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(biomeRegistryName);
                        if (biome == null) continue;
                        NetherBiome.BiomeBlock biomeTopBlock = netherBiome.getTopBlock();
                        NetherBiome.BiomeBlock biomeFillerBlock = netherBiome.getFillerBlock();
                        NetherBiome.BiomeBlock biomeOceanBlock = netherBiome.getOceanBlock();
                        IBlockState topBlock = biome.field_76752_A;
                        IBlockState fillerBlock = biome.field_76753_B;
                        IBlockState oceanBlock = Blocks.field_150353_l.func_176223_P();
                        if (biomeTopBlock != null) {
                            state = BlockUtil.getBlock(biomeTopBlock, "minecraft:air");
                            topBlock = state.func_177230_c() == Blocks.field_150350_a ? topBlock : state;
                            LOGGER.info("Set the " + biome.getRegistryName().toString() + " biome's top Block to " + topBlock.func_177230_c().getRegistryName().toString() + " with a meta of " + topBlock.func_177230_c().func_176201_c(topBlock) + ".");
                        }
                        if (biomeFillerBlock != null) {
                            state = BlockUtil.getBlock(biomeFillerBlock, "minecraft:air");
                            fillerBlock = state.func_177230_c() == Blocks.field_150350_a ? fillerBlock : state;
                            LOGGER.info("Set the " + biome.getRegistryName().toString() + " biome's filler Block to " + fillerBlock.func_177230_c().getRegistryName().toString() + " with a meta of " + fillerBlock.func_177230_c().func_176201_c(fillerBlock) + ".");
                        }
                        if (biomeOceanBlock != null) {
                            state = BlockUtil.getBlock(biomeOceanBlock, "minecraft:air");
                            oceanBlock = state.func_177230_c() == Blocks.field_150350_a ? oceanBlock : state;
                            LOGGER.info("Set the " + biome.getRegistryName().toString() + " biome's ocean Block to " + oceanBlock.func_177230_c().getRegistryName().toString() + " with a meta of " + oceanBlock.func_177230_c().func_176201_c(oceanBlock) + ".");
                        }
                        HashMap entitySpawnList = Maps.newHashMap();
                        for (EnumCreatureType creatureType : EnumCreatureType.values()) {
                            entitySpawnList.put(creatureType, Lists.newArrayList());
                        }
                        if (netherBiome.getEntitySpawnList() != null) {
                            for (NetherBiome.BiomeEntity entity : netherBiome.getEntitySpawnList()) {
                                for (EnumCreatureType creatureType : EnumCreatureType.values()) {
                                    Class cls;
                                    if (!creatureType.toString().equalsIgnoreCase(entity.getCreatureType()) || (cls = ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entity.getId()))).getEntityClass()) == null || !EntityLiving.class.isAssignableFrom(cls)) continue;
                                    ((List)entitySpawnList.get(creatureType)).add(new Biome.SpawnListEntry(cls, entity.getWeight(), entity.getMinGroupCount(), entity.getMaxGroupCount()));
                                    LOGGER.info("Added the " + entity.getId() + " Entity to the " + biome.getRegistryName().toString() + " biome.");
                                }
                            }
                        }
                        ArrayList features = Lists.newArrayList();
                        if (netherBiome.getFeatureList() != null) {
                            for (NetherBiome.BiomeFeature biomeFeature : netherBiome.getFeatureList()) {
                                Feature feature;
                                Feature.FeatureType featureType = Feature.FeatureType.getFromString(biomeFeature.getFeatureType());
                                if (featureType == Feature.FeatureType.SCATTERED) {
                                    feature = new FeatureScattered(biome, biomeFeature);
                                } else if (featureType == Feature.FeatureType.CLUMPED) {
                                    feature = new FeatureClumped(biome, biomeFeature);
                                } else if (featureType == Feature.FeatureType.ORE) {
                                    feature = new FeatureOre(biome, biomeFeature);
                                } else if (featureType == Feature.FeatureType.FLUID) {
                                    feature = new FeatureFluid(biome, biomeFeature);
                                } else if (featureType == Feature.FeatureType.POOL) {
                                    feature = new FeaturePool(biome, biomeFeature);
                                } else if (featureType == Feature.FeatureType.STRUCTURE) {
                                    feature = new FeatureStructure(biome, biomeFeature);
                                } else {
                                    LOGGER.info("A biome feature with the type of " + biomeFeature.getFeatureType() + " is unknown.");
                                    continue;
                                }
                                features.add(feature);
                            }
                        }
                        NetherBiomeType.getFromString(netherBiome.getClimateType()).addBiome(biome, netherBiome.getWeight(), topBlock, fillerBlock, oceanBlock, entitySpawnList, features);
                        LOGGER.info("Added the " + biome.getRegistryName().toString() + " biome from the " + biomeList.getName() + " to the Nether.");
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.fatal("NetherEx was unable to read the Biome lists.");
            LOGGER.fatal((Object)e);
        }
    }

    public static List<NetherBiomeEntry> getAllBiomeEntries() {
        ArrayList biomes = Lists.newArrayList();
        for (NetherBiomeType biomeType : NetherBiomeType.values()) {
            biomes.addAll(biomeType.getBiomeEntries());
        }
        return biomes;
    }

    public static Biome getRandomBiome(List<NetherBiomeEntry> biomeEntryList, Random rand) {
        return ((NetherBiomeEntry)WeightedRandom.func_180166_a(biomeEntryList, (int)rand.nextInt(WeightedRandom.func_76272_a(biomeEntryList)))).getBiome();
    }

    public static Biome getRandomBiome(List<NetherBiomeEntry> biomeEntryList, GenLayerNetherEx layer) {
        return ((NetherBiomeEntry)WeightedRandom.func_180166_a(biomeEntryList, (int)layer.func_75902_a(WeightedRandom.func_76272_a(biomeEntryList)))).getBiome();
    }

    public static IBlockState getBiomeTopBlock(Biome biome) {
        Map<Biome, NetherBiomeEntry> biomeEntryMap = NetherBiomeType.getFromBiome(biome).getBiomeEntryMap();
        if (biomeEntryMap.containsKey(biome)) {
            return biomeEntryMap.get(biome).getTopBlock();
        }
        return biome.field_76752_A;
    }

    public static IBlockState getBiomeFillerBlock(Biome biome) {
        Map<Biome, NetherBiomeEntry> biomeEntryMap = NetherBiomeType.getFromBiome(biome).getBiomeEntryMap();
        if (biomeEntryMap.containsKey(biome)) {
            return biomeEntryMap.get(biome).getFillerBlock();
        }
        return biome.field_76753_B;
    }

    public static IBlockState getBiomeOceanBlock(Biome biome) {
        Map<Biome, NetherBiomeEntry> biomeEntryMap = NetherBiomeType.getFromBiome(biome).getBiomeEntryMap();
        if (biomeEntryMap.containsKey(biome)) {
            return biomeEntryMap.get(biome).getOceanBlock();
        }
        return Blocks.field_150353_l.func_176223_P();
    }

    public static Map<EnumCreatureType, List<Biome.SpawnListEntry>> getBiomeEntitySpawnList(Biome biome) {
        Map<Biome, NetherBiomeEntry> biomeEntryMap = NetherBiomeType.getFromBiome(biome).getBiomeEntryMap();
        if (biomeEntryMap.containsKey(biome)) {
            return biomeEntryMap.get(biome).getEntitySpawnList();
        }
        HashMap entitySpawnList = Maps.newHashMap();
        for (EnumCreatureType creatureType : EnumCreatureType.values()) {
            entitySpawnList.put(creatureType, Lists.newArrayList());
        }
        return entitySpawnList;
    }

    public static List<Feature> getBiomeFeatures(Biome biome) {
        Map<Biome, NetherBiomeEntry> biomeEntryMap = NetherBiomeType.getFromBiome(biome).getBiomeEntryMap();
        if (biomeEntryMap.containsKey(biome)) {
            return biomeEntryMap.get(biome).getFeatures();
        }
        return Lists.newArrayList();
    }

    public static class NetherBiomeEntry
    extends BiomeManager.BiomeEntry {
        private final IBlockState topBlock;
        private final IBlockState fillerBlock;
        private final IBlockState oceanBlock;
        private final Map<EnumCreatureType, List<Biome.SpawnListEntry>> entitySpawnList;
        private final List<Feature> features;

        public NetherBiomeEntry(Biome biome, int weight, IBlockState topBlockIn, IBlockState fillerBlockIn, IBlockState oceanBlockIn, Map<EnumCreatureType, List<Biome.SpawnListEntry>> entitySpawnListIn, List<Feature> featuresIn) {
            super(biome, weight <= 0 ? 10 : weight);
            this.topBlock = topBlockIn;
            this.fillerBlock = fillerBlockIn;
            this.oceanBlock = oceanBlockIn;
            this.entitySpawnList = entitySpawnListIn;
            this.features = featuresIn;
        }

        public Biome getBiome() {
            return this.biome;
        }

        public int getWeight() {
            return this.field_76292_a;
        }

        public IBlockState getTopBlock() {
            return this.topBlock;
        }

        public IBlockState getFillerBlock() {
            return this.fillerBlock;
        }

        public IBlockState getOceanBlock() {
            return this.oceanBlock;
        }

        public Map<EnumCreatureType, List<Biome.SpawnListEntry>> getEntitySpawnList() {
            return this.entitySpawnList;
        }

        public List<Feature> getFeatures() {
            return this.features;
        }
    }

    public static enum NetherBiomeType {
        HOT,
        WARM,
        TEMPERATE,
        COOL,
        COLD;

        private static final Map<Biome, NetherBiomeEntry> biomeEntryMap;

        public void addBiome(Biome biome, int weight, IBlockState topBlock, IBlockState fillerBlock, IBlockState oceanBlock, Map<EnumCreatureType, List<Biome.SpawnListEntry>> entitySpawnList, List<Feature> features) {
            biomeEntryMap.put(biome, new NetherBiomeEntry(biome, weight, topBlock, fillerBlock, oceanBlock, entitySpawnList, features));
        }

        public static NetherBiomeType getFromBiome(Biome biome) {
            for (NetherBiomeType biomeType : NetherBiomeType.values()) {
                for (NetherBiomeEntry biomeEntry : biomeType.getBiomeEntries()) {
                    if (biomeEntry.biome != biome) continue;
                    return biomeType;
                }
            }
            return TEMPERATE;
        }

        public static NetherBiomeType getFromString(String string) {
            if (!Strings.isNullOrEmpty((String)string)) {
                for (NetherBiomeType biomeType : NetherBiomeType.values()) {
                    if (!biomeType.name().equalsIgnoreCase(string)) continue;
                    return biomeType;
                }
            }
            return TEMPERATE;
        }

        public Map<Biome, NetherBiomeEntry> getBiomeEntryMap() {
            return ImmutableMap.copyOf(biomeEntryMap);
        }

        public List<NetherBiomeEntry> getBiomeEntries() {
            return ImmutableList.copyOf(biomeEntryMap.values());
        }

        static {
            biomeEntryMap = Maps.newHashMap();
        }
    }
}

