/*
 * Decompiled with CFR 0.152.
 */
package nex.world.gen;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.ChunkProviderHell;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCavesHell;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;
import nex.handler.ConfigHandler;
import nex.util.RandomUtil;
import nex.world.biome.NetherBiomeManager;
import nex.world.gen.feature.Feature;

public class ChunkProviderNether
extends ChunkProviderHell {
    private final World world;
    private final Random rand;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves noiseGenSoulSandGravel;
    private NoiseGeneratorOctaves noiseGenNetherrack;
    private NoiseGeneratorOctaves noiseGenScale;
    private NoiseGeneratorOctaves noiseGenDepth;
    private Biome[] biomesForGen;
    private double[] buffer;
    private double[] depthBuffer = new double[256];
    private double[] soulSandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] noiseData1;
    private double[] noiseData2;
    private double[] noiseData3;
    private double[] noiseData4;
    private double[] noiseData5;
    private MapGenCavesHell netherCaves = new MapGenCavesHell();
    private MapGenNetherBridge netherBridge = new MapGenNetherBridge();

    public ChunkProviderNether(World worldIn) {
        super(worldIn, true, worldIn.func_72905_C());
        this.world = worldIn;
        this.rand = new Random(this.world.func_72905_C());
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGenSoulSandGravel = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGenNetherrack = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGenScale = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGenDepth = new NoiseGeneratorOctaves(this.rand, 16);
        InitNoiseGensEvent.ContextHell ctx = new InitNoiseGensEvent.ContextHell(this.noiseGen1, this.noiseGen2, this.noiseGen3, this.noiseGenSoulSandGravel, this.noiseGenNetherrack, this.noiseGenScale, this.noiseGenDepth);
        ctx = (InitNoiseGensEvent.ContextHell)TerrainGen.getModdedNoiseGenerators((World)this.world, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
        this.noiseGen1 = ctx.getLPerlin1();
        this.noiseGen2 = ctx.getLPerlin2();
        this.noiseGen3 = ctx.getPerlin();
        this.noiseGenSoulSandGravel = ctx.getPerlin2();
        this.noiseGenNetherrack = ctx.getPerlin3();
        this.noiseGenScale = ctx.getScale();
        this.noiseGenDepth = ctx.getDepth();
        this.netherCaves = (MapGenCavesHell)TerrainGen.getModdedMapGen((MapGenBase)this.netherCaves, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_CAVE);
        this.netherBridge = (MapGenNetherBridge)TerrainGen.getModdedMapGen((MapGenBase)this.netherBridge, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_BRIDGE);
        worldIn.func_181544_b(31);
    }

    public void func_185936_a(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.buffer = this.generateHeightMap(this.buffer, chunkX * 4, 0, chunkZ * 4, 5, 17, 5);
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                for (int y = 0; y < 16; ++y) {
                    double d1 = this.buffer[(x * 5 + z) * 17 + y];
                    double d2 = this.buffer[(x * 5 + z + 1) * 17 + y];
                    double d3 = this.buffer[((x + 1) * 5 + z) * 17 + y];
                    double d4 = this.buffer[((x + 1) * 5 + z + 1) * 17 + y];
                    double d5 = (this.buffer[(x * 5 + z) * 17 + y + 1] - d1) * 0.125;
                    double d6 = (this.buffer[(x * 5 + z + 1) * 17 + y + 1] - d2) * 0.125;
                    double d7 = (this.buffer[((x + 1) * 5 + z) * 17 + y + 1] - d3) * 0.125;
                    double d8 = (this.buffer[((x + 1) * 5 + z + 1) * 17 + y + 1] - d4) * 0.125;
                    for (int y2 = 0; y2 < 8; ++y2) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int x2 = 0; x2 < 4; ++x2) {
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.25;
                            for (int z2 = 0; z2 < 4; ++z2) {
                                int posX = x2 + x * 4;
                                int posY = y2 + y * 8;
                                int posZ = z2 + z * 4;
                                Biome biome = this.biomesForGen[posX + posZ * 16];
                                IBlockState state = null;
                                IBlockState biomeFillerBlock = NetherBiomeManager.getBiomeFillerBlock(biome);
                                IBlockState biomeOceanBlock = NetherBiomeManager.getBiomeOceanBlock(biome);
                                if (posY < 32) {
                                    state = biomeOceanBlock;
                                }
                                if (d15 > 0.0) {
                                    state = biomeFillerBlock;
                                }
                                primer.func_177855_a(posX, posY, posZ, state);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void func_185937_b(int chunkX, int chunkZ, ChunkPrimer primer) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        this.soulSandNoise = this.noiseGenSoulSandGravel.func_76304_a(this.soulSandNoise, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, 0.03125, 0.03125, 1.0);
        this.gravelNoise = this.noiseGenSoulSandGravel.func_76304_a(this.gravelNoise, chunkX * 16, 109, chunkZ * 16, 16, 1, 16, 0.03125, 1.0, 0.03125);
        this.depthBuffer = this.noiseGenNetherrack.func_76304_a(this.depthBuffer, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, 0.0625, 0.0625, 0.0625);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int l = (int)(this.depthBuffer[x + z * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int i1 = -1;
                boolean genSoulSand = this.soulSandNoise[x + z * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean genGravel = this.gravelNoise[x + z * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                Biome biome = this.biomesForGen[x + z * 16];
                IBlockState biomeTopBlock = NetherBiomeManager.getBiomeTopBlock(biome);
                IBlockState biomeFillerBlock = NetherBiomeManager.getBiomeFillerBlock(biome);
                IBlockState biomeOceanBlock = NetherBiomeManager.getBiomeOceanBlock(biome);
                IBlockState topBlock = biomeTopBlock;
                IBlockState fillerBlock = biomeFillerBlock;
                for (int y = 127; y >= 0; --y) {
                    if (y < 127 && y > 0) {
                        IBlockState checkBlock = primer.func_177856_a(x, y, z);
                        if (checkBlock.func_185904_a() != Material.field_151579_a) {
                            if (checkBlock != biomeFillerBlock) continue;
                            if (i1 == -1) {
                                if (l <= 0) {
                                    topBlock = Blocks.field_150350_a.func_176223_P();
                                    fillerBlock = biomeTopBlock;
                                } else if (y >= 62 && y <= 66) {
                                    topBlock = biomeTopBlock;
                                    fillerBlock = biomeFillerBlock;
                                    if (ConfigHandler.dimension.nether.generateGravel && genGravel) {
                                        topBlock = Blocks.field_150351_n.func_176223_P();
                                    }
                                    if (ConfigHandler.dimension.nether.generateSoulSand && genSoulSand) {
                                        topBlock = Blocks.field_150425_aM.func_176223_P();
                                        fillerBlock = Blocks.field_150425_aM.func_176223_P();
                                    }
                                }
                                if (y <= 32 && (topBlock == null || topBlock.func_185904_a() == Material.field_151579_a)) {
                                    topBlock = biomeOceanBlock;
                                }
                                i1 = l;
                                if (topBlock == biomeTopBlock && fillerBlock == biomeFillerBlock) {
                                    primer.func_177855_a(x, y, z, topBlock);
                                    continue;
                                }
                                if (y > 64) {
                                    primer.func_177855_a(x, y, z, topBlock);
                                    continue;
                                }
                                primer.func_177855_a(x, y, z, fillerBlock);
                                continue;
                            }
                            if (i1 <= 0) continue;
                            --i1;
                            primer.func_177855_a(x, y, z, fillerBlock);
                            continue;
                        }
                        i1 = -1;
                        continue;
                    }
                    primer.func_177855_a(x, y, z, Blocks.field_150357_h.func_176223_P());
                }
            }
        }
    }

    private double[] generateHeightMap(double[] heightMap, int posX, int posY, int posZ, int xSize, int ySize, int zSize) {
        if (heightMap == null) {
            heightMap = new double[xSize * ySize * zSize];
        }
        ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this, heightMap, posX, posY, posZ, xSize, ySize, zSize);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getNoisefield();
        }
        this.noiseData4 = this.noiseGenScale.func_76304_a(this.noiseData4, posX, posY, posZ, xSize, 1, zSize, 1.0, 0.0, 1.0);
        this.noiseData5 = this.noiseGenDepth.func_76304_a(this.noiseData5, posX, posY, posZ, xSize, 1, zSize, 100.0, 0.0, 100.0);
        this.noiseData1 = this.noiseGen3.func_76304_a(this.noiseData1, posX, posY, posZ, xSize, ySize, zSize, 8.555150000000001, 34.2206, 8.555150000000001);
        this.noiseData2 = this.noiseGen1.func_76304_a(this.noiseData2, posX, posY, posZ, xSize, ySize, zSize, 684.412, 2053.236, 684.412);
        this.noiseData3 = this.noiseGen2.func_76304_a(this.noiseData3, posX, posY, posZ, xSize, ySize, zSize, 684.412, 2053.236, 684.412);
        double[] newYSize = new double[ySize];
        for (int j = 0; j < ySize; ++j) {
            newYSize[j] = Math.cos((double)j * Math.PI * 6.0 / (double)ySize) * 2.0;
            double d2 = j;
            if (j > ySize / 2) {
                d2 = ySize - 1 - j;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = j;
            newYSize[n] = newYSize[n] - d2 * d2 * d2 * 10.0;
        }
        int index = 0;
        for (int l = 0; l < xSize; ++l) {
            for (int i1 = 0; i1 < zSize; ++i1) {
                for (int k = 0; k < ySize; ++k) {
                    double d4 = newYSize[k];
                    double d5 = this.noiseData2[index] / 512.0;
                    double d6 = this.noiseData3[index] / 512.0;
                    double d7 = (this.noiseData1[index] / 10.0 + 1.0) / 2.0;
                    double d8 = d7 < 0.0 ? d5 : (d7 > 1.0 ? d6 : d5 + (d6 - d5) * d7);
                    d8 -= d4;
                    if (k > ySize - 4) {
                        double d9 = (float)(k - (ySize - 4)) / 3.0f;
                        d8 = d8 * (1.0 - d9) + -10.0 * d9;
                    }
                    if ((double)k < 0.0) {
                        double d10 = (0.0 - (double)k) / 4.0;
                        d10 = MathHelper.func_151237_a((double)d10, (double)0.0, (double)1.0);
                        d8 = d8 * (1.0 - d10) + -10.0 * d10;
                    }
                    heightMap[index] = d8;
                    ++index;
                }
            }
        }
        return heightMap;
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        ChunkPrimer primer = new ChunkPrimer();
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.biomesForGen = this.world.func_72959_q().func_76933_b(null, chunkX * 16, chunkZ * 16, 16, 16);
        this.func_185936_a(chunkX, chunkZ, primer);
        this.func_185937_b(chunkX, chunkZ, primer);
        this.netherCaves.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.netherBridge.func_186125_a(this.world, chunkX, chunkZ, primer);
        Chunk chunk = new Chunk(this.world, primer, chunkX, chunkZ);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGen[i]);
        }
        chunk.func_76613_n();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        boolean logCascadingWorldGeneration = ForgeModContainer.logCascadingWorldGeneration;
        ForgeModContainer.logCascadingWorldGeneration = false;
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        BlockPos blockPos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        Biome biome = this.world.func_180494_b(blockPos.func_177982_a(16, 0, 16));
        BlockFalling.field_149832_M = true;
        this.netherBridge.func_175794_a(this.world, this.rand, chunkPos);
        List<Feature> features = NetherBiomeManager.getBiomeFeatures(biome);
        if (features.size() > 0) {
            for (Feature feature : features) {
                int i;
                int featureRarity;
                if (feature.getBiome() != biome || !feature.canGenerate()) continue;
                int n = featureRarity = feature.useRandomRarity() ? this.rand.nextInt(feature.getRarity()) + 1 : feature.getRarity();
                if (feature.getType() == Feature.FeatureType.ORE) {
                    MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(this.world, this.rand, blockPos));
                    if (!feature.isSuperRare()) {
                        for (i = 0; i < featureRarity; ++i) {
                            feature.generate(this.world, blockPos.func_177982_a(this.rand.nextInt(16), RandomUtil.getNumberInRange(feature.getMinHeight(), feature.getMaxHeight(), this.rand), this.rand.nextInt(16)), this.rand);
                        }
                    } else if (this.rand.nextInt(featureRarity) == 0) {
                        feature.generate(this.world, blockPos.func_177982_a(this.rand.nextInt(16), RandomUtil.getNumberInRange(feature.getMinHeight(), feature.getMaxHeight(), this.rand), this.rand.nextInt(16)), this.rand);
                    }
                    MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(this.world, this.rand, blockPos));
                    continue;
                }
                MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.world, this.rand, blockPos));
                if (!feature.isSuperRare()) {
                    for (i = 0; i < featureRarity; ++i) {
                        feature.generate(this.world, blockPos.func_177982_a(this.rand.nextInt(16) + 8, RandomUtil.getNumberInRange(feature.getMinHeight(), feature.getMaxHeight(), this.rand), this.rand.nextInt(16) + 8), this.rand);
                    }
                } else if (this.rand.nextInt(featureRarity) == 0) {
                    feature.generate(this.world, blockPos.func_177982_a(this.rand.nextInt(16) + 8, RandomUtil.getNumberInRange(feature.getMinHeight(), feature.getMaxHeight(), this.rand), this.rand.nextInt(16) + 8), this.rand);
                }
                MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.world, this.rand, blockPos));
            }
        }
        biome.func_180624_a(this.world, this.rand, blockPos);
        BlockFalling.field_149832_M = false;
        ForgeModContainer.logCascadingWorldGeneration = logCascadingWorldGeneration;
    }

    public boolean func_185933_a(Chunk chunk, int chunkX, int chunkZ) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        if (creatureType == EnumCreatureType.MONSTER) {
            if (this.netherBridge.func_175795_b(pos)) {
                return this.netherBridge.func_75059_a();
            }
            if (this.netherBridge.func_175796_a(this.world, pos) && this.world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150385_bj) {
                return this.netherBridge.func_75059_a();
            }
        }
        Biome biome = this.world.func_180494_b(pos);
        return NetherBiomeManager.getBiomeEntitySpawnList(biome).get(creatureType);
    }

    public BlockPos func_180513_a(World world, String structureName, BlockPos pos, boolean force) {
        if ("Fortress".equals(structureName)) {
            return this.netherBridge != null ? this.netherBridge.func_180706_b(world, pos, force) : null;
        }
        return null;
    }

    public void func_180514_a(Chunk chunk, int chunkX, int chunkZ) {
        this.netherBridge.func_186125_a(this.world, chunkX, chunkZ, null);
    }
}

