/*
 * Decompiled with CFR 0.152.
 */
package nex.world.gen.feature;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import nex.util.BlockUtil;
import nex.world.biome.NetherBiome;
import nex.world.gen.feature.Feature;

public class FeatureClumped
extends Feature {
    private final IBlockState blockToSpawn;

    public FeatureClumped(Biome biome, NetherBiome.BiomeFeature feature) {
        super(biome, feature);
        this.blockToSpawn = BlockUtil.getBlock(feature.getBlockToSpawn(), "minecraft:air");
    }

    @Override
    public boolean generate(World world, BlockPos pos, Random rand) {
        if (!world.func_175623_d(pos)) {
            return false;
        }
        if (!world.func_180495_p(pos.func_177984_a()).isSideSolid((IBlockAccess)world, pos.func_177984_a(), EnumFacing.DOWN)) {
            return false;
        }
        world.func_180501_a(pos, this.blockToSpawn, 3);
        for (int i = 0; i < 1500; ++i) {
            BlockPos newPos = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), -rand.nextInt(12), rand.nextInt(8) - rand.nextInt(8));
            if (!world.func_175623_d(newPos)) continue;
            int j = 0;
            for (EnumFacing enumfacing : EnumFacing.values()) {
                if (world.func_180495_p(newPos.func_177972_a(enumfacing)).func_177230_c() == this.blockToSpawn.func_177230_c()) {
                    ++j;
                }
                if (j > 1) break;
            }
            if (j != true) continue;
            world.func_180501_a(newPos, this.blockToSpawn, 3);
        }
        return true;
    }

    @Override
    public boolean canGenerate() {
        return this.blockToSpawn != Blocks.field_150350_a.func_176223_P();
    }

    @Override
    public Feature.FeatureType getType() {
        return Feature.FeatureType.CLUMPED;
    }
}

