/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.capability.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.common.capability.IFastRunning;
import com.alrex.parcool.common.capability.IVault;
import com.alrex.parcool.utilities.WorldUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Vault
implements IVault {
    private int vaultingTime = 0;
    private boolean vaulting = false;

    @Override
    public int getVaultAnimateTime() {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canVault(EntityPlayer player) {
        IFastRunning fastRunning = IFastRunning.get(player);
        if (fastRunning == null) {
            return false;
        }
        Vec3d lookVec = player.func_70040_Z();
        lookVec = new Vec3d(lookVec.field_72450_a, 0.0, lookVec.field_72449_c).func_72432_b();
        Vec3d wall = WorldUtil.getWall((EntityLivingBase)player);
        if (wall == null) {
            return false;
        }
        return !this.vaulting && ParCoolConfig.client.canVault && fastRunning.isFastRunning() && fastRunning.getRunningTime() > 20 && player.field_70124_G && wall.func_72430_b(lookVec) / wall.func_72433_c() / lookVec.func_72433_c() > 0.707106 && WorldUtil.getStep((EntityLivingBase)player) != null && WorldUtil.getWallHeight((EntityLivingBase)player) > 0.8;
    }

    @Override
    public int getVaultingTime() {
        return this.vaultingTime;
    }

    @Override
    public void setVaulting(boolean vaulting) {
        this.vaulting = vaulting;
        if (!vaulting) {
            this.vaultingTime = 0;
        }
    }

    @Override
    public boolean isVaulting() {
        return this.vaulting;
    }

    @Override
    public void updateVaultingTime() {
        if (this.vaulting) {
            ++this.vaultingTime;
        }
        if (this.vaultingTime > this.getVaultAnimateTime()) {
            this.vaultingTime = 0;
            this.vaulting = false;
        }
    }
}

