/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.capability.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.client.utils.StateRecorder;
import com.alrex.parcool.common.capability.IGrabCliff;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.IWallJump;
import com.alrex.parcool.utilities.WorldUtil;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WallJump
implements IWallJump {
    @Override
    public double getJumpPower() {
        return 0.3;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canWallJump(EntityPlayer player) {
        IStamina stamina = IStamina.get(player);
        IGrabCliff grabCliff = IGrabCliff.get(player);
        if (stamina == null || grabCliff == null) {
            return false;
        }
        return !stamina.isExhausted() && ParCoolConfig.client.canWallJump && StateRecorder.INSTANCE.tickNotLanding > 4 && !player.field_70122_E && !player.func_70090_H() && !player.func_184613_cA() && !player.field_71075_bZ.field_75100_b && !grabCliff.isGrabbing() && KeyRecorder.keyJumpState.isPressed() && WorldUtil.getWall((EntityLivingBase)player) != null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public Vec3d getJumpDirection(EntityPlayer player) {
        Vec3d value;
        Vec3d wall = WorldUtil.getWall((EntityLivingBase)player);
        if (wall == null) {
            return null;
        }
        Vec3d lookVec = player.func_70040_Z();
        Vec3d vec = new Vec3d(lookVec.field_72450_a, 0.0, lookVec.field_72449_c).func_72432_b();
        if (wall.func_72430_b(vec) > 0.0) {
            double dot = new Vec3d(-vec.field_72450_a, 0.0, -vec.field_72449_c).func_72430_b(wall);
            value = vec.func_178787_e(wall.func_186678_a(2.0 * dot / wall.func_72433_c()));
        } else {
            value = vec;
        }
        return value.func_72432_b().func_178787_e(wall.func_186678_a(-0.7));
    }

    @Override
    public int getStaminaConsumption() {
        return 200;
    }
}

