/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.IDodge;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SyncDodgeMessage
implements IMessage {
    private UUID playerID = null;
    private boolean isDodging = false;
    private String dodgeDirection = null;

    public void toBytes(ByteBuf packet) {
        packet.writeBoolean(this.isDodging);
        String name = this.dodgeDirection;
        packet.writeInt(name.length());
        packet.writeCharSequence((CharSequence)name, StandardCharsets.US_ASCII);
        packet.writeLong(this.playerID.getMostSignificantBits());
        packet.writeLong(this.playerID.getLeastSignificantBits());
    }

    public void fromBytes(ByteBuf packet) {
        this.isDodging = packet.readBoolean();
        this.dodgeDirection = packet.readCharSequence(packet.readInt(), StandardCharsets.US_ASCII).toString();
        this.playerID = new UUID(packet.readLong(), packet.readLong());
    }

    @SideOnly(value=Side.CLIENT)
    public static void sync(EntityPlayer player) {
        IDodge dodge = IDodge.get(player);
        if (dodge == null) {
            return;
        }
        SyncDodgeMessage message = new SyncDodgeMessage();
        message.isDodging = dodge.isDodging();
        message.playerID = player.func_110124_au();
        IDodge.DodgeDirection direction = dodge.getDirection();
        if (direction == null) {
            return;
        }
        message.dodgeDirection = direction.name();
        ParCool.CHANNEL_INSTANCE.sendToServer((IMessage)message);
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientHandler
    implements IMessageHandler<SyncDodgeMessage, SyncDodgeMessage> {
        public SyncDodgeMessage onMessage(SyncDodgeMessage message, MessageContext context) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                IDodge dodge;
                EntityPlayerMP player;
                if (context.side == Side.CLIENT) {
                    WorldClient world = Minecraft.func_71410_x().field_71441_e;
                    if (world == null) {
                        return;
                    }
                    player = world.func_152378_a(message.playerID);
                    if (player == null || player.func_175144_cb()) {
                        return;
                    }
                } else {
                    player = context.getServerHandler().field_147369_b;
                    ParCool.CHANNEL_INSTANCE.sendToAll((IMessage)message);
                    if (player == null) {
                        return;
                    }
                }
                if ((dodge = IDodge.get((EntityPlayer)player)) == null) {
                    return;
                }
                dodge.setDirection(IDodge.DodgeDirection.valueOf(message.dodgeDirection));
                dodge.setDodging(message.isDodging);
            });
            return null;
        }
    }

    @SideOnly(value=Side.SERVER)
    public static class ServerHandler
    implements IMessageHandler<SyncDodgeMessage, SyncDodgeMessage> {
        public SyncDodgeMessage onMessage(SyncDodgeMessage message, MessageContext context) {
            EntityPlayerMP player = context.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                ParCool.CHANNEL_INSTANCE.sendToAll((IMessage)message);
                IDodge dodge = IDodge.get((EntityPlayer)player);
                if (dodge == null) {
                    return;
                }
                dodge.setDirection(IDodge.DodgeDirection.valueOf(message.dodgeDirection));
                dodge.setDodging(message.isDodging);
            });
            return null;
        }
    }
}

