/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.processor;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.IVault;
import com.alrex.parcool.utilities.PlayerUtils;
import com.alrex.parcool.utilities.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class VaultLogic {
    private static double wallHeight = 0.0;
    private static Vec3d stepDirection = null;

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.side == Side.SERVER) {
            return;
        }
        EntityPlayer player = event.player;
        IVault vault = IVault.get(player);
        if (vault == null) {
            return;
        }
        vault.updateVaultingTime();
        if (!player.func_175144_cb()) {
            return;
        }
        if (!ParCool.isActive()) {
            return;
        }
        if (!vault.isVaulting() && vault.canVault(player)) {
            vault.setVaulting(true);
            stepDirection = WorldUtil.getStep((EntityLivingBase)event.player);
            wallHeight = WorldUtil.getWallHeight((EntityLivingBase)event.player);
        }
        if (vault.isVaulting()) {
            PlayerUtils.setVelocity((Entity)player, new Vec3d(VaultLogic.stepDirection.field_72450_a / 10.0, (wallHeight + 0.05) / (double)vault.getVaultAnimateTime(), VaultLogic.stepDirection.field_72449_c / 10.0));
        }
        if (vault.getVaultingTime() >= vault.getVaultAnimateTime()) {
            vault.setVaulting(false);
            stepDirection = stepDirection.func_72432_b();
            PlayerUtils.setVelocity((Entity)player, new Vec3d(VaultLogic.stepDirection.field_72450_a * 0.45, 0.15, VaultLogic.stepDirection.field_72449_c * 0.45));
        }
    }
}

