/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.registry;

import com.blakebr0.cucumber.item.BaseBlockItem;
import com.blakebr0.pickletweaks.PickleTweaks;
import com.blakebr0.pickletweaks.feature.block.ColoredCobblestoneBlock;
import com.blakebr0.pickletweaks.feature.block.DarkGlassBlock;
import com.blakebr0.pickletweaks.feature.block.SmoothGlowstoneBlock;
import com.blakebr0.pickletweaks.registry.ModItems;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlocks {
    public static final Map<RegistryObject<Block>, Supplier<Block>> ENTRIES = new LinkedHashMap<RegistryObject<Block>, Supplier<Block>>();
    public static final RegistryObject<Block> WHITE_COBBLESTONE = ModBlocks.register("white_cobblestone", () -> new ColoredCobblestoneBlock(0xF9FFFE));
    public static final RegistryObject<Block> ORANGE_COBBLESTONE = ModBlocks.register("orange_cobblestone", () -> new ColoredCobblestoneBlock(16351261));
    public static final RegistryObject<Block> MAGENTA_COBBLESTONE = ModBlocks.register("magenta_cobblestone", () -> new ColoredCobblestoneBlock(13061821));
    public static final RegistryObject<Block> LIGHT_BLUE_COBBLESTONE = ModBlocks.register("light_blue_cobblestone", () -> new ColoredCobblestoneBlock(3847130));
    public static final RegistryObject<Block> YELLOW_COBBLESTONE = ModBlocks.register("yellow_cobblestone", () -> new ColoredCobblestoneBlock(16701501));
    public static final RegistryObject<Block> LIME_COBBLESTONE = ModBlocks.register("lime_cobblestone", () -> new ColoredCobblestoneBlock(8439583));
    public static final RegistryObject<Block> PINK_COBBLESTONE = ModBlocks.register("pink_cobblestone", () -> new ColoredCobblestoneBlock(15961002));
    public static final RegistryObject<Block> GRAY_COBBLESTONE = ModBlocks.register("gray_cobblestone", () -> new ColoredCobblestoneBlock(4673362));
    public static final RegistryObject<Block> LIGHT_GRAY_COBBLESTONE = ModBlocks.register("light_gray_cobblestone", () -> new ColoredCobblestoneBlock(0x9D9D97));
    public static final RegistryObject<Block> CYAN_COBBLESTONE = ModBlocks.register("cyan_cobblestone", () -> new ColoredCobblestoneBlock(1481884));
    public static final RegistryObject<Block> PURPLE_COBBLESTONE = ModBlocks.register("purple_cobblestone", () -> new ColoredCobblestoneBlock(8991416));
    public static final RegistryObject<Block> BLUE_COBBLESTONE = ModBlocks.register("blue_cobblestone", () -> new ColoredCobblestoneBlock(3949738));
    public static final RegistryObject<Block> BROWN_COBBLESTONE = ModBlocks.register("brown_cobblestone", () -> new ColoredCobblestoneBlock(8606770));
    public static final RegistryObject<Block> GREEN_COBBLESTONE = ModBlocks.register("green_cobblestone", () -> new ColoredCobblestoneBlock(6192150));
    public static final RegistryObject<Block> RED_COBBLESTONE = ModBlocks.register("red_cobblestone", () -> new ColoredCobblestoneBlock(11546150));
    public static final RegistryObject<Block> BLACK_COBBLESTONE = ModBlocks.register("black_cobblestone", () -> new ColoredCobblestoneBlock(0x1D1D21));
    public static final RegistryObject<Block> DARK_GLASS = ModBlocks.register("dark_glass", DarkGlassBlock::new);
    public static final RegistryObject<Block> SMOOTH_GLOWSTONE = ModBlocks.register("smooth_glowstone", SmoothGlowstoneBlock::new);

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        ENTRIES.forEach((reg, block) -> {
            registry.register((IForgeRegistryEntry)block.get());
            reg.updateReference(registry);
        });
    }

    private static RegistryObject<Block> register(String name, Supplier<Block> block) {
        return ModBlocks.register(name, block, b -> () -> new BaseBlockItem((Block)b.get(), p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    }

    private static RegistryObject<Block> register(String name, Supplier<Block> block, Function<RegistryObject<Block>, Supplier<? extends BlockItem>> item) {
        ResourceLocation loc = new ResourceLocation("pickletweaks", name);
        RegistryObject reg = RegistryObject.of((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.BLOCKS);
        ENTRIES.put((RegistryObject<Block>)reg, () -> (Block)((Block)block.get()).setRegistryName(loc));
        ModItems.BLOCK_ENTRIES.add(() -> (Item)((BlockItem)((Supplier)item.apply(reg)).get()).setRegistryName(loc));
        return reg;
    }
}

