/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.registry;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.pickletweaks.PickleTweaks;
import com.blakebr0.pickletweaks.feature.item.CoalPieceItem;
import com.blakebr0.pickletweaks.feature.item.DiamondAppleItem;
import com.blakebr0.pickletweaks.feature.item.EmeraldAppleItem;
import com.blakebr0.pickletweaks.feature.item.EmeraldArmorItem;
import com.blakebr0.pickletweaks.feature.item.FlintArmorItem;
import com.blakebr0.pickletweaks.feature.item.GrassFiberItem;
import com.blakebr0.pickletweaks.feature.item.MagnetItem;
import com.blakebr0.pickletweaks.feature.item.MeshItem;
import com.blakebr0.pickletweaks.feature.item.NightVisionGogglesItem;
import com.blakebr0.pickletweaks.feature.item.PaxelItem;
import com.blakebr0.pickletweaks.feature.item.WateringCanItem;
import com.blakebr0.pickletweaks.feature.item.tool.EmeraldAxeItem;
import com.blakebr0.pickletweaks.feature.item.tool.EmeraldHoeItem;
import com.blakebr0.pickletweaks.feature.item.tool.EmeraldPaxelItem;
import com.blakebr0.pickletweaks.feature.item.tool.EmeraldPickaxeItem;
import com.blakebr0.pickletweaks.feature.item.tool.EmeraldShovelItem;
import com.blakebr0.pickletweaks.feature.item.tool.EmeraldSwordItem;
import com.blakebr0.pickletweaks.feature.item.tool.FlintAxeItem;
import com.blakebr0.pickletweaks.feature.item.tool.FlintHoeItem;
import com.blakebr0.pickletweaks.feature.item.tool.FlintPaxelItem;
import com.blakebr0.pickletweaks.feature.item.tool.FlintPickaxeItem;
import com.blakebr0.pickletweaks.feature.item.tool.FlintShearsItem;
import com.blakebr0.pickletweaks.feature.item.tool.FlintShovelItem;
import com.blakebr0.pickletweaks.feature.item.tool.FlintSwordItem;
import com.blakebr0.pickletweaks.lib.ModArmorMaterial;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemTier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModItems {
    public static final List<Supplier<Item>> BLOCK_ENTRIES = new ArrayList<Supplier<Item>>();
    public static final Map<RegistryObject<Item>, Supplier<Item>> ENTRIES = new LinkedHashMap<RegistryObject<Item>, Supplier<Item>>();
    public static final RegistryObject<Item> COAL_PIECE = ModItems.register("coal_piece", () -> new CoalPieceItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> CHARCOAL_PIECE = ModItems.register("charcoal_piece", () -> new CoalPieceItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> DIAMOND_APPLE = ModItems.register("diamond_apple", () -> new DiamondAppleItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> EMERALD_APPLE = ModItems.register("emerald_apple", () -> new EmeraldAppleItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> WATERING_CAN = ModItems.register("watering_can", () -> new WateringCanItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> GRASS_FIBER = ModItems.register("grass_fiber", () -> new GrassFiberItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> GRASS_FIBER_MESH = ModItems.register("grass_fiber_mesh", () -> new MeshItem(20, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> MESH = ModItems.register("mesh", () -> new MeshItem(64, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> REINFORCED_MESH = ModItems.register("reinforced_mesh", () -> new MeshItem(512, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> MAGNET = ModItems.register("magnet", () -> new MagnetItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> NIGHT_VISION_GOGGLES = ModItems.register("night_vision_goggles", () -> new NightVisionGogglesItem(ModArmorMaterial.NIGHT_VISION_GOGGLES, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> REINFORCED_NIGHT_VISION_GOGGLES = ModItems.register("reinforced_night_vision_goggles", () -> new NightVisionGogglesItem(ModArmorMaterial.REINFORCED_NIGHT_VISION_GOGGLES, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> FLINT_SWORD = ModItems.register("flint_sword", () -> new FlintSwordItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> FLINT_PICKAXE = ModItems.register("flint_pickaxe", () -> new FlintPickaxeItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> FLINT_SHOVEL = ModItems.register("flint_shovel", () -> new FlintShovelItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> FLINT_AXE = ModItems.register("flint_axe", () -> new FlintAxeItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> FLINT_HOE = ModItems.register("flint_hoe", () -> new FlintHoeItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> FLINT_SHEARS = ModItems.register("flint_shears", () -> new FlintShearsItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> EMERALD_SWORD = ModItems.register("emerald_sword", () -> new EmeraldSwordItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> EMERALD_PICKAXE = ModItems.register("emerald_pickaxe", () -> new EmeraldPickaxeItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> EMERALD_SHOVEL = ModItems.register("emerald_shovel", () -> new EmeraldShovelItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> EMERALD_AXE = ModItems.register("emerald_axe", () -> new EmeraldAxeItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> EMERALD_HOE = ModItems.register("emerald_hoe", () -> new EmeraldHoeItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> FLINT_HELMET = ModItems.register("flint_helmet", () -> new FlintArmorItem(EquipmentSlotType.HEAD, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> FLINT_CHESTPLATE = ModItems.register("flint_chestplate", () -> new FlintArmorItem(EquipmentSlotType.CHEST, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> FLINT_LEGGINGS = ModItems.register("flint_leggings", () -> new FlintArmorItem(EquipmentSlotType.LEGS, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> FLINT_BOOTS = ModItems.register("flint_boots", () -> new FlintArmorItem(EquipmentSlotType.FEET, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> EMERALD_HELMET = ModItems.register("emerald_helmet", () -> new EmeraldArmorItem(EquipmentSlotType.HEAD, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> EMERALD_CHESTPLATE = ModItems.register("emerald_chestplate", () -> new EmeraldArmorItem(EquipmentSlotType.CHEST, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> EMERALD_LEGGINGS = ModItems.register("emerald_leggings", () -> new EmeraldArmorItem(EquipmentSlotType.LEGS, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> EMERALD_BOOTS = ModItems.register("emerald_boots", () -> new EmeraldArmorItem(EquipmentSlotType.FEET, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> WOODEN_PAXEL = ModItems.register("wooden_paxel", () -> new PaxelItem((IItemTier)ItemTier.WOOD, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> STONE_PAXEL = ModItems.register("stone_paxel", () -> new PaxelItem((IItemTier)ItemTier.STONE, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> IRON_PAXEL = ModItems.register("iron_paxel", () -> new PaxelItem((IItemTier)ItemTier.IRON, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> GOLDEN_PAXEL = ModItems.register("golden_paxel", () -> new PaxelItem((IItemTier)ItemTier.GOLD, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> DIAMOND_PAXEL = ModItems.register("diamond_paxel", () -> new PaxelItem((IItemTier)ItemTier.DIAMOND, p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> FLINT_PAXEL = ModItems.register("flint_paxel", () -> new FlintPaxelItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    public static final RegistryObject<Item> EMERALD_PAXEL = ModItems.register("emerald_paxel", () -> new EmeraldPaxelItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        BLOCK_ENTRIES.stream().map(Supplier::get).forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        ENTRIES.forEach((reg, item) -> {
            registry.register((IForgeRegistryEntry)item.get());
            reg.updateReference(registry);
        });
    }

    private static RegistryObject<Item> register(String name) {
        return ModItems.register(name, () -> new BaseItem(p -> p.func_200916_a(PickleTweaks.ITEM_GROUP)));
    }

    private static RegistryObject<Item> register(String name, Supplier<? extends Item> item) {
        ResourceLocation loc = new ResourceLocation("pickletweaks", name);
        RegistryObject reg = RegistryObject.of((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.ITEMS);
        ENTRIES.put((RegistryObject<Item>)reg, () -> (Item)((Item)item.get()).setRegistryName(loc));
        return reg;
    }
}

