/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class ItemNBTHelper {
    public static NBTTagCompound getNBT(ItemStack itemStack) {
        NBTTagCompound compound;
        if (itemStack.func_77942_o()) {
            compound = itemStack.func_77978_p();
        } else {
            compound = new NBTTagCompound();
            itemStack.func_77982_d(compound);
        }
        return compound;
    }

    public static boolean hasKey(ItemStack itemStack, String key) {
        return ItemNBTHelper.getNBT(itemStack).func_74764_b(key);
    }

    public static NBTTagCompound setString(ItemStack itemStack, String key, String value) {
        NBTTagCompound tagCompound = ItemNBTHelper.getNBT(itemStack);
        tagCompound.func_74778_a(key, value);
        return tagCompound;
    }

    public static NBTTagCompound setInt(ItemStack itemStack, String key, int value) {
        NBTTagCompound tagCompound = ItemNBTHelper.getNBT(itemStack);
        tagCompound.func_74768_a(key, value);
        return tagCompound;
    }

    public static NBTTagCompound setDouble(ItemStack itemStack, String key, double value) {
        NBTTagCompound tagCompound = ItemNBTHelper.getNBT(itemStack);
        tagCompound.func_74780_a(key, value);
        return tagCompound;
    }

    public static NBTTagCompound setFloat(ItemStack itemStack, String key, float value) {
        NBTTagCompound tagCompound = ItemNBTHelper.getNBT(itemStack);
        tagCompound.func_74776_a(key, value);
        return tagCompound;
    }

    public static NBTTagCompound setBoolean(ItemStack itemStack, String key, boolean value) {
        NBTTagCompound tagCompound = ItemNBTHelper.getNBT(itemStack);
        tagCompound.func_74757_a(key, value);
        return tagCompound;
    }

    public static NBTTagCompound toggleBoolean(ItemStack itemStack, String key) {
        return ItemNBTHelper.setBoolean(itemStack, key, !ItemNBTHelper.getBoolean(itemStack, key));
    }

    public static NBTTagCompound setVec3d(ItemStack itemStack, String key, Vec3d vec3d) {
        NBTTagCompound tagCompound = ItemNBTHelper.getNBT(itemStack);
        tagCompound.func_74780_a(key + "X", vec3d.field_72450_a);
        tagCompound.func_74780_a(key + "Y", vec3d.field_72448_b);
        tagCompound.func_74780_a(key + "Z", vec3d.field_72449_c);
        return tagCompound;
    }

    public static NBTTagCompound setPosition(ItemStack itemStack, String name, BlockPos position) {
        NBTTagCompound nbtTagCompound = ItemNBTHelper.getNBT(itemStack);
        nbtTagCompound.func_74772_a(name, position.func_177986_g());
        return nbtTagCompound;
    }

    public static String getString(ItemStack itemStack, String key) {
        return ItemNBTHelper.getString(itemStack, key, "");
    }

    public static String getString(ItemStack itemStack, String key, String defaultValue) {
        if (ItemNBTHelper.hasKey(itemStack, key)) {
            return ItemNBTHelper.getNBT(itemStack).func_74779_i(key);
        }
        ItemNBTHelper.getNBT(itemStack).func_74778_a(key, defaultValue);
        return defaultValue;
    }

    public static int getInt(ItemStack itemStack, String key) {
        return ItemNBTHelper.getInt(itemStack, key, 0);
    }

    public static int getInt(ItemStack itemStack, String key, int defaultValue) {
        if (ItemNBTHelper.hasKey(itemStack, key)) {
            return ItemNBTHelper.getNBT(itemStack).func_74762_e(key);
        }
        ItemNBTHelper.getNBT(itemStack).func_74768_a(key, defaultValue);
        return defaultValue;
    }

    public static double getDouble(ItemStack itemStack, String key, double defaultValue) {
        if (ItemNBTHelper.hasKey(itemStack, key)) {
            return ItemNBTHelper.getNBT(itemStack).func_74769_h(key);
        }
        ItemNBTHelper.getNBT(itemStack).func_74780_a(key, defaultValue);
        return defaultValue;
    }

    public static double getDouble(ItemStack itemStack, String key) {
        return ItemNBTHelper.getDouble(itemStack, key, 0.0);
    }

    public static float getFloat(ItemStack itemStack, String key, float defaultValue) {
        if (ItemNBTHelper.hasKey(itemStack, key)) {
            return ItemNBTHelper.getNBT(itemStack).func_74760_g(key);
        }
        ItemNBTHelper.getNBT(itemStack).func_74780_a(key, (double)defaultValue);
        return defaultValue;
    }

    public static float getFloat(ItemStack itemStack, String key) {
        return ItemNBTHelper.getFloat(itemStack, key, 0.0f);
    }

    public static boolean getBoolean(ItemStack itemStack, String key) {
        if (ItemNBTHelper.hasKey(itemStack, key)) {
            return ItemNBTHelper.getNBT(itemStack).func_74767_n(key);
        }
        ItemNBTHelper.getNBT(itemStack).func_74757_a(key, false);
        return false;
    }

    public static BlockPos getPosition(ItemStack itemStack, String key) {
        return BlockPos.func_177969_a((long)ItemNBTHelper.getNBT(itemStack).func_74763_f(key));
    }

    public static Vec3d getVec3d(ItemStack itemStack, String key) {
        NBTTagCompound tagCompound = ItemNBTHelper.getNBT(itemStack);
        return new Vec3d(tagCompound.func_74769_h(key + "X"), tagCompound.func_74769_h(key + "Y"), tagCompound.func_74769_h(key + "Z"));
    }

    public static NBTTagCompound saveItemList(NBTTagCompound tag, List<ItemStack> itemStacks) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < itemStacks.size(); ++i) {
            ItemStack itemStack = itemStacks.get(i);
            if (itemStack.func_190926_b()) continue;
            NBTTagCompound compound = itemStack.func_77955_b(new NBTTagCompound());
            tagList.func_74742_a((NBTBase)compound);
        }
        if (!tagList.func_82582_d()) {
            tag.func_74782_a("Items", (NBTBase)tagList);
        }
        return tag;
    }

    public static void loadItemList(NBTTagCompound tag, List<ItemStack> itemStacks) {
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compound = tagList.func_150305_b(i);
            itemStacks.add(new ItemStack(compound));
        }
    }
}

