/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect;

import alexiy.secure.contain.protect.General;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.Validate;

public class NBTWriter {
    private NBTTagCompound tagCompound;

    public NBTWriter(NBTTagCompound nbtTagCompound) {
        Validate.notNull((Object)nbtTagCompound);
        this.tagCompound = nbtTagCompound;
    }

    public NBTWriter setInteger(String key, int i) {
        this.tagCompound.func_74768_a(key, i);
        return this;
    }

    public NBTWriter setShort(String key, short s) {
        this.tagCompound.func_74777_a(key, s);
        return this;
    }

    public NBTWriter setByte(String key, byte b) {
        this.tagCompound.func_74774_a(key, b);
        return this;
    }

    public NBTWriter setLong(String key, long l) {
        this.tagCompound.func_74772_a(key, l);
        return this;
    }

    public NBTWriter setBoolean(String key, boolean b) {
        this.tagCompound.func_74757_a(key, b);
        return this;
    }

    public NBTWriter setFloat(String key, float f) {
        this.tagCompound.func_74776_a(key, f);
        return this;
    }

    public NBTWriter setDouble(String key, double d) {
        this.tagCompound.func_74780_a(key, d);
        return this;
    }

    public NBTWriter setString(String key, String s) {
        this.tagCompound.func_74778_a(key, s);
        return this;
    }

    public NBTWriter setTagCompound(String key, NBTTagCompound nbtTagCompound) {
        this.tagCompound.func_74782_a(key, (NBTBase)nbtTagCompound);
        return this;
    }

    public NBTWriter setPosition(String key, BlockPos blockPos) {
        this.tagCompound.func_74772_a(key, blockPos.func_177986_g());
        return this;
    }

    public NBTWriter setUUID(String key, UUID uuid) {
        this.tagCompound.func_186854_a(key, uuid);
        return this;
    }

    public NBTTagCompound getResult() {
        return this.tagCompound;
    }

    public NBTWriter setNonnullUUID(String key, UUID uuid) {
        if (!uuid.equals(General.NULL_UUID)) {
            this.tagCompound.func_186854_a(key, uuid);
        }
        return this;
    }

    public static void setNonnullUUID(String key, UUID uuid, NBTTagCompound tagCompound) {
        if (uuid != null && !uuid.equals(General.NULL_UUID)) {
            tagCompound.func_186854_a(key, uuid);
        }
    }

    public static UUID getNonnullUUID(String key, NBTTagCompound compound) {
        UUID uuid = compound.func_186857_a(key);
        if (!uuid.equals(General.NULL_UUID)) {
            return uuid;
        }
        return null;
    }
}

