/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.ai.climbing;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ClimbingPathProcessor
extends NodeProcessor {
    World world;
    boolean field_176180_f;

    public ClimbingPathProcessor(EntityLiving entity_, World world_, boolean canEnterDoors_) {
        this.world = world_;
        this.field_186326_b = entity_;
        this.field_176180_f = canEnterDoors_;
    }

    public PathPoint func_186318_b() {
        int Y;
        if (this.func_186322_e() && this.field_186326_b.func_70090_H()) {
            Y = (int)this.field_186326_b.func_174813_aQ().field_72338_b;
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos((int)this.field_186326_b.field_70165_t, Y, (int)this.field_186326_b.field_70161_v);
            Block block = this.field_176169_a.func_180495_p((BlockPos)mutableBlockPos).func_177230_c();
            while (block == Blocks.field_150358_i || block == Blocks.field_150355_j) {
                mutableBlockPos.func_181079_c((int)this.field_186326_b.field_70165_t, ++Y, (int)this.field_186326_b.field_70161_v);
                block = this.field_176169_a.func_180495_p((BlockPos)mutableBlockPos).func_177230_c();
            }
        } else if (this.field_186326_b.field_70122_E) {
            Y = (int)(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5);
        } else {
            BlockPos blockpos = new BlockPos((Entity)this.field_186326_b);
            while ((this.field_176169_a.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a || this.field_176169_a.func_180495_p(blockpos).func_177230_c().func_176205_b(this.field_176169_a, blockpos)) && blockpos.func_177956_o() > 0) {
                blockpos = blockpos.func_177977_b();
            }
            Y = blockpos.func_177984_a().func_177956_o();
        }
        BlockPos blockpos2 = new BlockPos((Entity)this.field_186326_b);
        this.field_176168_c = (int)MathHelper.func_76131_a((float)this.field_186326_b.field_70130_N, (float)1.0f, (float)this.field_186326_b.field_70130_N);
        this.field_176165_d = (int)MathHelper.func_76131_a((float)this.field_186326_b.field_70131_O, (float)1.0f, (float)this.field_186326_b.field_70131_O);
        this.field_176166_e = (int)MathHelper.func_76131_a((float)this.field_186326_b.field_70130_N, (float)1.0f, (float)this.field_186326_b.field_70130_N);
        PathNodeType pathnodetype1 = this.func_186330_a((IBlockAccess)this.world, blockpos2.func_177958_n(), Y, blockpos2.func_177952_p());
        if (this.field_186326_b.func_184643_a(pathnodetype1) < 0.0f) {
            HashSet set = Sets.newHashSet();
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)Y, this.field_186326_b.func_174813_aQ().field_72339_c));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)Y, this.field_186326_b.func_174813_aQ().field_72334_f));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)Y, this.field_186326_b.func_174813_aQ().field_72339_c));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)Y, this.field_186326_b.func_174813_aQ().field_72334_f));
            for (BlockPos blockpos1 : set) {
                PathNodeType pathnodetype = this.func_186319_a((IBlockAccess)this.world, blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p(), this.field_186326_b, this.field_176168_c, this.field_176165_d, this.field_176166_e, false, this.field_176180_f);
                if (!(this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f)) continue;
                return this.func_176159_a(blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p());
            }
        }
        return this.func_176159_a(blockpos2.func_177958_n(), blockpos2.func_177956_o(), blockpos2.func_177952_p());
    }

    public PathPoint func_186325_a(double x, double y, double z) {
        BlockPos target = new BlockPos(x, y, z);
        IBlockState blockState = this.world.func_180495_p(target);
        PathPoint sp = this.func_176159_a((int)x, (int)y, (int)z);
        return sp;
    }

    public int func_186320_a(PathPoint[] pathOptions, PathPoint currentPoint, PathPoint targetPoint, float maxDistance) {
        PathPoint pathpoint7;
        PathPoint pathpoint6;
        PathPoint pathpoint5;
        PathPoint pathpoint4;
        boolean flag3;
        int pathpointIndex = 0;
        int j = 0;
        PathNodeType pathnodetype = this.func_186330_a((IBlockAccess)this.world, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c);
        if (this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f) {
            j = MathHelper.func_76141_d((float)Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        BlockPos blockpos = new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c).func_177977_b();
        double d0 = (double)currentPoint.field_75837_b - (1.0 - this.field_176169_a.func_180495_p((BlockPos)blockpos).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)blockpos).field_72337_e);
        PathPoint pathpoint = this.getSafePoint(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH);
        PathPoint pathpoint1 = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, j, d0, EnumFacing.WEST);
        PathPoint pathpoint2 = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, j, d0, EnumFacing.EAST);
        PathPoint pathpoint3 = this.getSafePoint(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH);
        if (pathpoint != null && !pathpoint.field_75842_i && pathpoint.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[pathpointIndex++] = pathpoint;
        }
        if (pathpoint1 != null && !pathpoint1.field_75842_i && pathpoint1.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[pathpointIndex++] = pathpoint1;
        }
        if (pathpoint2 != null && !pathpoint2.field_75842_i && pathpoint2.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[pathpointIndex++] = pathpoint2;
        }
        if (pathpoint3 != null && !pathpoint3.field_75842_i && pathpoint3.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[pathpointIndex++] = pathpoint3;
        }
        boolean flag = pathpoint3 == null || pathpoint3.field_186287_m == PathNodeType.OPEN || pathpoint3.field_186286_l != 0.0f;
        boolean flag1 = pathpoint == null || pathpoint.field_186287_m == PathNodeType.OPEN || pathpoint.field_186286_l != 0.0f;
        boolean flag2 = pathpoint2 == null || pathpoint2.field_186287_m == PathNodeType.OPEN || pathpoint2.field_186286_l != 0.0f;
        boolean bl = flag3 = pathpoint1 == null || pathpoint1.field_186287_m == PathNodeType.OPEN || pathpoint1.field_186286_l != 0.0f;
        if (flag && flag3 && (pathpoint4 = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH)) != null && !pathpoint4.field_75842_i && pathpoint4.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[pathpointIndex++] = pathpoint4;
        }
        if (flag && flag2 && (pathpoint5 = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH)) != null && !pathpoint5.field_75842_i && pathpoint5.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[pathpointIndex++] = pathpoint5;
        }
        if (flag1 && flag3 && (pathpoint6 = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH)) != null && !pathpoint6.field_75842_i && pathpoint6.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[pathpointIndex++] = pathpoint6;
        }
        if (flag1 && flag2 && (pathpoint7 = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH)) != null && !pathpoint7.field_75842_i && pathpoint7.func_75829_a(targetPoint) < maxDistance) {
            pathOptions[pathpointIndex++] = pathpoint7;
        }
        return pathpointIndex;
    }

    @Nullable
    private PathPoint getSafePoint(int x, int y, int z, int i1, double v, EnumFacing facing) {
        PathPoint pathpoint = null;
        BlockPos blockpos = new BlockPos(x, y, z);
        BlockPos blockpos1 = blockpos.func_177977_b();
        double d0 = (double)y - (1.0 - this.field_176169_a.func_180495_p((BlockPos)blockpos1).func_185900_c((IBlockAccess)this.field_176169_a, (BlockPos)blockpos1).field_72337_e);
        if (d0 - v > 1.125) {
            return null;
        }
        PathNodeType pathnodetype = this.func_186330_a((IBlockAccess)this.world, x, y, z);
        float f = this.field_186326_b.func_184643_a(pathnodetype);
        double d1 = (double)this.field_186326_b.field_70130_N / 2.0;
        if (f >= 0.0f) {
            pathpoint = this.func_176159_a(x, y, z);
            pathpoint.field_186287_m = pathnodetype;
            pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
        }
        if (pathnodetype == PathNodeType.WALKABLE) {
            return pathpoint;
        }
        if (pathpoint == null && i1 > 0 && pathnodetype != PathNodeType.FENCE && pathnodetype != PathNodeType.TRAPDOOR && (pathpoint = this.getSafePoint(x, y + 1, z, i1 - 1, v, facing)) != null && (pathpoint.field_186287_m == PathNodeType.OPEN || pathpoint.field_186287_m == PathNodeType.WALKABLE) && this.field_186326_b.field_70130_N < 1.0f) {
            double d2 = (double)(x - facing.func_82601_c()) + 0.5;
            double d3 = (double)(z - facing.func_82599_e()) + 0.5;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(d2 - d1, (double)y + 0.001, d3 - d1, d2 + d1, (double)((float)y + this.field_186326_b.field_70131_O), d3 + d1);
            AxisAlignedBB axisalignedbb1 = this.field_176169_a.func_180495_p(blockpos).func_185900_c(this.field_176169_a, blockpos);
            AxisAlignedBB axisalignedbb2 = axisalignedbb.func_72321_a(0.0, axisalignedbb1.field_72337_e - 0.002, 0.0);
            if (this.field_186326_b.field_70170_p.func_184143_b(axisalignedbb2)) {
                pathpoint = null;
            }
        }
        if (pathnodetype == PathNodeType.OPEN) {
            PathNodeType pathnodetype1;
            AxisAlignedBB axisalignedbb3 = new AxisAlignedBB((double)x - d1 + 0.5, (double)y + 0.001, (double)z - d1 + 0.5, (double)x + d1 + 0.5, (double)((float)y + this.field_186326_b.field_70131_O), (double)z + d1 + 0.5);
            if (this.field_186326_b.field_70170_p.func_184143_b(axisalignedbb3)) {
                return null;
            }
            if (this.field_186326_b.field_70130_N >= 1.0f && (pathnodetype1 = this.func_186330_a((IBlockAccess)this.world, x, y - 1, z)) == PathNodeType.BLOCKED) {
                pathpoint = this.func_176159_a(x, y, z);
                pathpoint.field_186287_m = PathNodeType.WALKABLE;
                pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
                return pathpoint;
            }
            int i = 0;
            while (y > 0) {
                --y;
                if (i++ >= this.field_186326_b.func_82143_as()) {
                    return null;
                }
                pathnodetype = this.func_186330_a((IBlockAccess)this.world, x, y, z);
                f = this.field_186326_b.func_184643_a(pathnodetype);
                if (pathnodetype != PathNodeType.OPEN && f >= 0.0f) {
                    pathpoint = this.func_176159_a(x, y, z);
                    pathpoint.field_186287_m = pathnodetype;
                    pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
                    break;
                }
                if (!(f < 0.0f)) continue;
                return null;
            }
        }
        return pathpoint;
    }

    public PathNodeType func_186319_a(IBlockAccess blockaccessIn, int x, int y, int z, EntityLiving entitylivingIn, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        EnumSet<PathNodeType> enumset = EnumSet.noneOf(PathNodeType.class);
        PathNodeType pathnodetype = PathNodeType.BLOCKED;
        double d0 = (double)entitylivingIn.field_70130_N / 2.0;
        BlockPos blockpos = new BlockPos((Entity)entitylivingIn);
        pathnodetype = this.getPathNodeType(blockaccessIn, x, y, z, xSize, ySize, zSize, canBreakDoorsIn, canEnterDoorsIn, enumset, pathnodetype, blockpos);
        if (enumset.contains(PathNodeType.FENCE)) {
            return PathNodeType.FENCE;
        }
        PathNodeType pathnodetype1 = PathNodeType.BLOCKED;
        for (PathNodeType pathnodetype2 : enumset) {
            if (entitylivingIn.func_184643_a(pathnodetype2) < 0.0f) {
                return pathnodetype2;
            }
            if (!(entitylivingIn.func_184643_a(pathnodetype2) >= entitylivingIn.func_184643_a(pathnodetype1))) continue;
            pathnodetype1 = pathnodetype2;
        }
        if (pathnodetype == PathNodeType.OPEN && entitylivingIn.func_184643_a(pathnodetype1) == 0.0f) {
            return PathNodeType.OPEN;
        }
        return pathnodetype1;
    }

    protected PathNodeType getPathNodeType(IBlockAccess world, int x, int y, int z, int xSize, int ySize, int zSize, boolean canOpenDoorsIn, boolean canEnterDoorsIn, EnumSet<PathNodeType> pathNodeTypes, PathNodeType nodeType, BlockPos pos) {
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int l = i + x;
                    int i1 = j + y;
                    int j1 = k + z;
                    PathNodeType pathnodetype = this.func_186330_a(world, l, i1, j1);
                    if (pathnodetype == PathNodeType.DOOR_WOOD_CLOSED && canOpenDoorsIn && canEnterDoorsIn) {
                        pathnodetype = PathNodeType.WALKABLE;
                    }
                    if (pathnodetype == PathNodeType.DOOR_OPEN && !canEnterDoorsIn) {
                        pathnodetype = PathNodeType.BLOCKED;
                    }
                    if (pathnodetype == PathNodeType.RAIL && !(world.func_180495_p(pos).func_177230_c() instanceof BlockRailBase) && !(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockRailBase)) {
                        pathnodetype = PathNodeType.FENCE;
                    }
                    if (i == 0 && j == 0 && k == 0) {
                        nodeType = pathnodetype;
                    }
                    pathNodeTypes.add(pathnodetype);
                }
            }
        }
        return nodeType;
    }

    public PathNodeType func_186330_a(IBlockAccess blockaccessIn, int x, int y, int z) {
        PathNodeType pathNodeType1 = this.getPathNodeTypeRaw(blockaccessIn, x, y, z);
        if (pathNodeType1 == PathNodeType.OPEN && y >= 1) {
            Block block = blockaccessIn.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c();
            PathNodeType pathnodetype1 = this.getPathNodeTypeRaw(blockaccessIn, x, y - 1, z);
            PathNodeType pathNodeType = pathNodeType1 = pathnodetype1 != PathNodeType.WALKABLE && pathnodetype1 != PathNodeType.OPEN && pathnodetype1 != PathNodeType.WATER && pathnodetype1 != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
            if (pathnodetype1 == PathNodeType.DAMAGE_FIRE || block == Blocks.field_189877_df) {
                pathNodeType1 = PathNodeType.DAMAGE_FIRE;
            }
            if (pathnodetype1 == PathNodeType.DAMAGE_CACTUS) {
                pathNodeType1 = PathNodeType.DAMAGE_CACTUS;
            }
        }
        pathNodeType1 = this.checkNeighborBlocks(blockaccessIn, x, y, z, pathNodeType1);
        return pathNodeType1;
    }

    protected PathNodeType getPathNodeTypeRaw(IBlockAccess world, int x, int y, int z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        IBlockState iblockstate = world.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        Material material = iblockstate.func_185904_a();
        PathNodeType type = block.getAiPathNodeType(iblockstate, world, blockpos);
        if (type != null) {
            return type;
        }
        if (material == Material.field_151579_a) {
            return PathNodeType.OPEN;
        }
        if (block != Blocks.field_150415_aT && block != Blocks.field_180400_cw && block != Blocks.field_150392_bi) {
            if (block == Blocks.field_150480_ab) {
                return PathNodeType.DAMAGE_FIRE;
            }
            if (block == Blocks.field_150434_aF) {
                return PathNodeType.DAMAGE_CACTUS;
            }
            if (block instanceof BlockDoor && material == Material.field_151575_d && !((Boolean)iblockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_WOOD_CLOSED;
            }
            if (block instanceof BlockDoor && material == Material.field_151573_f && !((Boolean)iblockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_IRON_CLOSED;
            }
            if (block instanceof BlockDoor && ((Boolean)iblockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_OPEN;
            }
            if (block instanceof BlockRailBase) {
                return PathNodeType.RAIL;
            }
            if (!(block instanceof BlockFence || block instanceof BlockWall || block instanceof BlockFenceGate && !((Boolean)iblockstate.func_177229_b((IProperty)BlockFenceGate.field_176466_a)).booleanValue())) {
                if (material == Material.field_151586_h) {
                    return PathNodeType.WATER;
                }
                if (material == Material.field_151587_i) {
                    return PathNodeType.LAVA;
                }
                return block.func_176205_b(world, blockpos) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
            }
            return PathNodeType.FENCE;
        }
        return PathNodeType.TRAPDOOR;
    }

    protected PathNodeType checkNeighborBlocks(IBlockAccess blockAccess, int x, int y, int z, PathNodeType nodeType) {
        BlockPos.PooledMutableBlockPos pooledMutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        if (nodeType == PathNodeType.WALKABLE) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    if (i == 0 && j == 0) continue;
                    Block block = blockAccess.func_180495_p((BlockPos)pooledMutableBlockPos.func_181079_c(i + x, y, j + z)).func_177230_c();
                    if (block == Blocks.field_150434_aF) {
                        nodeType = PathNodeType.DANGER_CACTUS;
                        continue;
                    }
                    if (block == Blocks.field_150480_ab) {
                        nodeType = PathNodeType.DANGER_FIRE;
                        continue;
                    }
                    if (!block.isBurning(blockAccess, (BlockPos)pooledMutableBlockPos)) continue;
                    nodeType = PathNodeType.DAMAGE_FIRE;
                }
            }
        }
        pooledMutableBlockPos.func_185344_t();
        return nodeType;
    }
}

