/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.api;

import alexiy.secure.contain.protect.InternalAPI;
import alexiy.secure.contain.protect.api.ItemLootGenerationEvent;
import alexiy.secure.contain.protect.api.Loot;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public interface LootContainer {
    default public boolean canGenerate(ResourceLocation context) {
        return true;
    }

    public static <LC extends Class<? extends LootContainer>> void registerLoot(LC lootContainer, Loot lootPool) {
        InternalAPI.lootPools.put(lootContainer, (Object)lootPool);
    }

    public static <LC extends Class<? extends LootContainer>> void registerLoot(LC lootContainer, Loot ... lootPools) {
        for (Loot lootPool : lootPools) {
            LootContainer.registerLoot(lootContainer, lootPool);
        }
    }

    public static <IHT extends Class<? extends TileEntity>> void registerLoot2(IHT itemHandlerTile, Loot ... lootPools) {
        for (Loot lootPool : lootPools) {
            InternalAPI.otherPools.put(itemHandlerTile, (Object)lootPool);
        }
    }

    public static int generateRandomItems(TileEntity tileEntity, ResourceLocation context) {
        int itemGenerated;
        block4: {
            List poolList;
            block3: {
                List lootPoolSet;
                itemGenerated = 0;
                if (!(tileEntity instanceof LootContainer)) break block3;
                LootContainer lootContainer = (LootContainer)tileEntity;
                if (!lootContainer.canGenerate(context) || (lootPoolSet = InternalAPI.lootPools.get(lootContainer.getClass())) == null) break block4;
                Collections.shuffle(lootPoolSet);
                for (Loot lootPool : lootPoolSet) {
                    IItemHandler itemHandler;
                    ItemStack result = lootPool.roll(context, tileEntity);
                    if (result == null || !tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) || ItemHandlerHelper.insertItem((IItemHandler)(itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)), (ItemStack)result, (boolean)false).func_190916_E() >= result.func_190916_E()) continue;
                    ++itemGenerated;
                }
                break block4;
            }
            if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && !MinecraftForge.EVENT_BUS.post((Event)new ItemLootGenerationEvent(tileEntity, context)) && (poolList = InternalAPI.otherPools.get(tileEntity.getClass())) != null) {
                Collections.shuffle(poolList);
                IItemHandler itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                for (Loot lootPool : poolList) {
                    ItemStack res = lootPool.roll(context, tileEntity);
                    if (res == null || ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)res, (boolean)false).func_190916_E() >= res.func_190916_E()) continue;
                    ++itemGenerated;
                }
            }
        }
        return itemGenerated;
    }
}

