/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.api;

import alexiy.secure.contain.protect.api.MainAPI;
import alexiy.secure.contain.protect.api.ObjectClass;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SCPEntry
extends IForgeRegistryEntry.Impl<SCPEntry> {
    private String number;
    private String name;
    private ObjectClass objectClass;
    private ResourceLocation structureLocation;
    private Rotation rotation;
    private Object alternative;

    private SCPEntry() {
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public ObjectClass getObjectClass() {
        return this.objectClass;
    }

    public ResourceLocation getStructureLocation() {
        return this.structureLocation;
    }

    public Object getAlternative() {
        return this.alternative;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public static final class Builder {
        private final ModContainer mod = Loader.instance().activeModContainer();
        private String number;
        private String name;
        private ObjectClass objectClass;
        private ResourceLocation structureLocation;
        private Rotation rotation;
        private Object alternative;

        public final Builder info(String number, String name, ObjectClass objectClass) {
            this.number = (String)Preconditions.checkNotNull((Object)number, (Object)"item number is null");
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"SCP name is null");
            this.objectClass = (ObjectClass)((Object)Preconditions.checkNotNull((Object)((Object)objectClass), (Object)"SCP object class is null"));
            return this;
        }

        public final Builder alternative(Object object) {
            if (!(object instanceof WorldGenerator || object instanceof Class || object instanceof Item || object instanceof Block)) {
                throw new IllegalArgumentException("The object must be an instance of " + WorldGenerator.class.getSimpleName() + " or " + Item.class.getSimpleName() + " or " + Block.class.getSimpleName() + ", or an Entity class");
            }
            this.alternative = object;
            return this;
        }

        public final Builder structure(ResourceLocation structureLocation, @Nullable Rotation rotation) {
            if (structureLocation == null) {
                MainAPI.apiLogger.warn("Structure not provided for SCP-" + this.number);
            }
            this.structureLocation = structureLocation;
            this.rotation = rotation == null ? Rotation.NONE : rotation;
            return this;
        }

        public final Builder defaultStructure(String path, @Nullable Rotation rotation) {
            if (!Loader.instance().activeModContainer().getModId().equals("scp")) {
                throw new IllegalArgumentException("Structure registration to \"scp\" domain is forbidden for other mods");
            }
            return this.structure(new ResourceLocation("scp", path), rotation);
        }

        public final SCPEntry build() {
            Preconditions.checkState((this.number != null ? 1 : 0) != 0, (Object)"item number not provided");
            Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"scp name not provided");
            Preconditions.checkState((this.objectClass != null ? 1 : 0) != 0, (Object)"object class not provided");
            Preconditions.checkState((this.structureLocation != null || this.alternative != null ? 1 : 0) != 0, (Object)"A structure or an alternative object must be provided");
            if (this.structureLocation != null && this.rotation == null) {
                throw new IllegalArgumentException("Structure rotation was not provided");
            }
            SCPEntry entry = new SCPEntry();
            entry.number = this.number;
            entry.name = this.name;
            entry.objectClass = this.objectClass;
            entry.structureLocation = this.structureLocation;
            entry.rotation = this.rotation;
            entry.alternative = this.alternative;
            entry.setRegistryName(new ResourceLocation(this.mod.getModId(), this.name));
            return entry;
        }
    }
}

