/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.blocks.livingroom;

import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.blocks.BlockHorizontalNonSolid;
import alexiy.secure.contain.protect.blocks.BlockLivingRoom;
import alexiy.secure.contain.protect.blocks.livingroom.ILivingRoomFurniture;
import alexiy.secure.contain.protect.entity.furniture.EntityInvisibleChair;
import alexiy.secure.contain.protect.registration.SCPBlocks;
import alexiy.secure.contain.protect.registration.SCPItems;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockArmChair
extends BlockHorizontalNonSolid
implements ILivingRoomFurniture {
    public static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");
    private static final AxisAlignedBB WEST_BOUNDING_BOX = new AxisAlignedBB(0.67, 0.0, 0.05, 1.0, 0.2, 0.95);
    private static final AxisAlignedBB EAST_BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.05, 0.33, 0.2, 0.95);
    private static final AxisAlignedBB NORTH_BOUNDING_BOX = new AxisAlignedBB(0.05, 0.0, 0.67, 0.95, 0.2, 1.0);
    private static final AxisAlignedBB SOUTH_BOUNDING_BOX = new AxisAlignedBB(0.05, 0.0, 0.0, 0.95, 0.2, 0.33);

    public BlockArmChair() {
        this.func_149672_a(SoundType.field_185859_l);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.WEST));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TOP, field_185512_D});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            meta |= 4;
        }
        return meta |= 5 - ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176745_a();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf((meta & 4) > 0));
        state = state.func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_82600_a((int)(5 - (meta & 3))));
        return state;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            switch ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)) {
                case WEST: {
                    return WEST_BOUNDING_BOX;
                }
                case EAST: {
                    return EAST_BOUNDING_BOX;
                }
                case NORTH: {
                    return NORTH_BOUNDING_BOX;
                }
                case SOUTH: {
                    return SOUTH_BOUNDING_BOX;
                }
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && super.func_176196_c(worldIn, pos.func_177984_a());
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return (Boolean)state.func_177229_b((IProperty)TOP) != false ? Items.field_190931_a : super.func_180660_a(state, rand, fortune);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos topPos = pos.func_177984_a();
        BlockPos botPos = pos.func_177977_b();
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue() && worldIn.func_180495_p(botPos).func_177230_c() == this) {
            worldIn.func_175698_g(botPos);
        }
        if (!((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue() && worldIn.func_180495_p(topPos).func_177230_c() == this) {
            if (player.func_184812_l_()) {
                worldIn.func_175698_g(pos);
            }
            worldIn.func_175698_g(topPos);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            BlockPos botPos = pos.func_177977_b();
            IBlockState bottomState = worldIn.func_180495_p(botPos);
            if (bottomState.func_177230_c() != this) {
                worldIn.func_175698_g(botPos);
            } else if (blockIn != this) {
                bottomState.func_189546_a(worldIn, botPos, blockIn, fromPos);
            }
        } else {
            boolean dropItem = false;
            BlockPos topPos = pos.func_177984_a();
            IBlockState topState = worldIn.func_180495_p(topPos);
            if (topState.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
                dropItem = true;
            }
            if (dropItem && !worldIn.field_72995_K) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            EntityInvisibleChair chair = new EntityInvisibleChair(worldIn);
            chair.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() - ((Boolean)state.func_177229_b((IProperty)TOP) != false ? 2 : 1), (double)pos.func_177952_p() + 0.5);
            worldIn.func_72838_d((Entity)chair);
            playerIn.func_184220_m((Entity)chair);
            return true;
        }
        return false;
    }

    @Override
    public boolean placeBlock(BlockPos sourcePos, World world, Random random) {
        BlockPos placePos = Utils.findAir(sourcePos, true, world);
        if (this.func_176196_c(world, placePos)) {
            EnumFacing placeFacing = null;
            if (world.func_180495_p(placePos.func_177977_b()).func_177230_c() instanceof BlockLivingRoom && this.func_176196_c(world, placePos)) {
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    if (world.func_180495_p(placePos.func_177972_a(facing)).func_177230_c() != SCPBlocks.livingRoomCoffeeTable) continue;
                    placeFacing = facing;
                    break;
                }
                if (placeFacing == null) {
                    placeFacing = EnumFacing.field_176754_o[random.nextInt(EnumFacing.field_176754_o.length)];
                }
                world.func_175656_a(placePos, this.func_176223_P().func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_185512_D, (Comparable)placeFacing));
                world.func_175656_a(placePos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_185512_D, (Comparable)placeFacing));
                return true;
            }
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(SCPItems.livingRoomArmChair);
    }
}

