/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.capability.synchronization;

import alexiy.secure.contain.protect.capability.Capabilities;
import alexiy.secure.contain.protect.capability.synchronization.PerformSync;
import alexiy.secure.contain.protect.capability.synchronization.Synchronizable;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class RequestSync
implements IMessage {
    private ResourceLocation capabilityName;
    private Collection<Integer> entitiesToSync;

    public RequestSync() {
    }

    public RequestSync(ResourceLocation target, Collection<Integer> entityIds_) {
        this.capabilityName = target;
        this.entitiesToSync = entityIds_;
    }

    public void fromBytes(ByteBuf buf) {
        this.capabilityName = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.entitiesToSync = new HashSet<Integer>();
        while (buf.isReadable()) {
            this.entitiesToSync.add(buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.capabilityName.toString());
        this.entitiesToSync.forEach(arg_0 -> ((ByteBuf)buf).writeInt(arg_0));
    }

    public static class Handler
    implements IMessageHandler<RequestSync, PerformSync> {
        public PerformSync onMessage(RequestSync message, MessageContext ctx) {
            WorldServer worldServer = ctx.getServerHandler().field_147369_b.func_71121_q();
            Collection ids = message.entitiesToSync;
            Capability<?> capability = Capabilities.capabilityHashMap.get(message.capabilityName);
            assert (capability != null);
            HashSet<Integer> returnedIds = new HashSet<Integer>(ids.size());
            ids.forEach(integer -> {
                Synchronizable synchronizable;
                Object instance;
                Entity entity = worldServer.func_73045_a(integer.intValue());
                if (entity != null && entity.hasCapability(capability, null) && (instance = entity.getCapability(capability, null)) instanceof Synchronizable && (synchronizable = (Synchronizable)instance).needsSynchronization(entity)) {
                    returnedIds.add((Integer)integer);
                }
            });
            if (!returnedIds.isEmpty()) {
                return new PerformSync(message.capabilityName, returnedIds);
            }
            return null;
        }
    }
}

