/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.capability.synchronization;

import alexiy.secure.contain.protect.capability.Capabilities;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SynchronizeToClient
implements IMessage {
    private int entityId;
    private ResourceLocation capabilityName;
    private EnumFacing side;
    private NBTTagCompound data;

    public SynchronizeToClient() {
    }

    public SynchronizeToClient(ResourceLocation resourceLocation, Entity entity, EnumFacing side) {
        Capability<?> capability = Capabilities.capabilityHashMap.get(resourceLocation);
        this.capabilityName = resourceLocation;
        if (entity.hasCapability(capability, side)) {
            this.side = side;
            this.entityId = entity.func_145782_y();
            Object capinstance = entity.getCapability(capability, side);
            this.data = (NBTTagCompound)capability.writeNBT(capinstance, side);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.capabilityName = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
        if (buf.isReadable()) {
            this.side = EnumFacing.values()[buf.readByte()];
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.capabilityName.toString());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
        if (this.side != null) {
            buf.writeByte(this.side.ordinal());
        }
    }

    public static class Handler
    implements IMessageHandler<SynchronizeToClient, IMessage> {
        public IMessage onMessage(final SynchronizeToClient message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Capability<?> capability;
                    WorldClient worldClient = Minecraft.func_71410_x().field_71441_e;
                    Entity entity = worldClient.func_73045_a(message.entityId);
                    if (entity != null && entity.hasCapability(capability = Capabilities.capabilityHashMap.get(message.capabilityName), message.side)) {
                        Object capInstance = entity.getCapability(capability, message.side);
                        capability.readNBT(capInstance, message.side, (NBTBase)message.data);
                    }
                }
            });
            return null;
        }
    }
}

