/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.entity;

import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.ai.AIAquaWander;
import alexiy.secure.contain.protect.ai.AIBase;
import alexiy.secure.contain.protect.ai.AIHurtByTarget;
import alexiy.secure.contain.protect.ai.AIMeleeAttack;
import alexiy.secure.contain.protect.ai.swimming.SwimmingHelper;
import alexiy.secure.contain.protect.damagesource.DirectHealthDamage;
import alexiy.secure.contain.protect.entity.SCPCreature;
import alexiy.secure.contain.protect.packets.PlaySound;
import alexiy.secure.contain.protect.registration.Sounds;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.SwimNodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Entity4307
extends SCPCreature {
    private SwimmingHelper swimmingHelper;
    private EntityMoveHelper landHelper;
    private PathNavigateGround groundNavigator;
    private PathNavigateSwimmer swimNavigator;
    private static final DamageSource DAMAGE_SOURCE = new DirectHealthDamage("heat");
    private AIMeleeAttack meleeAttack;

    public Entity4307(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.9f, 1.2f);
        this.swimmingHelper = new SwimmingHelper((EntityLiving)this);
        this.landHelper = new EntityMoveHelper((EntityLiving)this);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SWIM_SPEED).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(90.0);
    }

    @Override
    protected void func_184651_r() {
        this.swimming = new EntityAISwimming((EntityLiving)this){

            public boolean func_75250_a() {
                return Entity4307.this.field_70765_h == Entity4307.this.landHelper && super.func_75250_a();
            }

            public void func_75246_d() {
                super.func_75246_d();
            }
        };
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.swimming);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIAquaWander(this, 1.0, 40){

            public boolean func_75250_a() {
                return Entity4307.this.field_70765_h == Entity4307.this.swimmingHelper && super.func_75250_a();
            }
        });
        this.wandering = new EntityAIWander(this, 1.0, 20){

            public boolean func_75250_a() {
                return Entity4307.this.field_70765_h == Entity4307.this.landHelper && super.func_75250_a();
            }
        };
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.wandering);
        this.meleeAttack = new AIMeleeAttack(this, 1.0, true){

            public boolean func_75250_a() {
                return super.func_75250_a() && Entity4307.this.func_70068_e((Entity)Entity4307.this.func_70638_az()) <= this.func_179512_a(Entity4307.this.func_70638_az());
            }

            public boolean func_75253_b() {
                return super.func_75253_b() && Entity4307.this.func_70068_e((Entity)Entity4307.this.func_70638_az()) <= this.func_179512_a(Entity4307.this.func_70638_az());
            }

            @Override
            protected void func_190102_a(@Nonnull EntityLivingBase target, double distance) {
                super.func_190102_a(target, distance);
            }
        };
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.meleeAttack);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new BeamAttack());
        this.defense = new AIHurtByTarget((EntityCreature)this, false, new Class[0]);
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)this.defense);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean s = super.func_70652_k(entityIn);
        SCP.SimpleNetworkWrapper.sendToAllTracking((IMessage)new PlaySound(this.func_180425_c(), Sounds.scp4307attacking), (Entity)this);
        return s;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        this.groundNavigator = new PathNavigateGround((EntityLiving)this, worldIn);
        this.groundNavigator.func_179693_d(true);
        this.swimNavigator = new WaterNavigator((EntityLiving)this, worldIn);
        return super.func_175447_b(worldIn);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public void func_70636_d() {
        boolean isGroundTarget;
        EntityLivingBase target = this.func_70638_az();
        boolean nonNull = target != null;
        boolean bl = isGroundTarget = nonNull && !target.func_70090_H() && !target.func_180799_ab();
        if (this.func_70090_H() || this.func_180799_ab()) {
            if (isGroundTarget) {
                if (!this.func_70685_l((Entity)target) || this.func_70661_as().func_75500_f()) {
                    this.field_70765_h = this.landHelper;
                    this.field_70699_by = this.groundNavigator;
                }
            } else {
                this.field_70765_h = this.swimmingHelper;
                this.field_70699_by = this.swimNavigator;
            }
            this.field_70181_x += 0.02;
        } else {
            this.field_70765_h = this.landHelper;
            this.field_70699_by = this.groundNavigator;
        }
        if (this.field_70123_F && this.func_70090_H() && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f, this.field_70179_y)) {
            this.field_70765_h = this.landHelper;
            this.field_70699_by = this.groundNavigator;
            this.field_70699_by.func_75484_a(this.swimNavigator.func_75505_d(), 1.0);
        }
        super.func_70636_d();
        double followrange = this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        List<BlockPos> blockPosList = Utils.boundingBoxToPositions(this.func_174813_aQ().func_186662_g(followrange / 2.0));
        BlockPos randompos = blockPosList.get(this.func_70681_au().nextInt(blockPosList.size()));
        while (this.field_70170_p.func_175623_d(randompos) && (randompos = randompos.func_177977_b()).func_177956_o() >= 4 && !((double)(this.func_180425_c().func_177956_o() - randompos.func_177956_o()) > followrange / 2.0)) {
        }
        if (!this.field_70170_p.func_175623_d(randompos)) {
            IBlockState blockState = this.field_70170_p.func_180495_p(randompos);
            for (Map.Entry iPropertyComparableEntry : blockState.func_177228_b().entrySet()) {
                Boolean bv;
                IProperty property = (IProperty)iPropertyComparableEntry.getKey();
                Comparable value = (Comparable)iPropertyComparableEntry.getValue();
                if (!property.func_177701_a().equals("powered") || !(value instanceof Boolean) || !(bv = (Boolean)value).booleanValue()) continue;
                this.field_70170_p.func_175656_a(randompos, blockState.func_177226_a(property, (Comparable)Boolean.valueOf(false)));
                blockState.func_177230_c().func_180650_b(this.field_70170_p, randompos, blockState, this.field_70170_p.field_73012_v);
                break;
            }
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return Sounds.scp4307hurt;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return Sounds.scp4307dead;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return Sounds.scp4307idle;
    }

    class WaterNodeProcessor
    extends SwimNodeProcessor {
        WaterNodeProcessor() {
        }

        public int func_186320_a(PathPoint[] pathOptions, PathPoint currentPoint, PathPoint targetPoint, float maxDistance) {
            int i = 0;
            for (EnumFacing enumfacing : EnumFacing.values()) {
                PathPoint pathpoint = this.getWaterNode(currentPoint.field_75839_a + enumfacing.func_82601_c(), currentPoint.field_75837_b + enumfacing.func_96559_d(), currentPoint.field_75838_c + enumfacing.func_82599_e());
                if (pathpoint == null || pathpoint.field_75842_i || !(pathpoint.func_75829_a(targetPoint) < maxDistance)) continue;
                pathOptions[i++] = pathpoint;
            }
            return i;
        }

        @Nullable
        private PathPoint getWaterNode(int p_186328_1_, int p_186328_2_, int p_186328_3_) {
            PathNodeType pathnodetype = this.isFree(p_186328_1_, p_186328_2_, p_186328_3_);
            return pathnodetype == PathNodeType.WATER ? this.func_176159_a(p_186328_1_, p_186328_2_, p_186328_3_) : null;
        }

        private PathNodeType isFree(int p_186327_1_, int p_186327_2_, int p_186327_3_) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int i = p_186327_1_; i < p_186327_1_ + this.field_176168_c; ++i) {
                for (int j = p_186327_2_; j < p_186327_2_ + this.field_176165_d; ++j) {
                    for (int k = p_186327_3_; k < p_186327_3_ + this.field_176166_e; ++k) {
                        IBlockState iblockstate = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(i, j, k));
                        if (iblockstate == Blocks.field_150350_a.func_176223_P() && !Entity4307.this.field_70170_p.func_175623_d(blockpos$mutableblockpos.func_177977_b())) {
                            return PathNodeType.WATER;
                        }
                        if (iblockstate.func_185904_a() == Material.field_151586_h) continue;
                        return PathNodeType.BLOCKED;
                    }
                }
            }
            return PathNodeType.WATER;
        }
    }

    class WaterNavigator
    extends PathNavigateSwimmer {
        public WaterNavigator(EntityLiving entitylivingIn, World worldIn) {
            super(entitylivingIn, worldIn);
        }

        protected PathFinder func_179679_a() {
            return new PathFinder((NodeProcessor)new WaterNodeProcessor());
        }

        public boolean func_188555_b(BlockPos pos) {
            return true;
        }

        protected void func_192876_m() {
        }
    }

    class BeamAttack
    extends AIBase {
        BeamAttack() {
        }

        public boolean func_75250_a() {
            EntityLivingBase target = Entity4307.this.func_70638_az();
            return target != null && target.func_70089_S() && Entity4307.this.func_70068_e((Entity)target) > Entity4307.this.meleeAttack.func_179512_a(target) && Entity4307.this.func_70685_l((Entity)target);
        }

        public void func_75249_e() {
            Entity4307.this.func_70661_as().func_75499_g();
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            EntityLivingBase attackTarget = Entity4307.this.func_70638_az();
            if (attackTarget != null) {
                Entity4307.this.func_70671_ap().func_75651_a((Entity)attackTarget, 90.0f, 90.0f);
                if ((double)Entity4307.this.func_70032_d((Entity)attackTarget) > Entity4307.this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e() / 2.0) {
                    if (Entity4307.this.field_70699_by == Entity4307.this.swimNavigator) {
                        Entity4307.this.func_70661_as().func_75497_a((Entity)attackTarget, 3.0);
                    } else {
                        Entity4307.this.func_70661_as().func_75497_a((Entity)attackTarget, 1.0);
                    }
                } else {
                    Entity4307.this.func_70661_as().func_75499_g();
                    if (this.timeExecuting >= 60 && attackTarget.func_70097_a(DAMAGE_SOURCE, 5.0f)) {
                        SCP.SimpleNetworkWrapper.sendToAllTracking((IMessage)new PlaySound(attackTarget.func_180425_c(), Sounds.scp4307shoot, 1.0f, 1.0f), (Entity)Entity4307.this);
                        this.timeExecuting = 0;
                    }
                }
            }
        }
    }
}

