/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.entity;

import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.ai.AIAvoidEntity;
import alexiy.secure.contain.protect.ai.AIMeleeAttack;
import alexiy.secure.contain.protect.ai.AINearestTarget;
import alexiy.secure.contain.protect.api.FlyingEntity;
import alexiy.secure.contain.protect.entity.EntityOmnivorousRabbit;
import alexiy.secure.contain.protect.entity.EntitySculpture;
import alexiy.secure.contain.protect.entity.EntityYoungGirl;
import alexiy.secure.contain.protect.entity.SCPHostileEntity;
import alexiy.secure.contain.protect.registration.SCPBlocks;
import alexiy.secure.contain.protect.registration.Sounds;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;

public class Entity682
extends SCPHostileEntity {
    public float biteProgress;
    private float damageRequired;
    private float previousWidth;
    private static final DataParameter<Boolean> IS_BITING = EntityDataManager.func_187226_a(Entity682.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> REPTILE_SIZE = EntityDataManager.func_187226_a(Entity682.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final float DEFAULT_WIDTH = 2.5f;
    private static final float DEFAULT_HEIGHT = 1.9f;
    private static final float MAXIMUM_SCALE = 1.52f;
    protected PathNavigateClimber navigateClimber;
    protected PathNavigateGround navigateGround;

    public Entity682(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.5f, 1.9f);
        this.previousWidth = this.field_70130_N;
        this.damageRequired = 50.0f;
        this.field_70178_ae = true;
        this.field_70138_W = 1.0f;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        this.navigateClimber = new PathNavigateClimber((EntityLiving)this, worldIn);
        this.navigateClimber.func_179693_d(true);
        this.navigateGround = new PathNavigateGround((EntityLiving)this, worldIn);
        this.navigateGround.func_179693_d(true);
        return super.func_175447_b(worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_85156_a((EntityAIBase)this.swimming);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AISwimming(this));
        this.field_70714_bg.func_85156_a((EntityAIBase)this.wandering);
        this.wandering = new Wandering(this, 1.0, 20);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.wandering);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.meleeAttack);
        this.meleeAttack = new AIMeleeAttack((EntityCreature)this, 1.0, false, true);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.meleeAttack);
        this.field_70714_bg.func_75776_a(1, new AIAvoidEntity<EntitySculpture>(this, EntitySculpture.class, 10.0f, 1.0, 1.0));
        this.field_70714_bg.func_75776_a(1, new AIAvoidEntity<EntityOmnivorousRabbit>(this, EntityOmnivorousRabbit.class, 15.0f, 1.0, 1.0));
        this.field_70715_bh.func_85156_a((EntityAIBase)this.baseAINearestTarget);
        Predicate targetPr = input -> !(input instanceof FlyingEntity) && input.getClass() != this.getClass() && input.getClass() != EntityYoungGirl.class && input.getClass() != EntityOmnivorousRabbit.class && Utils.isLivingEntity((Entity)input) && this.func_70685_l((Entity)input);
        this.baseAINearestTarget = new AINearestTarget<EntityLivingBase>(this, EntityLivingBase.class, true, false, targetPr);
        this.field_70715_bh.func_75776_a(3, this.baseAINearestTarget);
        this.baseAINearestTarget.func_190882_b(120);
    }

    public Float getSize() {
        return (Float)this.field_70180_af.func_187225_a(REPTILE_SIZE);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("Size", this.getSize().floatValue());
        compound.func_74776_a("PrevWidth", this.previousWidth);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        float f = compound.func_74760_g("Size");
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.previousWidth = compound.func_74760_g("PrevWidth");
        if (this.previousWidth == 0.0f) {
            this.previousWidth = 2.5f * f;
        }
        this.setReptileSize(f);
    }

    public void setReptileSize(float f) {
        if (f <= 1.52f && f >= 0.1f) {
            this.field_70180_af.func_187227_b(REPTILE_SIZE, (Object)Float.valueOf(f));
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_BITING, (Object)false);
        this.field_70180_af.func_187214_a(REPTILE_SIZE, (Object)Float.valueOf(1.0f));
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        super.func_70653_a(entityIn, this.getStrength(strength), xRatio, zRatio);
    }

    @Override
    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public void func_70636_d() {
        float newwidth;
        double fraction;
        super.func_70636_d();
        AxisAlignedBB boundingBox = this.func_174813_aQ().func_72321_a((double)0.2f, (double)0.2f, (double)0.2f);
        Iterable mutable = BlockPos.func_177975_b((BlockPos)new BlockPos(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c), (BlockPos)new BlockPos(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f));
        for (BlockPos blockPos : mutable) {
            IBlockState blockState = this.field_70170_p.func_180495_p(blockPos);
            Block block = blockState.func_177230_c();
            if (block == SCPBlocks.HClAcid) {
                if (!(this.func_110143_aJ() > this.func_110138_aP() / 3.0f)) continue;
                this.func_70097_a(SCP.acidDamage, 1.0f);
                this.field_70172_ad = 5;
                continue;
            }
            if (block.isAir(blockState, (IBlockAccess)this.field_70170_p, blockPos) || block instanceof BlockLiquid || block instanceof BlockFluidBase || block == Blocks.field_150431_aC || !block.isLeaves(blockState, (IBlockAccess)this.field_70170_p, blockPos) && !block.func_176200_f((IBlockAccess)this.field_70170_p, blockPos)) continue;
            this.field_70170_p.func_175655_b(blockPos, true);
        }
        EntityLivingBase target = this.func_70638_az();
        if (target != null) {
            this.func_70605_aq().func_75642_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, 1.0);
        }
        if ((fraction = Utils.getFraction(newwidth = 2.5f * this.getSize().floatValue())) > 0.9) {
            newwidth = (float)((double)newwidth - fraction + 1.1);
        }
        if (newwidth != this.previousWidth) {
            float newheight = 1.9f * this.getSize().floatValue();
            this.previousWidth = newwidth;
            this.func_70105_a(newwidth, newheight);
        }
        if (this.func_70094_T()) {
            this.setReptileSize(this.getSize().floatValue() + this.getGrowth(false));
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected float func_175134_bD() {
        return super.func_175134_bD();
    }

    public boolean func_70652_k(Entity entityIn) {
        EntityLivingBase entityLivingBase = (EntityLivingBase)entityIn;
        float growthModifier = entityLivingBase.func_110138_aP() / this.func_110138_aP();
        growthModifier = MathHelper.func_76131_a((float)growthModifier, (float)0.02f, (float)0.1f);
        this.setReptileSize(this.getSize().floatValue() + growthModifier);
        return super.func_70652_k(entityIn);
    }

    public float getStrength(float strength) {
        return (1.0f - this.func_110143_aJ() / this.func_110138_aP()) * strength;
    }

    public boolean func_180431_b(DamageSource source) {
        if (source == DamageSource.field_76369_e || source == DamageSource.field_76368_d) {
            return true;
        }
        return super.func_180431_b(source);
    }

    public boolean func_70097_a(DamageSource damageSrc, float damageAmount) {
        if (damageSrc != DamageSource.field_76380_i) {
            float damage = damageAmount;
            while (this.damageRequired - damage <= 0.0f && !(this.getSize().floatValue() <= 0.1f)) {
                this.setReptileSize(this.getSize().floatValue() + this.getGrowth(false));
                this.damageRequired = 50.0f;
                damage -= 50.0f;
            }
            this.damageRequired -= damage;
            return super.func_70097_a(damageSrc, this.func_110143_aJ() - damageAmount / 100.0f <= 0.0f ? this.func_110143_aJ() - 1.0f : damageAmount / 100.0f);
        }
        return super.func_70097_a(damageSrc, damageAmount);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (damageSourceIn == SCP.acidDamage) {
            return null;
        }
        return Sounds.reptileHurt;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(18.0);
        this.func_110148_a(SWIM_SPEED).func_111128_a(3.0);
    }

    public PathNavigate func_70661_as() {
        int ty;
        EntityLivingBase target = this.func_70638_az();
        this.field_70699_by = target == null ? this.navigateGround : ((ty = MathHelper.func_76128_c((double)target.field_70163_u)) - MathHelper.func_76128_c((double)this.field_70163_u) > 0 ? this.navigateClimber : this.navigateGround);
        return this.field_70699_by;
    }

    public boolean func_70617_f_() {
        return this.field_70123_F && this.field_70699_by == this.navigateClimber || this.field_70699_by == this.navigateGround && super.func_70617_f_();
    }

    public float getGrowth(boolean grow) {
        if (grow) {
            return 0.1f;
        }
        return -0.1f;
    }

    @Override
    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        if (entitylivingbaseIn != null && !entitylivingbaseIn.field_70128_L && this.func_70638_az() != entitylivingbaseIn) {
            this.func_184185_a(this.field_70146_Z.nextInt(100) == 0 ? Sounds.reptileAggroRare : Sounds.reptileAggro, 1.0f, 1.0f);
        }
        super.func_70624_b(entitylivingbaseIn);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.func_70638_az() == null) {
            return Sounds.reptileIdle;
        }
        return null;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return Sounds.reptileDeath;
    }

    private float getSoundSizePitch() {
        if (this.getSize().floatValue() <= 0.9f) {
            return 1.1f;
        }
        if (this.getSize().floatValue() > 1.0f) {
            return 0.9f;
        }
        return 1.0f;
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        super.func_184185_a(soundIn, volume, this.getSoundSizePitch());
    }

    class Wandering
    extends EntityAIWander {
        public Wandering(EntityCreature creatureIn, double speedIn, int chance) {
            super(creatureIn, speedIn, chance);
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }

        @Nullable
        protected Vec3d func_190864_f() {
            return super.func_190864_f();
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }
    }

    public static class AISwimming
    extends EntityAIBase {
        private final Entity682 entity;

        public AISwimming(Entity682 entityIn) {
            this.entity = entityIn;
            this.func_75248_a(4);
        }

        public boolean func_75250_a() {
            return this.entity.func_70090_H() || this.entity.func_180799_ab();
        }

        public void func_75246_d() {
            if ((this.entity.field_70159_w != 0.0 || this.entity.field_70179_y != 0.0) && this.entity.field_70173_aa % 10 == 0) {
                this.entity.func_70683_ar().func_75660_a();
            }
        }
    }
}

