/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.entity;

import alexiy.secure.contain.protect.InternalAPI;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.ai.AIMeleeAttack;
import alexiy.secure.contain.protect.api.MainAPI;
import alexiy.secure.contain.protect.capability.Capabilities;
import alexiy.secure.contain.protect.capability.crystallization.Crystallizable;
import alexiy.secure.contain.protect.entity.SCPHostileEntity;
import alexiy.secure.contain.protect.registration.Sounds;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLeaves;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityAllosaurus
extends SCPHostileEntity {
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityAllosaurus.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityAllosaurus(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.7f, 3.0f);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(54.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
    }

    @Override
    protected void func_184651_r() {
        this.meleeAttack = new AIMeleeAttack(this, 2.0, false);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.meleeAttack);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISleepCancel(this));
        this.defense = new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]);
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.defense);
        this.wandering = new AIWanderAvoidWater(this, 1.0);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.wandering);
        Predicate defaultPrey = input -> input instanceof EntityPig || input instanceof EntitySheep || input instanceof EntityCow || input instanceof EntityChicken;
        this.field_70715_bh.func_75776_a(3, new AIAttackNotSleep<EntityLivingBase>(this, EntityLivingBase.class, input -> MainAPI.humanTargets.apply(input) || defaultPrey.apply(input)));
        InternalAPI.addApiTargets(this);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
    }

    public void setSleeping(boolean sleeping) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)sleeping);
    }

    public boolean isSleeping() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        super.func_189511_e(compound);
        compound.func_74757_a("sleeping", this.isSleeping());
        return compound;
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.setSleeping(compound.func_74767_n("sleeping"));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            Crystallizable crystallizable;
            if (this.hasCapability(Capabilities.CRYSTALLIZABLE_CAPABILITY, null) && (crystallizable = (Crystallizable)this.getCapability(Capabilities.CRYSTALLIZABLE_CAPABILITY, null)).isCrystallized()) {
                return;
            }
            this.setSleeping(!this.field_70170_p.func_72935_r() && this.func_70638_az() == null && this.func_70643_av() == null);
            EnumFacing facing = this.func_174811_aO();
            AxisAlignedBB axisAlignedBB = this.func_174813_aQ().func_72321_a((double)facing.func_82601_c(), 1.0, (double)facing.func_82599_e());
            Utils.boundingBoxToPositions(axisAlignedBB).forEach(blockPos -> {
                if (this.field_70170_p.func_180495_p(blockPos).func_177230_c() instanceof BlockLeaves) {
                    this.field_70170_p.func_175655_b(blockPos, true);
                }
            });
        }
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return Sounds.scp250_damaged;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return this.func_70638_az() == null ? Sounds.scp250_idle : Sounds.scp250_attacking;
    }

    public boolean func_70104_M() {
        return false;
    }

    private static class AISleepCancel
    extends EntityAIBase {
        private EntityAllosaurus allosaurus;

        AISleepCancel(EntityAllosaurus allosaurus) {
            this.allosaurus = allosaurus;
        }

        public boolean func_75250_a() {
            return this.allosaurus.isSleeping();
        }
    }

    private static class AIAttackNotSleep<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        AIAttackNotSleep(EntityCreature creature, Class<T> classTarget, @Nullable Predicate<T> targetSelector) {
            super(creature, classTarget, 0, true, false, targetSelector);
        }

        public boolean func_75250_a() {
            return !((EntityAllosaurus)this.field_75299_d).isSleeping() && super.func_75250_a();
        }
    }

    private static class AIWanderAvoidWater
    extends EntityAIWanderAvoidWater {
        private EntityAllosaurus allosaurus;

        AIWanderAvoidWater(EntityAllosaurus entityCreature, double speedFactor) {
            super((EntityCreature)entityCreature, speedFactor);
            this.allosaurus = entityCreature;
        }

        public boolean func_75250_a() {
            return !this.allosaurus.isSleeping() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return !this.allosaurus.isSleeping() && super.func_75253_b();
        }
    }
}

