/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.entity;

import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.ai.AIMeleeAttack;
import alexiy.secure.contain.protect.ai.AINearestTarget;
import alexiy.secure.contain.protect.api.MainAPI;
import alexiy.secure.contain.protect.entity.EntityElectroSheepLamb;
import alexiy.secure.contain.protect.entity.EntityLightning;
import alexiy.secure.contain.protect.entity.SCPAnimal;
import alexiy.secure.contain.protect.registration.SCPBlocks;
import alexiy.secure.contain.protect.registration.SCPItems;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class EntityElectroSheep
extends SCPAnimal
implements IShearable {
    private static final DataParameter<Boolean> HAS_WOOL = EntityDataManager.func_187226_a(EntityElectroSheep.class, (DataSerializer)DataSerializers.field_187198_h);
    protected int woolRegrowth;
    protected EntityAITarget attackableTarget;
    public boolean isPacified;

    public EntityElectroSheep(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.2f, 1.5f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.attackableTarget = new AINearestTarget<EntityLivingBase>((EntityCreature)this, EntityLivingBase.class, true, false, MainAPI.humanTargets);
        this.field_70715_bh.func_75776_a(1, this.attackableTarget);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIMeleeAttack((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 10.0f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityElectroSheepLamb.class}));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 16.0f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_WOOL, (Object)true);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            if (this.hasWool() && this.isAdult()) {
                Utils.spawnItemInWorld(new ItemStack(SCPBlocks.electricWool), this.field_70170_p, this.func_180425_c());
            }
            if (this.isAdult()) {
                Utils.spawnItemInWorld(new ItemStack(SCPItems.rawThundermeat), this.field_70170_p, this.func_180425_c());
            }
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
    }

    public void setHasWool(boolean b) {
        this.field_70180_af.func_187227_b(HAS_WOOL, (Object)b);
    }

    public boolean hasWool() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_WOOL);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.func_70638_az() == null && this.age % Utils.secondsToTicks(20) == 0 && this.func_70681_au().nextInt(10) > 6) {
            if (this.isAdult()) {
                Utils.addPotionEffectNoParticles((EntityLivingBase)this, MobEffects.field_188424_y, 80, 0);
            } else {
                Utils.addPotionEffectNoParticles((EntityLivingBase)this, MobEffects.field_188424_y, 60, 0);
            }
        }
        if (this.isAdult() && this.age > 0) {
            if (this.age % Utils.minutesToTicks(15) == 0 && !this.field_70170_p.func_72872_a(EntityElectroSheep.class, new AxisAlignedBB(this.func_180425_c()).func_186662_g(8.0)).isEmpty()) {
                this.func_146082_f(null);
            }
            if (!this.hasWool() && this.woolRegrowth > Utils.minutesToTicks(7)) {
                this.setHasWool(true);
                this.woolRegrowth = 0;
            } else {
                ++this.woolRegrowth;
            }
        }
    }

    public boolean func_180431_b(DamageSource source) {
        if (source == DamageSource.field_180137_b || source == DamageSource.field_76370_b || source == DamageSource.field_76372_a) {
            return true;
        }
        return super.func_180431_b(source);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.func_70681_au().nextInt(100) > 70) {
            EntityLightning lightningBolt = new EntityLightning(this.field_70170_p, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)lightningBolt);
            this.field_70170_p.func_72942_c((Entity)lightningBolt);
        }
        return super.func_70652_k(entityIn);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187761_eI;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
    }

    @Override
    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityElectroSheepLamb(this.field_70170_p);
    }

    @Override
    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        compound.func_74757_a("Has wool", this.hasWool());
        compound.func_74768_a("Wool timer", this.woolRegrowth);
        compound.func_74757_a("Pacified", this.isPacified);
        return super.func_189511_e(compound);
    }

    @Override
    public void func_70020_e(NBTTagCompound compound) {
        this.setHasWool(compound.func_74767_n("Has wool"));
        this.woolRegrowth = compound.func_74762_e("Wool timer");
        this.isPacified = compound.func_74767_n("Pacified");
        if (this.isPacified) {
            this.field_70715_bh.func_85156_a((EntityAIBase)this.attackableTarget);
        }
        super.func_70020_e(compound);
    }

    public boolean isShearable(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos) {
        return this.isAdult() && this.hasWool();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        this.setHasWool(false);
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(SCPBlocks.electricWool, 2)});
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.isPacified && SCPItems.candies.contains(stack.func_77973_b()) || stack.func_77973_b() == Items.field_151106_aX) {
            this.func_70624_b(null);
            this.func_175505_a(player, stack);
            this.field_70715_bh.func_85156_a((EntityAIBase)this.attackableTarget);
            this.isPacified = true;
            return true;
        }
        return super.func_184645_a(player, hand);
    }
}

