/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.entity;

import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.ai.AIMeleeAttack;
import alexiy.secure.contain.protect.ai.AINearestTarget;
import alexiy.secure.contain.protect.ai.climbing.PathNavigatorClimb2;
import alexiy.secure.contain.protect.api.MainAPI;
import alexiy.secure.contain.protect.entity.SCPCreature;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityIceSpider
extends SCPCreature {
    protected boolean insideWeb;
    protected Burrowing burrowTask;
    private static final List<Block> BREAKABLE_BLOCKS = new ArrayList<Block>();

    public EntityIceSpider(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.5f);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIMeleeAttack(this, 1.0, false));
        this.burrowTask = new Burrowing();
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.burrowTask);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AINearestTarget<EntityLivingBase>(this, EntityLivingBase.class, true, false, input -> MainAPI.humanTargets.apply(input) && (double)this.field_70170_p.func_180494_b(this.func_180425_c()).func_185353_n() >= 0.95));
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigatorClimb2((EntityLiving)this, worldIn);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entityIn;
            Utils.addPotionEffectNoParticles(living, MobEffects.field_76421_d, Utils.secondsToTicks(10), 1);
            this.func_130011_c(entityIn);
            return true;
        }
        return super.func_70652_k(entityIn);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.insideWeb && this.age % Utils.secondsToTicks(10) == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() != Blocks.field_150321_G) {
            this.insideWeb = false;
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Inside web", this.insideWeb);
        if (this.burrowTask.burrowPosition != null) {
            compound.func_74772_a("BurrowPos", this.burrowTask.burrowPosition.func_177986_g());
        }
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.insideWeb = compound.func_74767_n("Inside web");
        if (compound.func_74764_b("BurrowPos")) {
            this.burrowTask.burrowPosition = BlockPos.func_177969_a((long)compound.func_74763_f("BurrowPos"));
        }
    }

    public void func_70110_aj() {
        this.insideWeb = true;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_70617_f_() {
        return this.field_70123_F;
    }

    static {
        BREAKABLE_BLOCKS.add((Block)Blocks.field_150349_c);
        BREAKABLE_BLOCKS.add(Blocks.field_185774_da);
        BREAKABLE_BLOCKS.add(Blocks.field_150346_d);
        BREAKABLE_BLOCKS.add(Blocks.field_150351_n);
        BREAKABLE_BLOCKS.add((Block)Blocks.field_150354_m);
    }

    protected class Burrowing
    extends EntityAIBase {
        private BlockPos burrowPosition;
        private final short BURROW_DEPTH;
        private short burrowProgress;
        private int ticksInBurrow;
        private long ticksSinceLeftBurrow;

        protected Burrowing() {
            this.BURROW_DEPTH = (short)(EntityIceSpider.this.field_70146_Z.nextInt(3) + 1);
            this.burrowProgress = 0;
            this.ticksInBurrow = 0;
            this.ticksSinceLeftBurrow = 0L;
        }

        public boolean func_75250_a() {
            if (EntityIceSpider.this.func_70090_H() || EntityIceSpider.this.hasTarget()) {
                return false;
            }
            if (!this.doesBurrowExist()) {
                SCP.logger.info("Does not have Burrow");
                if (EntityIceSpider.this.field_70146_Z.nextInt(25) < 1) {
                    SCP.logger.info("Wants to make burrow");
                    if (this.shouldBurrow(EntityIceSpider.this.func_180425_c())) {
                        SCP.logger.info("Has made burrow");
                        this.burrowPosition = EntityIceSpider.this.func_180425_c().func_177977_b();
                        EntityIceSpider.this.field_70170_p.func_175656_a(this.burrowPosition, Blocks.field_150321_G.func_176223_P());
                        this.burrowProgress = (short)(this.burrowProgress + 1);
                        EntityIceSpider.this.field_70765_h.func_75642_a((double)this.burrowPosition.func_177958_n() + 0.5, (double)this.burrowPosition.func_177956_o(), (double)this.burrowPosition.func_177952_p() + 0.5, 1.0);
                        return true;
                    }
                }
                return false;
            }
            SCP.logger.info("Has Burrow");
            int chance = EntityIceSpider.this.field_70170_p.func_72935_r() ? 100 : 1000;
            return EntityIceSpider.this.field_70146_Z.nextInt(chance) < 1 || this.ticksSinceLeftBurrow / 60L - EntityIceSpider.this.field_70170_p.func_82737_E() / 60L > (long)Utils.minutesToTicks(3);
        }

        public boolean func_75253_b() {
            if (EntityIceSpider.this.hasTarget() || !this.doesBurrowExist()) {
                return false;
            }
            int x = (int)(EntityIceSpider.this.field_70170_p.func_72820_D() % 24000L);
            int chance = (int)(MathHelper.func_76134_b((float)((float)((double)x - 15.50255442185933))) * 9500.0f / 2.0f + 5250.0f);
            SCP.logger.info("Chance = {}", (Object)chance);
            if (EntityIceSpider.this.field_70146_Z.nextInt(chance) == 0) {
                return false;
            }
            return Utils.ticksToMinutes(this.ticksInBurrow) < 3;
        }

        public void func_75251_c() {
            this.ticksSinceLeftBurrow = EntityIceSpider.this.field_70170_p.func_82737_E();
            this.ticksInBurrow = 0;
            this.func_75248_a(0);
        }

        public void func_75249_e() {
            SCP.logger.info("Started");
            this.func_75248_a(1);
            EntityIceSpider.this.field_70765_h.func_75642_a((double)this.burrowPosition.func_177958_n() + 0.5, (double)this.burrowPosition.func_177956_o(), (double)this.burrowPosition.func_177952_p() + 0.5, 1.0);
        }

        public void func_75246_d() {
            ++this.ticksInBurrow;
            if (EntityIceSpider.this.func_180425_c().func_185332_f(this.burrowPosition.func_177958_n(), this.burrowPosition.func_177956_o(), this.burrowPosition.func_177952_p()) > 0.5) {
                EntityIceSpider.this.field_70765_h.func_75642_a((double)this.burrowPosition.func_177958_n() + 0.5, (double)this.burrowPosition.func_177956_o(), (double)this.burrowPosition.func_177952_p() + 0.5, 1.0);
            }
            SCP.logger.info((Object)this.ticksInBurrow);
            if (Utils.ticksToMinutes(this.ticksInBurrow) > 1 && this.BURROW_DEPTH != this.burrowProgress) {
                this.shouldBurrow(this.burrowPosition);
            }
        }

        private boolean shouldBurrow(BlockPos pos) {
            if (EntityIceSpider.this.field_70170_p.func_180494_b(pos).func_185353_n() <= 0.2f) {
                if (BREAKABLE_BLOCKS.contains(EntityIceSpider.this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c())) {
                    for (EnumFacing direction : BlockHorizontal.field_185512_D.func_177700_c()) {
                        if (EntityIceSpider.this.field_70170_p.func_180495_p(pos.func_177977_b().func_177972_a(direction)).func_185917_h()) continue;
                        SCP.logger.info("Block {}, at {} is not a full cube!", (Object)EntityIceSpider.this.field_70170_p.func_180495_p(pos.func_177977_b().func_177972_a(direction)).func_177230_c().func_149732_F(), (Object)pos.func_177977_b().func_177972_a(direction));
                        return false;
                    }
                    return true;
                }
                SCP.logger.info("Block beneath \"{}\" is not breakable", (Object)EntityIceSpider.this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c().func_149732_F());
            } else {
                SCP.logger.info("Is not cold Enough");
            }
            return false;
        }

        private boolean doesBurrowExist() {
            return this.burrowPosition != null && EntityIceSpider.this.field_70170_p.func_180495_p(this.burrowPosition).func_177230_c() == Blocks.field_150321_G;
        }
    }
}

