/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.entity;

import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.ai.AIHunt;
import alexiy.secure.contain.protect.ai.AIMeleeAttack;
import alexiy.secure.contain.protect.ai.AIStalk;
import alexiy.secure.contain.protect.capability.Capabilities;
import alexiy.secure.contain.protect.capability.sleepdeprivation.ISleepDeprivationCapability;
import alexiy.secure.contain.protect.entity.SCPCreature;
import alexiy.secure.contain.protect.registration.Sounds;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class EntitySleepKiller
extends SCPCreature {
    public EntitySleepKiller(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.9f);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIScreech(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIMeleeAttack(this, 1.0, false).setDamageSource(new EntityDamageSource("mob.sleep_depriver", (Entity)this)));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_85156_a((EntityAIBase)this.wandering);
        this.wandering = new Wander(this, 1.0);
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)this.wandering);
        Predicate<EntityLivingBase> applicable = entityLivingBase -> {
            if (entityLivingBase.hasCapability(Capabilities.SlEEP_DEPRIVATION, null)) {
                ISleepDeprivationCapability sleepDeprivationCapability = (ISleepDeprivationCapability)entityLivingBase.getCapability(Capabilities.SlEEP_DEPRIVATION, null);
                return !sleepDeprivationCapability.isCured();
            }
            return false;
        };
        Predicate<EntityLivingBase> huntCondition = entityLivingBase -> {
            if (entityLivingBase.hasCapability(Capabilities.SlEEP_DEPRIVATION, null)) {
                ISleepDeprivationCapability sleepDeprivationCapability = (ISleepDeprivationCapability)entityLivingBase.getCapability(Capabilities.SlEEP_DEPRIVATION, null);
                return sleepDeprivationCapability.isSleeping();
            }
            return false;
        };
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIStalk((EntityLiving)this, applicable, 5.0f, 2.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIHunt((EntityLiving)this, huntCondition, 5.0f));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        Utils.enableDoorEnter((EntityLiving)this, false);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
    }

    private class AIScreech
    extends EntityAIBase {
        private EntitySleepKiller owner;

        AIScreech(EntitySleepKiller entity) {
            this.owner = entity;
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            double range = 6.0;
            List players = this.owner.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.owner.func_180425_c()).func_72314_b(range, range, range));
            for (EntityPlayer player : players) {
                if (!Utils.isPlayerInSurvivalMode(player) || !EntitySleepKiller.this.func_70685_l((Entity)player) || !((ISleepDeprivationCapability)player.getCapability(Capabilities.SlEEP_DEPRIVATION, null)).isCured()) continue;
                return true;
            }
            return false;
        }

        public void func_75246_d() {
            double range = 6.0;
            List players = this.owner.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.owner.func_180425_c()).func_72314_b(range, range, range));
            boolean scream = false;
            for (EntityPlayer player : players) {
                ISleepDeprivationCapability deprivationCapability;
                if (!Utils.isPlayerInSurvivalMode(player) || !EntitySleepKiller.this.func_70685_l((Entity)player) || !(deprivationCapability = (ISleepDeprivationCapability)player.getCapability(Capabilities.SlEEP_DEPRIVATION, null)).isCured()) continue;
                deprivationCapability.setCured(false);
                scream = true;
                player.func_145747_a((ITextComponent)new TextComponentTranslation("scp.player.sleep.disable", new Object[0]));
            }
            if (scream) {
                this.owner.func_184185_a(Sounds.sleep_killer_screech, 1.0f, 1.0f);
            }
        }
    }

    private class Wander
    extends EntityAIWanderAvoidWater {
        Wander(EntityCreature p_i47301_1_, double p_i47301_2_) {
            super(p_i47301_1_, p_i47301_2_, 80.0f);
        }

        public boolean func_75250_a() {
            return this.field_75457_a.func_70638_az() == null && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }
    }
}

