/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.entity.staff;

import alexiy.secure.contain.protect.NBTWriter;
import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.ai.AIBase;
import alexiy.secure.contain.protect.ai.AIFollow;
import alexiy.secure.contain.protect.ai.AIHurtByTarget;
import alexiy.secure.contain.protect.ai.AIRangedAttack;
import alexiy.secure.contain.protect.api.Human;
import alexiy.secure.contain.protect.api.Observer;
import alexiy.secure.contain.protect.entity.SCPHostileEntity;
import alexiy.secure.contain.protect.items.ItemCommandTool;
import alexiy.secure.contain.protect.registration.SCPItems;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import org.apache.commons.lang3.RandomUtils;

public abstract class EntitySCPStaff
extends EntityCreature
implements Observer,
Human,
IRangedAttackMob {
    protected ItemCommandTool.Command currentCommand = ItemCommandTool.Command.NONE;
    protected UUID commander;
    protected AIFollow followingPlayer;
    protected Stay stay;
    protected Protect protectPlayer;
    protected AttackAssist attackAssist;
    protected BlockPos guardPosition;
    protected Guard guardTask;
    protected static final DataParameter<Boolean> ATTACKING_WITH_RANGED_WEAPON = EntityDataManager.func_187226_a(EntitySCPStaff.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntitySCPStaff(World worldIn) {
        super(worldIn);
        this.func_98053_h(true);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING_WITH_RANGED_WEAPON, (Object)false);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (!this.func_145818_k_() && !SCP.PROXY.donorList.isEmpty() && RandomUtils.nextInt((int)0, (int)100) > 50) {
            this.func_96094_a((String)SCP.PROXY.donorList.get(RandomUtils.nextInt((int)0, (int)SCP.PROXY.donorList.size())));
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public boolean isAttackingWithRangedWeapon() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING_WITH_RANGED_WEAPON);
    }

    public void setAttackingWithRangedWeapon(boolean b) {
        this.field_70180_af.func_187227_b(ATTACKING_WITH_RANGED_WEAPON, (Object)b);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
    }

    protected void func_184651_r() {
        Predicate<EntityLivingBase> predicate = entityPlayer -> this.currentCommand == ItemCommandTool.Command.FOLLOW && this.func_70638_az() != entityPlayer && entityPlayer.func_110124_au().equals(this.commander);
        this.followingPlayer = new AIFollow((EntityLiving)this, EntityPlayer.class, false, predicate);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.followingPlayer);
        this.stay = new Stay();
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.stay);
        this.protectPlayer = new Protect();
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.protectPlayer);
        this.attackAssist = new AttackAssist();
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.attackAssist);
        this.guardTask = new Guard();
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.guardTask);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.func_70625_a((Entity)target, 180.0f, 90.0f);
    }

    public boolean func_70652_k(Entity entityIn) {
        return super.func_70652_k(entityIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityLivingBase) {
            if ((double)this.field_70146_Z.nextFloat() + 0.1 > (double)(this.func_110143_aJ() / this.func_110138_aP())) {
                this.func_184598_c(EnumHand.OFF_HAND);
            } else {
                this.func_184602_cy();
                this.func_184598_c(EnumHand.MAIN_HAND);
            }
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_190629_c(EntityLivingBase attacker) {
        super.func_190629_c(attacker);
        if (attacker.func_184614_ca().func_77973_b().canDisableShield(attacker.func_184614_ca(), this.func_184607_cu(), (EntityLivingBase)this, attacker)) {
            float f = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
            f += 0.75f;
            if (this.field_70146_Z.nextFloat() < f) {
                this.func_184602_cy();
                this.field_70170_p.func_72960_a((Entity)this, (byte)30);
            }
        }
    }

    protected void func_184590_k(float damage) {
        if (damage >= 3.0f && this.field_184627_bm.func_77973_b().isShield(this.field_184627_bm, (EntityLivingBase)this)) {
            int i = 1 + MathHelper.func_76141_d((float)damage);
            this.field_184627_bm.func_77972_a(i, (EntityLivingBase)this);
            if (this.field_184627_bm.func_190926_b()) {
                EnumHand enumhand = this.func_184600_cs();
                if (enumhand == EnumHand.MAIN_HAND) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                } else {
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                }
                this.field_184627_bm = ItemStack.field_190927_a;
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    public void func_184724_a(boolean swingingArms) {
        this.setAttackingWithRangedWeapon(swingingArms);
    }

    @Override
    public boolean canStopSculpture() {
        return true;
    }

    @Override
    public boolean canTriggerHaunter() {
        return true;
    }

    @Override
    public boolean canBeAffectedByPainting() {
        return true;
    }

    @Override
    public boolean canTriggerShyGuy() {
        return true;
    }

    @Override
    public boolean canBeAffectedByBlackShuck() {
        return true;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        NBTTagCompound compound;
        ItemStack itemStack = player.func_184586_b(hand);
        Item item = itemStack.func_77973_b();
        if (item == SCPItems.npcTool && (compound = itemStack.func_77978_p()) != null) {
            ItemCommandTool.Command command;
            this.currentCommand = command = ItemCommandTool.Command.values()[compound.func_74771_c("Command")];
            if (this.field_70170_p.field_72995_K) {
                Utils.sendMessageTo(player, "You commanded " + this.func_70005_c_() + " to " + (Object)((Object)command));
            }
            if (this.currentCommand == ItemCommandTool.Command.NONE) {
                this.commander = null;
                if (this.field_70170_p.field_72995_K) {
                    Utils.sendMessageTo(player, "You released this " + this.func_70005_c_());
                }
            } else if (!player.func_110124_au().equals(this.commander)) {
                this.commander = player.func_110124_au();
                if (this.field_70170_p.field_72995_K) {
                    Utils.sendMessageTo(player, "You claimed this " + this.func_70005_c_());
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("CurrentCommand", (byte)this.currentCommand.ordinal());
        NBTWriter.setNonnullUUID("Commander", this.commander, compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.commander = NBTWriter.getNonnullUUID("Commander", compound);
        this.currentCommand = ItemCommandTool.Command.values()[compound.func_74771_c("CurrentCommand")];
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
    }

    protected class Protect
    extends AIBase {
        EntityPlayer player;

        protected Protect() {
        }

        public boolean func_75250_a() {
            if (EntitySCPStaff.this.currentCommand == ItemCommandTool.Command.PROTECT_ME) {
                double range = EntitySCPStaff.this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
                List players = EntitySCPStaff.this.field_70170_p.func_175647_a(EntityPlayer.class, new AxisAlignedBB(EntitySCPStaff.this.func_180425_c()).func_186662_g(range), input -> input.func_110124_au().equals(EntitySCPStaff.this.commander));
                if (!players.isEmpty()) {
                    this.player = (EntityPlayer)players.get(0);
                    return true;
                }
            }
            return false;
        }

        public boolean func_75253_b() {
            return EntitySCPStaff.this.currentCommand == ItemCommandTool.Command.PROTECT_ME;
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            if (this.player.func_70643_av() != null && this.player.func_70643_av() != EntitySCPStaff.this) {
                EntitySCPStaff.this.func_70624_b(this.player.func_70643_av());
            } else {
                EntitySCPStaff.this.func_70624_b(null);
                if (EntitySCPStaff.this.func_70032_d((Entity)this.player) > 4.0f) {
                    EntitySCPStaff.this.func_70661_as().func_75497_a((Entity)this.player, 1.0);
                } else {
                    EntitySCPStaff.this.func_70661_as().func_75499_g();
                }
            }
        }
    }

    protected class AttackAssist
    extends AIBase {
        EntityPlayer player;

        protected AttackAssist() {
        }

        public boolean func_75250_a() {
            if (EntitySCPStaff.this.currentCommand == ItemCommandTool.Command.ASSIST_ATTACK) {
                double range = EntitySCPStaff.this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
                List players = EntitySCPStaff.this.field_70170_p.func_175647_a(EntityPlayer.class, new AxisAlignedBB(EntitySCPStaff.this.func_180425_c()).func_186662_g(range), input -> input.func_110124_au().equals(EntitySCPStaff.this.commander));
                if (!players.isEmpty()) {
                    this.player = (EntityPlayer)players.get(0);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            if (this.player.func_110144_aD() != null && this.player.func_110144_aD() != EntitySCPStaff.this) {
                EntitySCPStaff.this.func_70624_b(this.player.func_110144_aD());
            } else if (EntitySCPStaff.this.func_70032_d((Entity)this.player) > 4.0f && this.player.func_70089_S()) {
                EntitySCPStaff.this.func_70661_as().func_75497_a((Entity)this.player, 1.0);
            } else {
                this.player = null;
                EntitySCPStaff.this.func_70661_as().func_75499_g();
            }
        }

        public boolean func_75253_b() {
            return this.player != null && EntitySCPStaff.this.currentCommand == ItemCommandTool.Command.ASSIST_ATTACK;
        }
    }

    protected class Stay
    extends AIBase {
        protected Stay() {
        }

        public boolean func_75250_a() {
            return EntitySCPStaff.this.currentCommand == ItemCommandTool.Command.HOLD_POSITION;
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            EntitySCPStaff.this.func_70661_as().func_75499_g();
        }
    }

    protected class Guard
    extends AIBase {
        protected Guard() {
        }

        public boolean func_75250_a() {
            return EntitySCPStaff.this.currentCommand == ItemCommandTool.Command.GUARD_POSITION;
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntitySCPStaff.this.guardPosition = EntitySCPStaff.this.func_180425_c();
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            double range = EntitySCPStaff.this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
            List<EntityLivingBase> list = Utils.getEntitiesInsideExcept((Entity)EntitySCPStaff.this, EntityLivingBase.class, new AxisAlignedBB(EntitySCPStaff.this.guardPosition).func_186662_g(range), entityLivingBase -> EntitySCPStaff.this.func_70685_l((Entity)entityLivingBase) && (entityLivingBase instanceof IMob || entityLivingBase instanceof SCPHostileEntity));
            list.sort((o1, o2) -> Float.compare(EntitySCPStaff.this.func_70032_d((Entity)o1), EntitySCPStaff.this.func_70032_d((Entity)o2)));
            if (!list.isEmpty()) {
                EntitySCPStaff.this.func_70624_b(list.get(0));
            } else {
                EntitySCPStaff.this.func_70624_b(null);
            }
            if (EntitySCPStaff.this.func_70638_az() == null) {
                EntitySCPStaff.this.func_70661_as().func_75492_a((double)EntitySCPStaff.this.guardPosition.func_177958_n(), (double)EntitySCPStaff.this.guardPosition.func_177956_o(), (double)EntitySCPStaff.this.guardPosition.func_177952_p(), 1.0);
            }
        }
    }

    protected class BowAttack
    extends AIRangedAttack {
        public BowAttack(IRangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
            super(attacker, movespeed, maxAttackTime, maxAttackDistanceIn);
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && this.entity.func_70638_az() != null && !this.entity.func_70638_az().func_110124_au().equals(EntitySCPStaff.this.commander);
        }
    }

    protected class Defense
    extends AIHurtByTarget {
        public Defense(EntityCreature creature, boolean callForHelp, Class<? extends EntityLiving> c) {
            super(creature, callForHelp, c);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.field_75299_d.func_70643_av().func_110124_au().equals(EntitySCPStaff.this.commander);
        }

        public void func_75246_d() {
            super.func_75246_d();
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.field_75299_d.func_184602_cy();
        }
    }
}

