/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.events;

import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.capability.Capabilities;
import alexiy.secure.contain.protect.capability.bloodstone.BloodstoneProvider;
import alexiy.secure.contain.protect.capability.bloodstone.IBloodstoneCapability;
import alexiy.secure.contain.protect.capability.cowbell.CowbellProvider;
import alexiy.secure.contain.protect.capability.cowbell.ICowbellCapability;
import alexiy.secure.contain.protect.capability.crystallization.CrystallizationProvider;
import alexiy.secure.contain.protect.capability.dizziness.Dizziness;
import alexiy.secure.contain.protect.capability.dizziness.DizzinessCap;
import alexiy.secure.contain.protect.capability.eatenitem.EatenItemProvider;
import alexiy.secure.contain.protect.capability.eternalflame.EternalFlameProvider;
import alexiy.secure.contain.protect.capability.guiltmob.GuiltMobProvider;
import alexiy.secure.contain.protect.capability.killedentities.KilledEntitiesProvider;
import alexiy.secure.contain.protect.capability.lostitems.ILostItemsCapability;
import alexiy.secure.contain.protect.capability.lostitems.LostItemsProvider;
import alexiy.secure.contain.protect.capability.playerknowledge.SCPKnowledge;
import alexiy.secure.contain.protect.capability.playerknowledge.SCPKnowledgeCap;
import alexiy.secure.contain.protect.capability.shadowinfestation.ShadowInfestationProvider;
import alexiy.secure.contain.protect.capability.sleepdeprivation.ISleepDeprivationCapability;
import alexiy.secure.contain.protect.capability.sleepdeprivation.SleepDeprivationProvider;
import alexiy.secure.contain.protect.capability.synchronization.SynchronizeToClient;
import alexiy.secure.contain.protect.capability.vanqar.VanqarProvider;
import alexiy.secure.contain.protect.capability.vermingod.VerminGodProvider;
import alexiy.secure.contain.protect.capability.verminsuppressor.VerminSuppressorProvider;
import alexiy.secure.contain.protect.capability.villagevermin.VerminSourceCapability;
import alexiy.secure.contain.protect.capability.world.OldManController;
import alexiy.secure.contain.protect.capability.world.OldManControllerCap;
import alexiy.secure.contain.protect.capability.zombievirus.VirusProvider;
import alexiy.secure.contain.protect.entity.EntitySleepKiller;
import alexiy.secure.contain.protect.entity.EntityVerminGod;
import alexiy.secure.contain.protect.events.CommonEvents;
import alexiy.secure.contain.protect.registration.SCPBlocks;
import alexiy.secure.contain.protect.world.pocketdimension.WorldProvider106;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class CapabilityController {
    private static final ResourceLocation LOST_ITEMS_KEY = new ResourceLocation("scp", "lostItems");
    private static final ResourceLocation SLEEP_DEPRIVATION_KEY = new ResourceLocation("scp", "sleepDeprivation");
    public static final ResourceLocation CRYSTALLIZATION = new ResourceLocation("scp", "crystallization");
    public static final ResourceLocation ZOMBIE_PLAGUE_ID = new ResourceLocation("scp", "zombie_plague");
    private static final ResourceLocation SHADOW_INFESTATION_KEY = new ResourceLocation("scp", "shadowInfestation");
    private static final ResourceLocation COWBELL_KEY = new ResourceLocation("scp", "cowbell");
    private static final ResourceLocation BLOODSTONE_KEY = new ResourceLocation("scp", "bloodstone");
    private static final ResourceLocation KILLED_ENTITIES_KEY = new ResourceLocation("scp", "killedEntities");
    private static final ResourceLocation RENDER_KEY = new ResourceLocation("scp", "render");
    private static final ResourceLocation VANQAR_KEY = new ResourceLocation("scp", "vanqar");
    private static final ResourceLocation ETERNAL_FLAME_KEY = new ResourceLocation("scp", "eternalFlame");
    private static final ResourceLocation EATEN_ITEM_KEY = new ResourceLocation("scp", "eatenItem");
    private static final ResourceLocation VERMIN_GOD_KEY = new ResourceLocation("scp", "verminGod");
    public static final ResourceLocation SCPinformation = new ResourceLocation("scp", "scp_knowledge");
    private static final ResourceLocation OLDMANCAP = new ResourceLocation("scp", "old_man_control");
    static final ResourceLocation VILLAGEVERMIN = new ResourceLocation("scp", "village_vermin");
    private static final ResourceLocation VERMIN_SUPPRESSOR_KEY = new ResourceLocation("scp", "vermin_suppressor");
    public static final ResourceLocation DIZZINESS_KEY = new ResourceLocation("scp", "dizziness");

    @SubscribeEvent
    public static void attachWorldCaps(AttachCapabilitiesEvent<World> event) {
        World world = (World)event.getObject();
        if (world.field_73011_w instanceof WorldProvider106) {
            event.addCapability(OLDMANCAP, (ICapabilityProvider)new OldManControllerCap());
        }
    }

    @SubscribeEvent
    public static void attachToVillage(AttachCapabilitiesEvent<Village> event) {
        event.addCapability(VILLAGEVERMIN, (ICapabilityProvider)new VerminSourceCapability());
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(LOST_ITEMS_KEY, (ICapabilityProvider)new LostItemsProvider());
            event.addCapability(SLEEP_DEPRIVATION_KEY, (ICapabilityProvider)new SleepDeprivationProvider());
            event.addCapability(SHADOW_INFESTATION_KEY, (ICapabilityProvider)new ShadowInfestationProvider());
            event.addCapability(COWBELL_KEY, (ICapabilityProvider)new CowbellProvider());
            event.addCapability(BLOODSTONE_KEY, (ICapabilityProvider)new BloodstoneProvider());
            event.addCapability(KILLED_ENTITIES_KEY, (ICapabilityProvider)new KilledEntitiesProvider());
            event.addCapability(CRYSTALLIZATION, (ICapabilityProvider)new CrystallizationProvider());
            event.addCapability(ZOMBIE_PLAGUE_ID, (ICapabilityProvider)new VirusProvider());
            event.addCapability(VANQAR_KEY, (ICapabilityProvider)new VanqarProvider());
            event.addCapability(VERMIN_GOD_KEY, (ICapabilityProvider)new VerminGodProvider());
            event.addCapability(SCPinformation, (ICapabilityProvider)new SCPKnowledgeCap());
            event.addCapability(VERMIN_SUPPRESSOR_KEY, (ICapabilityProvider)new VerminSuppressorProvider());
            event.addCapability(DIZZINESS_KEY, (ICapabilityProvider)new DizzinessCap());
        } else if (event.getObject() instanceof EntityVerminGod) {
            event.addCapability(VERMIN_GOD_KEY, (ICapabilityProvider)new VerminGodProvider());
        } else if (event.getObject() instanceof EntityLiving) {
            event.addCapability(CRYSTALLIZATION, (ICapabilityProvider)new CrystallizationProvider());
            event.addCapability(SHADOW_INFESTATION_KEY, (ICapabilityProvider)new ShadowInfestationProvider());
            event.addCapability(RENDER_KEY, (ICapabilityProvider)new GuiltMobProvider());
            event.addCapability(ZOMBIE_PLAGUE_ID, (ICapabilityProvider)new VirusProvider());
        } else if (event.getObject() instanceof EntityItem) {
            EntityItem entityItem = (EntityItem)event.getObject();
            if (entityItem.field_70170_p != null) {
                event.addCapability(EATEN_ITEM_KEY, (ICapabilityProvider)new EatenItemProvider());
            }
        }
        if (!(event.getObject() instanceof EntityItem)) {
            event.addCapability(ETERNAL_FLAME_KEY, (ICapabilityProvider)new EternalFlameProvider());
        }
    }

    @SubscribeEvent
    public static void cloneCapabilities(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            EntityPlayer entityPlayer = event.getOriginal();
            EntityPlayer playernew = event.getEntityPlayer();
            ((ICowbellCapability)event.getEntityPlayer().getCapability(Capabilities.COWBELL_CAPABILITY, null)).setHasRungCowbell(false);
            ((IBloodstoneCapability)event.getEntityPlayer().getCapability(Capabilities.BLOODSTONE_CAPABILITY, null)).resetBloodstoneState();
            List<ItemStack> oldItems = ((ILostItemsCapability)event.getOriginal().getCapability(Capabilities.LOST_ITEMS_CAPABILITY, null)).getLostItems();
            List<ItemStack> newItems = ((ILostItemsCapability)event.getEntityPlayer().getCapability(Capabilities.LOST_ITEMS_CAPABILITY, null)).getLostItems();
            newItems.clear();
            newItems.addAll(oldItems);
            SCPKnowledge scpKnowledge0 = (SCPKnowledge)entityPlayer.getCapability(Capabilities.SCP_KNOWLEDGE, null);
            SCPKnowledge knowledge = SCPKnowledge.getInstance(playernew);
            if (scpKnowledge0.isPlayerNotified()) {
                knowledge.setPlayerNotified();
            }
            knowledge.getKnowledge().putAll(scpKnowledge0.getKnowledge());
            CommonEvents.entityUpdateTicks.put(entityPlayer.func_145782_y(), 0);
        }
    }

    @SubscribeEvent
    public static void playerSleep(PlayerSleepInBedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ISleepDeprivationCapability capability = (ISleepDeprivationCapability)player.getCapability(Capabilities.SlEEP_DEPRIVATION, null);
        if (!capability.isCured()) {
            if (event.getPos().equals((Object)player.func_180425_c())) {
                event.setResult(EntityPlayer.SleepResult.OK);
            } else {
                event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("scp.player.cant.sleep", new Object[0]));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerWakeUp(PlayerWakeUpEvent wakeUpEvent) {
        EntityPlayer entityPlayer = wakeUpEvent.getEntityPlayer();
        if (entityPlayer.func_70643_av() instanceof EntitySleepKiller) {
            entityPlayer.func_180469_a(entityPlayer.func_180425_c());
        }
    }

    @SubscribeEvent
    public static void checkSleepLocation(SleepingLocationCheckEvent sleepingLocationCheckEvent) {
    }

    @SubscribeEvent
    public static void playerTicks(TickEvent.PlayerTickEvent playerTickEvent) {
        World world;
        EntityPlayer player = playerTickEvent.player;
        Integer tick = CommonEvents.entityUpdateTicks.get(player.func_145782_y());
        if (tick != null && tick == 1 && (world = player.field_70170_p) instanceof WorldServer) {
            SCP.SimpleNetworkWrapper.sendTo((IMessage)new SynchronizeToClient(SCPinformation, (Entity)player, null), (EntityPlayerMP)player);
        }
        if (player.hasCapability(Capabilities.DIZZINESS, null)) {
            Dizziness dizziness = (Dizziness)player.getCapability(Capabilities.DIZZINESS, null);
            dizziness.actUpon(player);
        }
    }

    @SubscribeEvent
    public static void onEntitySPawned(EntityJoinWorldEvent joinWorldEvent) {
        EntityPlayer entityPlayer;
        SCPKnowledge knowledge;
        Entity joined = joinWorldEvent.getEntity();
        World world = joinWorldEvent.getWorld();
        if (joined instanceof EntityPlayer && !(knowledge = SCPKnowledge.getInstance(entityPlayer = (EntityPlayer)joined)).isPlayerNotified()) {
            knowledge.setPlayerNotified();
            if (!world.field_72995_K) {
                entityPlayer.func_145747_a((ITextComponent)Utils.translate("start.by.000j", new Object[0]));
            }
        }
    }

    @SubscribeEvent
    public static void itemExpire(ItemExpireEvent event) {
        EntityPlayer player;
        EntityItem entityItem = event.getEntityItem();
        if (entityItem.func_145800_j() != null && !entityItem.func_145800_j().isEmpty() && (player = entityItem.field_70170_p.func_72924_a(entityItem.func_145800_j())) != null && player.hasCapability(Capabilities.LOST_ITEMS_CAPABILITY, null)) {
            ((ILostItemsCapability)player.getCapability(Capabilities.LOST_ITEMS_CAPABILITY, null)).addItemStack(entityItem.func_92059_d());
        }
    }

    @SubscribeEvent
    public static void onBucketFillAttempt(FillBucketEvent fillBucketEvent) {
        IBlockState blockState;
        World world = fillBucketEvent.getWorld();
        RayTraceResult rayTraceResult = fillBucketEvent.getTarget();
        if (rayTraceResult != null && (blockState = world.func_180495_p(rayTraceResult.func_178782_a())).func_177230_c() == SCPBlocks.youthFluidBlock) {
            fillBucketEvent.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent worldTickEvent) {
        World world = worldTickEvent.world;
        if (world.hasCapability(Capabilities.OLD_MAN_CONTROLLER, null)) {
            OldManController oldManController = (OldManController)world.getCapability(Capabilities.OLD_MAN_CONTROLLER, null);
            oldManController.handle(world);
        }
    }
}

