/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.events;

import alexiy.secure.contain.protect.Configg;
import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.TempStorage;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.api.LootContainer;
import alexiy.secure.contain.protect.api.OriginalContexts;
import alexiy.secure.contain.protect.api.SCPEntry;
import alexiy.secure.contain.protect.capability.Capabilities;
import alexiy.secure.contain.protect.capability.zombievirus.Infection;
import alexiy.secure.contain.protect.entity.Entity2521;
import alexiy.secure.contain.protect.entity.EntityPlagueDoctor;
import alexiy.secure.contain.protect.entity.EntityPlagueZombie;
import alexiy.secure.contain.protect.events.LurePlayer;
import alexiy.secure.contain.protect.items.ItemDocument;
import alexiy.secure.contain.protect.packets.CutScene;
import alexiy.secure.contain.protect.packets.SaidDeadlyWord;
import alexiy.secure.contain.protect.packets.StopUserInput;
import alexiy.secure.contain.protect.registration.SCPItems;
import alexiy.secure.contain.protect.registration.SCPs;
import alexiy.secure.contain.protect.world.PlacementSettings2;
import alexiy.secure.contain.protect.world.TemplateUnwrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ServerEvents {
    private static final ArrayList<ResourceLocation> Facilities = new ArrayList();
    private static final ResourceLocation databankcell = new ResourceLocation("scp", "generated/dbcell");
    private static BlockPos previousFacilityCoords;
    private static BlockPos previousCellCoords;
    private boolean shouldExecute = false;

    @SubscribeEvent
    public void preventInfectedDespawn(LivingSpawnEvent.AllowDespawn allowDespawn) {
        Infection infection;
        EntityLivingBase livingBase = allowDespawn.getEntityLiving();
        if (livingBase.hasCapability(Capabilities.INFECTIONABLE, null) && (infection = (Infection)livingBase.getCapability(Capabilities.INFECTIONABLE, null)).isActive()) {
            allowDespawn.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void generateStructures(DecorateBiomeEvent.Pre decorateBiomeEvent) {
        boolean somethingGenerated = false;
        Random random = decorateBiomeEvent.getRand();
        WorldServer worldServer = (WorldServer)decorateBiomeEvent.getWorld();
        if (worldServer.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            Template facility;
            ChunkPos chunkPos = decorateBiomeEvent.getChunkPos();
            BlockPos blockPos = new BlockPos(chunkPos.field_77276_a << 4, 0, chunkPos.field_77275_b << 4);
            BlockPos center = blockPos.func_177982_a(4 + random.nextInt(12), 0, 4 + random.nextInt(12));
            BlockPos finalcenter = worldServer.func_175672_r(center);
            TemplateManager templateManager = worldServer.func_184163_y();
            if (Configg.enableDataBankCell && random.nextInt(Configg.dataBankCellRarity) == 1 && (previousCellCoords == null || previousCellCoords.func_177951_i((Vec3i)finalcenter) > 90000.0)) {
                BlockPos lower = finalcenter.func_177979_c(3);
                Template datacell = templateManager.func_189942_b(worldServer.func_73046_m(), databankcell);
                PlacementSettings2 placementSettings2 = new PlacementSettings2(Utils.randomHorizontalFacing());
                TemplateUnwrapper unwrapper = new TemplateUnwrapper(datacell);
                List<Template.BlockInfo> blockInfo = unwrapper.getBlockInfoList();
                boolean mayGenerate = true;
                for (Template.BlockInfo blockInfo2 : blockInfo) {
                    BlockPos adjustedPosition = Template.func_186266_a((PlacementSettings)placementSettings2, (BlockPos)blockInfo2.field_186242_a).func_177971_a((Vec3i)lower);
                    if (Utils.canReplaceBlock(adjustedPosition, (World)worldServer) && !(worldServer.func_180495_p(adjustedPosition).func_177230_c() instanceof BlockLiquid)) continue;
                    mayGenerate = false;
                    break;
                }
                if (mayGenerate) {
                    datacell.func_186253_b((World)worldServer, lower, (PlacementSettings)placementSettings2);
                    somethingGenerated = true;
                    previousCellCoords = lower;
                    if (Configg.experimentalSettings.enableDebugInformation) {
                        SCP.info("Data Bank cell at " + lower);
                    }
                }
            } else if (Configg.generateAbandonedFacility && random.nextInt(Configg.facilityRarity) == 1 && (previousFacilityCoords == null || finalcenter.func_177951_i((Vec3i)previousFacilityCoords) > 90000.0) && Utils.areChunksGeneratedAroundChunk(chunkPos, (World)worldServer) && (facility = templateManager.func_189942_b(worldServer.func_73046_m(), Facilities.get(random.nextInt(3)))) != null) {
                BlockPos offset = finalcenter.func_177979_c(facility.func_186259_a().func_177956_o() / 3);
                EnumFacing facing = Utils.randomHorizontalFacing();
                PlacementSettings2 placementSettings2 = new PlacementSettings2(facing);
                TemplateUnwrapper unwrapper = new TemplateUnwrapper(facility);
                List<Template.BlockInfo> blockInfo = unwrapper.getBlockInfoList();
                boolean maygenerate = true;
                for (Template.BlockInfo b : blockInfo) {
                    BlockPos adjustedPosition = Template.func_186266_a((PlacementSettings)placementSettings2, (BlockPos)b.field_186242_a).func_177971_a((Vec3i)offset);
                    if (Utils.canReplaceBlock(adjustedPosition, (World)worldServer) && !(worldServer.func_180495_p(adjustedPosition).func_177230_c() instanceof BlockLiquid)) continue;
                    maygenerate = false;
                    break;
                }
                if (maygenerate) {
                    facility.func_186253_b((World)worldServer, offset, (PlacementSettings)placementSettings2);
                    for (Template.BlockInfo info : blockInfo) {
                        if (info.field_186244_c == null) continue;
                        BlockPos adjpos = Template.func_186266_a((PlacementSettings)placementSettings2, (BlockPos)info.field_186242_a).func_177971_a((Vec3i)offset);
                        TileEntity tileEntity = worldServer.func_175625_s(adjpos);
                        LootContainer.generateRandomItems(tileEntity, OriginalContexts.FACILITY);
                    }
                    somethingGenerated = true;
                    List<Template.EntityInfo> list = unwrapper.getEntityInfoList();
                    for (Template.EntityInfo entityInfo : list) {
                        Vec3d vec3d = entityInfo.field_186247_a;
                        NBTTagCompound compound = entityInfo.field_186249_c;
                        Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)worldServer);
                        if (entity == null) continue;
                        Class<?> enclass = entity.getClass();
                        entity = EntityList.func_191304_a(enclass, (World)worldServer);
                        BlockPos adjustedPosition = Template.func_186266_a((PlacementSettings)placementSettings2, (BlockPos)new BlockPos(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c)).func_177971_a((Vec3i)offset);
                        boolean entityReplaced = false;
                        List entityLivings = worldServer.func_72872_a(EntityLiving.class, new AxisAlignedBB(adjustedPosition));
                        for (EntityLiving entityLiving : entityLivings) {
                            if (entity == null || entityLiving.getClass() != enclass) continue;
                            if (entity instanceof EntityLiving) {
                                EntityLiving living = (EntityLiving)entity;
                                living.func_180482_a(worldServer.func_175649_E(adjustedPosition), null);
                            }
                            entity.func_70107_b(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v);
                            entityLiving.func_70106_y();
                            worldServer.func_72838_d(entity);
                            if (!Configg.experimentalSettings.enableDebugInformation) continue;
                            entityReplaced = true;
                            SCP.logger.info("Replaced " + entityLiving.func_70005_c_() + " with new instance");
                        }
                        if (!Configg.experimentalSettings.enableDebugInformation || entityReplaced || entity == null) continue;
                        SCP.logger.info("Didn't replace " + entity.func_70005_c_());
                    }
                    if (Configg.experimentalSettings.enableDebugInformation) {
                        SCP.info("Facility at " + finalcenter + "; previous position: " + previousFacilityCoords);
                    }
                    previousFacilityCoords = finalcenter;
                }
            }
            if (Configg.experimentalSettings.naturalContainmentStructureGeneration && !somethingGenerated && random.nextInt(Configg.experimentalSettings.structureRarity) == 1) {
                ArrayList scps = new ArrayList(SCPs.scpRegistry.getValuesCollection());
                SCPEntry entry = (SCPEntry)((Object)scps.get(random.nextInt(scps.size())));
                if (entry.getStructureLocation() != null) {
                    Template template = templateManager.func_189942_b(worldServer.func_73046_m(), entry.getStructureLocation());
                    if (template != null) {
                        boolean bl;
                        EnumFacing facing = Utils.randomHorizontalFacing();
                        PlacementSettings2 placementSettings = new PlacementSettings2(facing);
                        TemplateUnwrapper templateUnwrapper = new TemplateUnwrapper(template);
                        List<Template.BlockInfo> blockInfoList = templateUnwrapper.getBlockInfoList();
                        boolean bl2 = true;
                        for (Template.BlockInfo blockInfo : blockInfoList) {
                            BlockPos adjustedPosition = Template.func_186266_a((PlacementSettings)placementSettings, (BlockPos)blockInfo.field_186242_a).func_177971_a((Vec3i)finalcenter);
                            if (Utils.canReplaceBlock(adjustedPosition, (World)worldServer)) continue;
                            bl = false;
                            break;
                        }
                        if (bl) {
                            template.func_186253_b((World)worldServer, finalcenter, (PlacementSettings)placementSettings);
                            if (Configg.experimentalSettings.testDrive) {
                                SCP.logger.info(entry.getName() + " generated at " + finalcenter.func_177958_n() + " " + finalcenter.func_177956_o() + " " + finalcenter.func_177952_p());
                            }
                        }
                    }
                } else {
                    Object o = entry.getAlternative();
                    if (o instanceof WorldGenerator && ((WorldGenerator)o).func_180709_b((World)worldServer, random, finalcenter) && Configg.experimentalSettings.testDrive) {
                        SCP.logger.info(entry.getAlternative() + " generated at " + finalcenter.func_177958_n() + " " + finalcenter.func_177956_o() + " " + finalcenter.func_177952_p());
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent deathEvent) {
        EntityLivingBase dead = deathEvent.getEntityLiving();
        DamageSource deathSource = deathEvent.getSource();
        if (dead instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)dead;
            Entity entity = deathEvent.getSource().func_76346_g();
            if (entity instanceof EntityPlagueDoctor) {
                EntityPlagueZombie plagueZombie = new EntityPlagueZombie(player.field_70170_p);
                BlockPos pos = player.func_180425_c();
                plagueZombie.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                player.field_70170_p.func_72838_d((Entity)plagueZombie);
                plagueZombie.setPlayerUUID(player.func_110124_au());
            }
            if (deathSource == SCP.shuckDamageSource) {
                Utils.spawnItemInWorld(new ItemStack(SCPItems.burntBone, 4), dead.field_70170_p, dead.func_180425_c());
            }
        }
        if (!dead.field_70170_p.field_72995_K && dead instanceof EntityZombie && dead.field_70170_p.field_73012_v.nextInt(100) <= 3) {
            dead.field_70170_p.func_72838_d((Entity)new EntityItem(dead.field_70170_p, dead.field_70165_t, dead.field_70163_u, dead.field_70161_v, new ItemStack(SCPItems.organ, 1, 0)));
        }
    }

    @SubscribeEvent
    public void modifyDrops(LivingDropsEvent dropsEvent) {
        if (dropsEvent.getSource() == SCP.shuckDamageSource) {
            EntityLivingBase livingBase = dropsEvent.getEntityLiving();
            List entityItems = dropsEvent.getDrops();
            World world = livingBase.field_70170_p;
            for (EntityItem entityItem : entityItems) {
                ItemStack itemStack = entityItem.func_92059_d();
                if (itemStack.func_77973_b().getForgeRarity(itemStack) != EnumRarity.COMMON || itemStack.func_77973_b() instanceof ItemDocument || itemStack.func_77948_v()) continue;
                entityItem.func_70106_y();
                ItemStack ash = new ItemStack(SCPItems.ash, itemStack.func_190916_E());
                EntityItem item = new EntityItem(livingBase.field_70170_p, livingBase.field_70165_t, livingBase.field_70163_u, livingBase.field_70161_v, ash);
                world.func_72838_d((Entity)item);
            }
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent event) {
        if (event instanceof TickEvent.ServerTickEvent) {
            if (this.shouldExecute) {
                LurePlayer.lureTickEvent();
            }
            this.shouldExecute = !this.shouldExecute;
        }
    }

    @SubscribeEvent
    public void serverChatEvent(ServerChatEvent event) {
        if (event.getPlayer().func_184812_l_()) {
            return;
        }
        int num = 0;
        for (char letter : event.getMessage().toCharArray()) {
            if ((num == 0 || num == 2) && letter == '2') {
                ++num;
            }
            if (num == 1 && letter == '5') {
                ++num;
            }
            if (num != 3 || letter != '1') continue;
            ++num;
            break;
        }
        int word = 0;
        if (num != 4) {
            for (String phrase : event.getMessage().toLowerCase(Locale.ROOT).split(" ")) {
                if (word == 0 && phrase.contains("two")) {
                    ++word;
                }
                if (word == 1 && phrase.contains("five")) {
                    ++word;
                }
                if (word == 2 && phrase.contains("two")) {
                    ++word;
                }
                if (word != 3 || !phrase.contains("one")) continue;
                ++word;
                break;
            }
        }
        if (!(num != 4 && word != 4 || TempStorage.instance.saidItAlready(event.getPlayer().func_110124_au()))) {
            SCP.SimpleNetworkWrapper.sendTo((IMessage)new SaidDeadlyWord(), event.getPlayer());
            SCP.SimpleNetworkWrapper.sendTo((IMessage)new StopUserInput(true), event.getPlayer());
            this.spawnSCP2521((EntityPlayer)event.getPlayer());
        }
    }

    public void spawnSCP2521(EntityPlayer player) {
        Vec3d vec = player.func_70040_Z();
        double dx = player.field_70165_t - vec.field_72450_a;
        double dy = player.field_70163_u;
        double dz = player.field_70161_v - vec.field_72449_c;
        Entity2521 entity = new Entity2521(player.field_70170_p);
        entity.func_70634_a(dx, dy, dz);
        entity.setTarget(player);
        player.field_70170_p.func_72838_d((Entity)entity);
        SCP.SimpleNetworkWrapper.sendTo((IMessage)new CutScene(true), (EntityPlayerMP)player);
    }

    static {
        Facilities.add(new ResourceLocation("scp", "generated/facility_original"));
        Facilities.add(new ResourceLocation("scp", "generated/facility_flooded"));
        Facilities.add(new ResourceLocation("scp", "generated/facility_cb"));
    }
}

