/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.packets;

import alexiy.secure.contain.protect.ItemHandler;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.registration.SCPs;
import alexiy.secure.contain.protect.tileentity.TileDocumentCrafter;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CraftDocument
implements IMessage {
    private BlockPos position;
    private String scpNumber;

    public CraftDocument(BlockPos position, String scpNumber) {
        this.position = position;
        this.scpNumber = scpNumber;
    }

    public CraftDocument() {
    }

    public void fromBytes(ByteBuf buf) {
        this.position = BlockPos.func_177969_a((long)buf.readLong());
        this.scpNumber = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.position.func_177986_g());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.scpNumber);
    }

    public static class Handler
    implements IMessageHandler<CraftDocument, IMessage> {
        public IMessage onMessage(CraftDocument message, MessageContext ctx) {
            WorldServer worldServer = ctx.getServerHandler().field_147369_b.func_71121_q();
            worldServer.func_152344_a(() -> {
                TileEntity tileEntity = worldServer.func_175625_s(message.position);
                if (tileEntity instanceof TileDocumentCrafter) {
                    TileDocumentCrafter crafter = (TileDocumentCrafter)tileEntity;
                    ItemHandler itemHandler = crafter.itemHandler;
                    ItemStack document = SCPs.getDocument(message.scpNumber);
                    if (document != null) {
                        itemHandler.setStackInSlot(0, ItemStack.field_190927_a);
                        itemHandler.getStackInSlot(1).func_190918_g(1);
                        itemHandler.setStackInSlot(2, document);
                        Utils.sendBlockUpdate(worldServer, message.position);
                    }
                }
            });
            return null;
        }
    }
}

