/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.packets;

import alexiy.secure.contain.protect.capability.Capabilities;
import alexiy.secure.contain.protect.capability.crystallization.Crystallizable;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CrystallizeEntity
implements IMessage {
    private boolean doCrystallize;
    private int entityId;
    private int duration;

    public CrystallizeEntity() {
    }

    public CrystallizeEntity(int entityId_, boolean crystallize, int duration_) {
        this.entityId = entityId_;
        this.doCrystallize = crystallize;
        this.duration = duration_;
    }

    public void fromBytes(ByteBuf buf) {
        this.doCrystallize = buf.readBoolean();
        this.entityId = buf.readInt();
        this.duration = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.doCrystallize);
        buf.writeInt(this.entityId);
        buf.writeInt(this.duration);
    }

    public static class Handler
    implements IMessageHandler<CrystallizeEntity, IMessage> {
        public IMessage onMessage(final CrystallizeEntity message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    WorldClient world = Minecraft.func_71410_x().field_71441_e;
                    for (Entity entity : world.field_72996_f) {
                        if (entity.func_145782_y() != message.entityId) continue;
                        if (!(entity instanceof EntityLiving)) break;
                        EntityLiving entityLiving = (EntityLiving)entity;
                        Crystallizable crystallizable = (Crystallizable)entity.getCapability(Capabilities.CRYSTALLIZABLE_CAPABILITY, null);
                        crystallizable.setCrystallized(message.doCrystallize);
                        crystallizable.setDuration(message.duration);
                        entityLiving.func_94061_f(true);
                        entityLiving.func_184224_h(true);
                        entityLiving.func_174810_b(true);
                        entityLiving.updateBlocked = true;
                        break;
                    }
                }
            });
            return null;
        }
    }
}

