/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.packets;

import alexiy.secure.contain.protect.capability.Capabilities;
import alexiy.secure.contain.protect.capability.guiltmob.IGuiltMobCapability;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class GuiltMobSync
implements IMessage {
    private int entityID;
    private boolean isGuiltMob;
    private String playerName;

    public GuiltMobSync() {
    }

    public GuiltMobSync(int entityID, boolean isGuiltMob) {
        this(entityID, isGuiltMob, null);
    }

    public GuiltMobSync(int entityID, boolean isGuiltMob, @Nullable String playerName) {
        this.entityID = entityID;
        this.isGuiltMob = isGuiltMob;
        this.playerName = playerName;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.isGuiltMob = buf.readBoolean();
        this.playerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.isGuiltMob);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerName);
    }

    public static class Handler
    implements IMessageHandler<GuiltMobSync, IMessage> {
        public IMessage onMessage(final GuiltMobSync message, MessageContext ctx) {
            final Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Entity entity = mc.field_71441_e.func_73045_a(message.entityID);
                    if (entity != null && entity.hasCapability(Capabilities.GUILT_MOB_CAPABILITY, null)) {
                        IGuiltMobCapability capability = (IGuiltMobCapability)entity.getCapability(Capabilities.GUILT_MOB_CAPABILITY, null);
                        capability.setGuiltMob(message.isGuiltMob);
                        capability.setPlayerName(message.playerName);
                        if (message.isGuiltMob) {
                            entity.func_174810_b(!mc.field_71439_g.func_70005_c_().equals(capability.getPlayerName()));
                        }
                    }
                }
            });
            return null;
        }
    }
}

