/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.registration;

import alexiy.secure.contain.protect.Configg;
import alexiy.secure.contain.protect.NBTWriter;
import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.api.MainAPI;
import alexiy.secure.contain.protect.api.ObjectClass;
import alexiy.secure.contain.protect.api.SCPEntry;
import alexiy.secure.contain.protect.api.Token;
import alexiy.secure.contain.protect.generators.HoleGenerator;
import alexiy.secure.contain.protect.generators.StairWellGenerator;
import alexiy.secure.contain.protect.registration.SCPItems;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class SCPs {
    public static IForgeRegistry<SCPEntry> scpRegistry;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerSCPs(RegistryEvent.Register<SCPEntry> event) {
        IForgeRegistry forgeRegistry;
        scpRegistry = forgeRegistry = event.getRegistry();
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("002", "The \"Living\" Room", ObjectClass.EUCLID).defaultStructure("002", Rotation.CLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("005", "Skeleton Key", ObjectClass.SAFE).defaultStructure("005", Rotation.CLOCKWISE_180).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("006", "Fountain of Youth", ObjectClass.SAFE).defaultStructure("006", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("008", "Zombie Plague", ObjectClass.EUCLID).defaultStructure("008", Rotation.CLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("009", "Red Ice", ObjectClass.EUCLID).defaultStructure("009", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("019", "Monster Pot", ObjectClass.KETER).defaultStructure("019", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("023", "Black Shuck", ObjectClass.EUCLID).defaultStructure("023", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("027", "Vermin god", ObjectClass.EUCLID).defaultStructure("027", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("049", "Plague Doctor", ObjectClass.EUCLID).defaultStructure("049", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("053", "Young Girl", ObjectClass.EUCLID).defaultStructure("053", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("063", "The World's Best Tothbrush", ObjectClass.SAFE).defaultStructure("063", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("079", "Old AI", ObjectClass.EUCLID).defaultStructure("079", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("087", "The Stairwell", ObjectClass.EUCLID).alternative((Object)new StairWellGenerator()).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("096", "Shy Guy", ObjectClass.EUCLID).defaultStructure("096", Rotation.CLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("106", "The Old Man", ObjectClass.KETER).defaultStructure("106", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("109", "Infinite Canteen", ObjectClass.SAFE).defaultStructure("109", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("111", "Dragon Snails", ObjectClass.SAFE).defaultStructure("111", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("124", "Fertile Soil", ObjectClass.EUCLID).defaultStructure("124", Rotation.CLOCKWISE_180).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("131", "Eye Pods", ObjectClass.SAFE).defaultStructure("131", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("143", "The Bladewood Grove", ObjectClass.EUCLID).defaultStructure("143", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("148", "The 'Telekill' Alloy", ObjectClass.EUCLID).defaultStructure("148", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("151", "The Painting", ObjectClass.EUCLID).defaultStructure("151", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("160", "Predator Drone", ObjectClass.EUCLID).defaultStructure("160", Rotation.CLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("173", "The Sculpture", ObjectClass.EUCLID).defaultStructure("173", Rotation.CLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("178", "3-D Specs", ObjectClass.EUCLID).defaultStructure("178", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("250", "Most of an Allosaurus", ObjectClass.EUCLID).defaultStructure("250", Rotation.CLOCKWISE_180).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("261", "Pan-Dimensional Vending", ObjectClass.SAFE).defaultStructure("261", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("280", "Eyes in the Dark", ObjectClass.KETER).defaultStructure("280", Rotation.CLOCKWISE_180).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("294", "The Coffee Machine", ObjectClass.EUCLID).defaultStructure("294", Rotation.CLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("330", "Take Only Two", ObjectClass.SAFE).defaultStructure("330", Rotation.CLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("346", "\"Pterry\" the Pterodactyl", ObjectClass.SAFE).defaultStructure("346", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("354", "The Red Pool", ObjectClass.KETER).defaultStructure("354", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("409", "Contagious Crystal", ObjectClass.KETER).defaultStructure("409", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("458", "The Never-Ending Pizza Box", ObjectClass.SAFE).defaultStructure("458", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("472", "Bloodstone", ObjectClass.EUCLID).defaultStructure("472", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("500", "Panacea", ObjectClass.SAFE).defaultStructure("500", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("513", "A Cowbell", ObjectClass.EUCLID).defaultStructure("513", Rotation.CLOCKWISE_180).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("529", "Josie the Half-Cat", ObjectClass.SAFE).defaultStructure("529", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("538", "Shadow Spiders", ObjectClass.EUCLID).defaultStructure("538", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("548", "Ice Spider", ObjectClass.EUCLID).defaultStructure("548", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("553", "Crystalline Butterflies", ObjectClass.SAFE).defaultStructure("553", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("573", "The Pied Pipe", ObjectClass.EUCLID).defaultStructure("573", Rotation.CLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("594", "Electric Sheep", ObjectClass.EUCLID).defaultStructure("594", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("668", "13\" Chef's Knife", ObjectClass.EUCLID).defaultStructure("668", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("682", "Hard-to-Destroy Reptile", ObjectClass.KETER).defaultStructure("682", Rotation.CLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("689", "Haunter in the Dark", ObjectClass.KETER).defaultStructure("689", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("718", "Eyeball", ObjectClass.KETER).defaultStructure("718", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("811", "Swamp Woman", ObjectClass.EUCLID).defaultStructure("811", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("822", "Landmine Cacti", ObjectClass.EUCLID).defaultStructure("822", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("843", "Cow Seeds", ObjectClass.EUCLID).defaultStructure("843", Rotation.CLOCKWISE_180).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("912", "Autonomous SWAT Armor", ObjectClass.SAFE).defaultStructure("912", Rotation.CLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("914", "The Clockworks", ObjectClass.SAFE).defaultStructure("914", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("939", "With Many Voices", ObjectClass.KETER).defaultStructure("939", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("966", "Sleep Killer", ObjectClass.EUCLID).defaultStructure("966", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("997", "Vermin Suppressor", ObjectClass.SAFE).defaultStructure("997", Rotation.CLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("1000", "Bigfoot", ObjectClass.KETER).defaultStructure("1000", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("1025", "Encyclopedia of Diseases", ObjectClass.SAFE).defaultStructure("1025", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("1048", "Builder Bear", ObjectClass.KETER).defaultStructure("1048", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("1162", "A Hole in the Wall", ObjectClass.EUCLID).defaultStructure("1162", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("1057", "Absence of Shark", ObjectClass.SAFE).defaultStructure("1057", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("1437", "A Hole to Another Place", ObjectClass.SAFE).alternative((Object)new HoleGenerator()).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("1507", "Pink Flamingo", ObjectClass.EUCLID).defaultStructure("1507", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("2295", "The Bear with a Heart of Patchwork", ObjectClass.SAFE).defaultStructure("2295", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("3199", "Humans, Refuted", ObjectClass.KETER).defaultStructure("3199", Rotation.CLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("4307", "Electro-Marine Praetorian", ObjectClass.EUCLID).defaultStructure("4307", Rotation.CLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("059-FR", "Blizzard's Claws", ObjectClass.EUCLID).defaultStructure("059-fr", Rotation.CLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("143-FR", "Mesozoic chicken coop", ObjectClass.SAFE).defaultStructure("143-fr", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("015", "Pipe Nightmare", ObjectClass.EUCLID).defaultStructure("015", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("524", "Walter the Omnivorous Rabbit", ObjectClass.SAFE).defaultStructure("524", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("012", "A Bad Composition", ObjectClass.EUCLID).defaultStructure("012", Rotation.COUNTERCLOCKWISE_90).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("1032-RU", "Vengeful Apple", ObjectClass.SAFE).defaultStructure("1032-ru", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("2521", "--|-----|--|-", ObjectClass.KETER).defaultStructure("2521", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("098", "Surgeon Crabs", ObjectClass.SAFE).defaultStructure("098", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("020", "Invisible Mold", ObjectClass.KETER).defaultStructure("020", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("902", "The Final Countdown", ObjectClass.KETER).defaultStructure("902", Rotation.NONE).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("1074", "Stendhal's Nightmare", ObjectClass.SAFE).defaultStructure("1074", Rotation.CLOCKWISE_180).build());
        forgeRegistry.register((IForgeRegistryEntry)new SCPEntry.Builder().info("2761", "Bananazilla", ObjectClass.EUCLID).defaultStructure("2761", Rotation.CLOCKWISE_180).build());
        SCP.logger.info("Registered {} SCPs", (Object)forgeRegistry.getValuesCollection().size());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void checkTokens(RegistryEvent.Register<SCPEntry> event) {
        for (SCPEntry scpEntry : scpRegistry.getValuesCollection()) {
            boolean tokenExists = false;
            for (Token token : MainAPI.tokens) {
                if (!token.getSCPNumber().equals(scpEntry.getNumber())) continue;
                tokenExists = true;
                break;
            }
            if (tokenExists) continue;
            throw new IllegalStateException("There is no token item for SCP-" + scpEntry.getNumber());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void checkTokenRecipes(RegistryEvent.Register<IRecipe> registryEvent) {
        if (Configg.checkTokenRecipes) {
            for (SCPEntry scpEntry : scpRegistry.getValuesCollection()) {
                boolean recipeExists = false;
                for (IRecipe iRecipe : ForgeRegistries.RECIPES.getValuesCollection()) {
                    Token t;
                    ItemStack itemStack;
                    if (!iRecipe.getRegistryName().func_110624_b().equals("scp") || !((itemStack = iRecipe.func_77571_b()).func_77973_b() instanceof Token) || !(t = (Token)itemStack.func_77973_b()).getSCPNumber().equals(scpEntry.getNumber())) continue;
                    recipeExists = true;
                    break;
                }
                if (recipeExists) continue;
                SCP.logger.warn("There is no recipe for token " + scpEntry.getNumber());
            }
        }
    }

    public static SCPEntry getByNumber(String number) {
        for (SCPEntry scpEntry : scpRegistry.getValuesCollection()) {
            if (!scpEntry.getNumber().equals(number)) continue;
            return scpEntry;
        }
        return null;
    }

    public static ItemStack getDocument(String scpNumber) {
        SCPEntry scpEntry = SCPs.getByNumber(scpNumber);
        if (scpEntry != null) {
            return SCPs.getDocument(scpEntry);
        }
        return null;
    }

    public static ItemStack getDocument(SCPEntry scpEntry) {
        Item item = null;
        switch (scpEntry.getObjectClass()) {
            case SAFE: {
                item = SCPItems.safeDocument;
                break;
            }
            case EUCLID: {
                item = SCPItems.euclidDocument;
                break;
            }
            case KETER: {
                item = SCPItems.keterDocument;
            }
        }
        if (item != null) {
            ItemStack document = new ItemStack(item);
            NBTWriter writer = new NBTWriter(new NBTTagCompound()).setString("ObjectName", scpEntry.getName()).setString("ObjectClass", scpEntry.getObjectClass().name()).setString("Number", scpEntry.getNumber());
            document.func_77982_d(writer.getResult());
            return document;
        }
        return null;
    }
}

