/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.ui;

import alexiy.secure.contain.protect.ClientProxy;
import alexiy.secure.contain.protect.General;
import alexiy.secure.contain.protect.GeneralInfo;
import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.ui.GuiContainer2;
import alexiy.secure.contain.protect.ui.ScrollTarget;
import alexiy.secure.contain.protect.ui.components.BetterButton;
import alexiy.secure.contain.protect.ui.components.Label;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import org.lwjgl.input.Mouse;

public class GuiGeneralInfo
extends GuiContainer2 {
    private EntityPlayer player;
    private ScrollTarget scrollTarget = ScrollTarget.BUTTON;
    ArrayList<GeneralInfo> list = new ArrayList<GeneralInfo>(Arrays.asList(GeneralInfo.values()));
    Locale locale;
    ArrayList<Label> renderlines;
    ArrayList<BetterButton> buttons;
    private int time;
    private int scroll;
    int textOffset;
    BetterButton openSCPgui;

    public GuiGeneralInfo(Container container, EntityPlayer player) {
        super(container);
        this.list.sort(Comparator.naturalOrder());
        this.buttons = new ArrayList(this.list.size());
        this.scroll = ClientProxy.getCachedScrollAmount(GuiGeneralInfo.class);
        this.player = player;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.locale = this.field_146297_k.func_135016_M().func_135041_c().getJavaLocale();
        this.renderlines = new ArrayList();
        this.field_147009_r = 0;
        this.field_147003_i = 0;
        this.field_146999_f = this.field_146294_l;
        this.field_147000_g = this.field_146295_m;
        this.buttons.clear();
        int next = 0;
        for (GeneralInfo generalInfo : this.list) {
            String key = generalInfo.translationKey;
            String translated = Utils.translate(key, new Object[0]).func_150260_c();
            List<String> info = SCP.PROXY.getInfo(this.locale, key);
            if (info == null) {
                Utils.sendMessageTo(this.player, "No file found for " + key);
                info = SCP.PROXY.getInfo(Locale.US, key);
            }
            if (info == null) continue;
            BetterButton infokey = new BetterButton(generalInfo.ordinal(), 3, 3 + next * 20, translated, true, false);
            this.addbutton((GuiButton)infokey);
            this.buttons.add(infokey);
            if (infokey.getWidth() > this.textOffset) {
                this.textOffset = infokey.getWidth() + 20;
            }
            ++next;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (this.buttons.contains(button)) {
            GeneralInfo generalInfo = GeneralInfo.values()[button.field_146127_k];
            String key = generalInfo.translationKey;
            List<String> info = SCP.PROXY.getInfo(this.locale, key);
            if (info == null) {
                info = SCP.PROXY.getInfo(Locale.US, key);
                this.time = 80;
            }
            if (info != null) {
                int inc;
                this.labels.removeAll(this.renderlines);
                this.renderlines = new ArrayList(info.size());
                int y = inc = 18;
                ArrayList<String> fittedStrings = new ArrayList<String>(info.size());
                for (String s : info) {
                    this.fitString(s, this.textOffset, fittedStrings);
                }
                for (String fittedString : fittedStrings) {
                    Label label = new Label(fittedString.trim(), General.WHITE, this.textOffset, y, true);
                    this.renderlines.add(label);
                    this.addLabel(label);
                    y += inc;
                }
            }
        }
    }

    @Override
    protected void mouseMoved(int mouseX, int mouseY) {
        this.scrollTarget = mouseX > this.textOffset ? ScrollTarget.INFO : ScrollTarget.BUTTON;
    }

    @Override
    public void func_146274_d() {
        int scrollamount = Mouse.getEventDWheel();
        if (scrollamount != 0) {
            this.scroll += scrollamount * 20;
            if (this.scrollTarget == ScrollTarget.BUTTON) {
                this.buttons.forEach(betterButton -> betterButton.scroll(scrollamount, true));
            } else if (this.scrollTarget == ScrollTarget.INFO) {
                if (GuiScreen.func_146271_m()) {
                    this.renderlines.forEach(label -> label.scroll(scrollamount, false));
                } else {
                    this.renderlines.forEach(label -> label.scroll(scrollamount, true));
                }
            }
        } else {
            try {
                super.func_146274_d();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.time > 0) {
            Utils.drawString(Utils.translate("no.associated.file.found", new Object[0]).func_150254_d(), this.textOffset, 3, General.PASTEL);
            --this.time;
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        ClientProxy.cacheScrollAmount(GuiGeneralInfo.class, this.scroll);
    }
}

