/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.ui;

import alexiy.secure.contain.protect.ClientProxy;
import alexiy.secure.contain.protect.Configg;
import alexiy.secure.contain.protect.General;
import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.api.SCPEntry;
import alexiy.secure.contain.protect.capability.Capabilities;
import alexiy.secure.contain.protect.capability.playerknowledge.SCPKnowledge;
import alexiy.secure.contain.protect.registration.SCPs;
import alexiy.secure.contain.protect.ui.GuiContainer2;
import alexiy.secure.contain.protect.ui.GuiGeneralInfo;
import alexiy.secure.contain.protect.ui.ScrollTarget;
import alexiy.secure.contain.protect.ui.components.BetterButton;
import alexiy.secure.contain.protect.ui.components.Label;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import org.lwjgl.input.Mouse;

public class GuiSCPInfo
extends GuiContainer2 {
    private ScrollTarget scrollTarget = ScrollTarget.BUTTON;
    private EntityPlayer player;
    private SCPKnowledge scpKnowledge;
    private int notifictime;
    private int noInfo;
    private BetterButton goToGeneralInfo;
    private GuiGeneralInfo generalInfo;
    private int scroll;
    private ArrayList<BetterButton> scpNumbers = new ArrayList(SCPs.scpRegistry.getValuesCollection().size());
    Locale locale;
    private ArrayList<Label> visualStrings = new ArrayList();

    public GuiSCPInfo(Container container, EntityPlayer player) {
        super(container);
        this.player = player;
        if (player.hasCapability(Capabilities.SCP_KNOWLEDGE, null)) {
            this.scpKnowledge = (SCPKnowledge)player.getCapability(Capabilities.SCP_KNOWLEDGE, null);
        }
        this.scroll = ClientProxy.getCachedScrollAmount(GuiSCPInfo.class);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.scpNumbers.clear();
        this.locale = this.field_146297_k.func_135016_M().func_135041_c().getJavaLocale();
        this.func_183500_a(this.field_146294_l, this.field_146295_m);
        this.field_147009_r = 0;
        this.field_147003_i = 0;
        this.field_146999_f = this.field_146294_l;
        this.field_147000_g = this.field_146295_m;
        int y = 3;
        int bi = 0;
        if (Configg.allKnowledgeUnlocked) {
            ArrayList<SCPEntry> arrayList = new ArrayList<SCPEntry>(SCPs.scpRegistry.getValuesCollection());
            arrayList.sort(Comparator.comparing(SCPEntry::getNumber).thenComparingInt(o -> o.getNumber().length()));
            for (SCPEntry value : arrayList) {
                String classifier = value.getNumber();
                BetterButton number = new BetterButton(bi++, this.field_147003_i, y, classifier, true, false);
                this.scpNumbers.add(number);
                this.addbutton((GuiButton)number);
                y += 20;
            }
        } else {
            Map<String, Boolean> knowledgemap = this.scpKnowledge.getKnowledge();
            ArrayList<String> knowleddgekeys = new ArrayList<String>(knowledgemap.keySet());
            knowleddgekeys.sort(Comparator.naturalOrder());
            for (String kkey : knowleddgekeys) {
                boolean b = knowledgemap.get(kkey);
                if (!b) continue;
                BetterButton number = new BetterButton(bi++, this.field_147003_i, y, kkey, true, false);
                this.scpNumbers.add(number);
                this.addbutton((GuiButton)number);
                y += 20;
            }
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (this.scpNumbers.contains(button)) {
            int inc = 18;
            this.labels.removeAll(this.visualStrings);
            this.visualStrings.clear();
            BetterButton betterButton = (BetterButton)button;
            String text = betterButton.string;
            List<String> list = SCP.PROXY.getKnowledge(this.locale, text);
            if (list == null) {
                list = SCP.PROXY.getKnowledge(Locale.US, text);
                if (list != null) {
                    this.notifictime = 80;
                } else {
                    SCP.logger.warn("No info found about " + text);
                    this.noInfo = 160;
                    betterButton.field_146124_l = false;
                }
            }
            if (list != null) {
                int y = inc;
                ArrayList<String> fittedStrings = new ArrayList<String>(list.size());
                for (String string : list) {
                    fittedStrings = this.fitString(string, 60, fittedStrings);
                }
                for (String fittedString : fittedStrings) {
                    Label label = new Label(fittedString.trim(), General.WHITE, this.field_147003_i + 60, y, true);
                    this.addLabel(label);
                    this.visualStrings.add(label);
                    label.horizontalScroll = true;
                    y += inc;
                }
            }
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.notifictime > 0) {
            Utils.drawString(Utils.translate("no.associated.file.found", new Object[0]).func_150254_d(), this.field_147003_i + 70, this.field_147009_r + 3, General.LIGHTGREEN);
            --this.notifictime;
        }
        if (this.noInfo > 0) {
            Utils.drawString(Utils.translate("there.is.no.info.on.this.scp", new Object[0]).func_150254_d(), this.field_147003_i + 70, this.field_147009_r + 33, General.LIGHTGREEN);
            --this.noInfo;
        }
    }

    @Override
    protected void mouseMoved(int mouseX, int mouseY) {
        for (BetterButton betterButton : this.scpNumbers) {
            if (betterButton.getX() >= mouseX || betterButton.getX() + betterButton.getWidth() <= mouseX) continue;
            this.scrollTarget = ScrollTarget.BUTTON;
            break;
        }
        for (Label visualString : this.visualStrings) {
            if (visualString.getX() >= mouseX || visualString.getX() + visualString.getWidth() <= mouseX) continue;
            this.scrollTarget = ScrollTarget.INFO;
            break;
        }
    }

    @Override
    public void func_146274_d() {
        int scrollamount = Mouse.getEventDWheel();
        if (scrollamount != 0) {
            if (this.scrollTarget == ScrollTarget.BUTTON) {
                this.scpNumbers.forEach(betterButton -> betterButton.scroll(scrollamount, true));
            } else if (this.scrollTarget == ScrollTarget.INFO) {
                if (GuiScreen.func_146271_m()) {
                    this.visualStrings.forEach(label -> label.scroll(scrollamount, false));
                } else {
                    this.visualStrings.forEach(label -> label.scroll(scrollamount, true));
                }
            }
        } else {
            try {
                super.func_146274_d();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        ClientProxy.cacheScrollAmount(GuiSCPInfo.class, this.scroll);
    }
}

