/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.ui.components;

import alexiy.secure.contain.protect.ui.components.RadioButton;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;

public class ButtonGroup {
    private ArrayList<RadioButton> buttons = new ArrayList();

    public ButtonGroup(RadioButton ... radioButtons) {
        this.buttons.addAll(Arrays.asList(radioButtons));
        this.connect();
    }

    public void add(RadioButton rb) {
        this.buttons.add(rb);
    }

    public void connect() {
        for (RadioButton rb : this.buttons) {
            ArrayList others = (ArrayList)this.buttons.clone();
            others.remove(rb);
            for (RadioButton rb2 : others) {
                rb.addNeighbour(rb2);
            }
        }
    }

    @Nullable
    public RadioButton getSelected() {
        for (RadioButton r : this.buttons) {
            if (!r.selected) continue;
            return r;
        }
        return null;
    }

    public void setSelected(int button) {
        if (button >= 0 && button < this.buttons.size()) {
            this.buttons.get((int)button).selected = true;
        }
    }

    public void setSelected(RadioButton button) {
        if (this.buttons.contains(button)) {
            button.selected = true;
        }
    }

    public ArrayList<RadioButton> getButtons() {
        return this.buttons;
    }
}

