/*
 * Decompiled with CFR 0.152.
 */
package alexiy.secure.contain.protect.world.pocketdimension;

import alexiy.secure.contain.protect.Configg;
import alexiy.secure.contain.protect.SCP;
import alexiy.secure.contain.protect.Utils;
import alexiy.secure.contain.protect.api.LootContainer;
import alexiy.secure.contain.protect.api.OriginalContexts;
import alexiy.secure.contain.protect.registration.SCPBlocks;
import alexiy.secure.contain.protect.world.TemplateUnwrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class ChunkGenerator106
implements IChunkGenerator {
    private World world;
    private ArrayList<ResourceLocation> structureLocations;
    private final ConcurrentLinkedQueue<ChunkPos> delayedGenPositions;

    ChunkGenerator106(World world) {
        this.world = world;
        this.structureLocations = new ArrayList();
        this.delayedGenPositions = new ConcurrentLinkedQueue();
        this.addStructure("corridor_a");
        this.addStructure("corridor_b");
        this.addStructure("room");
        this.addStructure("unibox2");
        this.addStructure("unibox_dark");
        this.addStructure("unibox_stairs");
        this.addStructure("corridor_c");
        this.addStructure("corridor_d");
        this.addStructure("unibox_rt1");
        this.addStructure("unibox_rt2");
        this.addStructure("unibox_rt3");
        this.addStructure("unibox_rt4");
        this.addStructure("lootbox1");
        this.addStructure("lootbox2");
        this.addStructure("lootbox3");
        this.addStructure("lootbox4");
        this.addStructure("lootbox5");
        this.addStructure("lootbox_dark1");
        this.addStructure("lootbox_gs1");
        this.addStructure("lootbox_gs2");
        this.addStructure("lootbox_rt1");
        this.addStructure("lootbox_rt2");
        this.addStructure("lootbox_rt3");
        this.addStructure("cb_labirynth");
        this.addStructure("cb_loot_corridor1");
        this.addStructure("cb_lootbox1");
    }

    private void addStructure(String name) {
        this.structureLocations.add(new ResourceLocation("scp", "dimension106/" + name));
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                chunkPrimer.func_177855_a(i, 60, j, SCPBlocks.pdFloorMain.func_176223_P());
            }
        }
        Chunk chunk = new Chunk(this.world, chunkPrimer, x, z);
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        if (this.world instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)this.world;
            HashSet<ChunkPos> toremove = new HashSet<ChunkPos>(this.delayedGenPositions.size());
            for (ChunkPos delayedGenPosition : this.delayedGenPositions) {
                if (!Utils.areChunksGeneratedAroundChunk(delayedGenPosition, this.world)) continue;
                this.generateRoomStack(worldServer, delayedGenPosition.field_77276_a, delayedGenPosition.field_77275_b);
                toremove.add(delayedGenPosition);
            }
            this.delayedGenPositions.removeAll(toremove);
            if (Utils.areChunksGeneratedAroundChunk(x, z, this.world)) {
                this.generateRoomStack(worldServer, x, z);
            } else {
                this.delayedGenPositions.add(new ChunkPos(x, z));
            }
        }
    }

    private void generateRoomStack(WorldServer worldServer, int x, int z) {
        BlockPos blockPosf = Utils.chunkPosToBlockPosition(x, z);
        BlockPos blockPos = worldServer.func_175672_r(blockPosf);
        int floors = Configg.experimentalSettings.pocketDimensionStackSize;
        for (int i = 0; i < floors; ++i) {
            Template templ = this.getRandomTemplate(worldServer);
            if (templ == null) continue;
            PlacementSettings placementSettings = new PlacementSettings();
            placementSettings.func_186222_a(true);
            TemplateUnwrapper templateUnwrapper = new TemplateUnwrapper(templ);
            List<Template.BlockInfo> blockInfos = templateUnwrapper.getBlockInfoList();
            templ.func_186253_b((World)worldServer, blockPos, placementSettings);
            for (Template.BlockInfo blockInfo : blockInfos) {
                if (blockInfo.field_186244_c == null) continue;
                BlockPos adjustedPosition = Template.func_186266_a((PlacementSettings)placementSettings, (BlockPos)blockInfo.field_186242_a).func_177971_a((Vec3i)blockPos);
                TileEntity tileEntity = worldServer.func_175625_s(adjustedPosition);
                int n = LootContainer.generateRandomItems(tileEntity, OriginalContexts.POCKET_DIMENSION);
            }
            blockPos = blockPos.func_177981_b(templ.func_186259_a().func_177956_o());
        }
        worldServer.func_175656_a(blockPos.func_177982_a(7, -1, 7), SCPBlocks.pocketDimensionBlock.func_176223_P());
        worldServer.func_175656_a(blockPos.func_177982_a(7, -1, 8), SCPBlocks.pocketDimensionBlock.func_176223_P());
        worldServer.func_175656_a(blockPos.func_177982_a(8, -1, 7), SCPBlocks.pocketDimensionBlock.func_176223_P());
        worldServer.func_175656_a(blockPos.func_177982_a(8, -1, 8), SCPBlocks.pocketDimensionBlock.func_176223_P());
    }

    private Template getRandomTemplate(WorldServer worldServer) {
        TemplateManager templateManager = worldServer.func_184163_y();
        ResourceLocation templatePath = this.structureLocations.get(this.world.field_73012_v.nextInt(this.structureLocations.size()));
        Template template = templateManager.func_189942_b(worldServer.func_73046_m(), templatePath);
        if (template == null) {
            SCP.logger.error((Object)templatePath);
        }
        return template;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return Collections.emptyList();
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

