/*
 * Decompiled with CFR 0.152.
 */
package fuzs.slotcycler.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.slotcycler.SlotCycler;
import fuzs.slotcycler.client.core.ClientModServices;
import fuzs.slotcycler.client.handler.KeyBindingHandler;
import fuzs.slotcycler.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;

public class SlotRendererHandler {
    private static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("textures/gui/widgets.png");

    public static void onHudRender(Gui gui, PoseStack matrixStack, float tickDelta, int screenWidth, int screenHeight) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!minecraft.f_91066_.f_92062_) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69465_();
            if (minecraft.f_91072_.m_105295_() != GameType.SPECTATOR) {
                if (((ClientConfig)SlotCycler.CONFIG.get(ClientConfig.class)).slotsDisplayState == ClientConfig.SlotsDisplayState.NEVER) {
                    return;
                }
                SlotRendererHandler.renderAdditionalHotbar(minecraft, gui, matrixStack, tickDelta, screenWidth, screenHeight);
            }
        }
    }

    private static void renderAdditionalHotbar(Minecraft minecraft, Gui gui, PoseStack poseStack, float partialTicks, int screenWidth, int screenHeight) {
        if (((ClientConfig)SlotCycler.CONFIG.get(ClientConfig.class)).slotsDisplayState == ClientConfig.SlotsDisplayState.KEY && KeyBindingHandler.cycleSlotsDisplay == 0) {
            return;
        }
        Player player = SlotRendererHandler.getCameraPlayer(minecraft);
        if (player != null) {
            int originalScreenHeight = screenHeight;
            screenHeight -= ((ClientConfig)SlotCycler.CONFIG.get(ClientConfig.class)).slotsOffset;
            screenHeight -= ClientModServices.ABSTRACTIONS.getRaisedDistance();
            if (((ClientConfig)SlotCycler.CONFIG.get(ClientConfig.class)).slotsDisplayState == ClientConfig.SlotsDisplayState.KEY) {
                screenHeight = (int)((float)screenHeight + (float)(originalScreenHeight - screenHeight + 23) * (1.0f - Math.min(1.0f, ((float)KeyBindingHandler.cycleSlotsDisplay - partialTicks) / 5.0f)));
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_LOCATION);
            Inventory inventory = player.m_150109_();
            int selected = inventory.f_35977_;
            ItemStack mainStack = (ItemStack)inventory.f_35974_.get(selected);
            HumanoidArm humanoidarm = player.m_5737_().m_20828_();
            int leftSlot = SlotRendererHandler.getRightSlot(inventory, selected);
            int rightSlot = SlotRendererHandler.getLeftSlot(inventory, selected);
            if (humanoidarm == HumanoidArm.LEFT ? leftSlot == -1 : rightSlot == -1) {
                return;
            }
            ItemStack leftStack = (ItemStack)inventory.f_35974_.get(leftSlot);
            ItemStack rightStack = (ItemStack)inventory.f_35974_.get(rightSlot);
            if (humanoidarm == HumanoidArm.LEFT) {
                if (leftSlot <= rightSlot) {
                    rightStack = ItemStack.f_41583_;
                }
            } else if (leftSlot <= rightSlot) {
                leftStack = ItemStack.f_41583_;
            }
            int screenCenter = screenWidth / 2;
            if (humanoidarm == HumanoidArm.LEFT) {
                gui.m_93228_(poseStack, screenCenter + 91, screenHeight - 23, 53, 22, 29, 24);
                if (!rightStack.m_41619_()) {
                    gui.m_93228_(poseStack, screenCenter + 91 + 40, screenHeight - 23, 53, 22, 29, 24);
                }
                gui.m_93228_(poseStack, screenCenter + 91 + 28, screenHeight - 22, 21, 0, 20, 22);
                gui.m_93228_(poseStack, screenCenter + 91 + 26, screenHeight - 22 - 1, 0, 22, 24, 24);
            } else {
                if (!leftStack.m_41619_()) {
                    gui.m_93228_(poseStack, screenCenter - 91 - 29 - 40, screenHeight - 23, 24, 22, 29, 24);
                }
                gui.m_93228_(poseStack, screenCenter - 91 - 29, screenHeight - 23, 24, 22, 29, 24);
                gui.m_93228_(poseStack, screenCenter - 91 - 29 - 19, screenHeight - 22, 21, 0, 20, 22);
                gui.m_93228_(poseStack, screenCenter - 91 - 29 - 21, screenHeight - 22 - 1, 0, 22, 24, 24);
            }
            int j2 = screenHeight - 16 - 3;
            if (humanoidarm == HumanoidArm.LEFT) {
                SlotRendererHandler.renderSlot(minecraft, screenCenter + 91 + 10, j2, partialTicks, player, leftStack);
                SlotRendererHandler.renderSlot(minecraft, screenCenter + 91 + 10 + 20, j2, partialTicks, player, mainStack);
                SlotRendererHandler.renderSlot(minecraft, screenCenter + 91 + 10 + 20 + 20, j2, partialTicks, player, rightStack);
            } else {
                SlotRendererHandler.renderSlot(minecraft, screenCenter - 91 - 26, j2, partialTicks, player, rightStack);
                SlotRendererHandler.renderSlot(minecraft, screenCenter - 91 - 26 - 20, j2, partialTicks, player, mainStack);
                SlotRendererHandler.renderSlot(minecraft, screenCenter - 91 - 26 - 20 - 20, j2, partialTicks, player, leftStack);
            }
        }
    }

    private static int getLeftSlot(Inventory inventory, int selected) {
        int leftSlot = -1;
        for (int i = 1; i < 4; ++i) {
            int slotIndex = i * 9 + selected;
            if (((ItemStack)inventory.f_35974_.get(slotIndex)).m_41619_()) continue;
            leftSlot = slotIndex;
            break;
        }
        return leftSlot;
    }

    private static int getRightSlot(Inventory inventory, int selected) {
        int rightSlot = -1;
        for (int i = 3; i > 0; --i) {
            int slotIndex = i * 9 + selected;
            if (((ItemStack)inventory.f_35974_.get(slotIndex)).m_41619_()) continue;
            rightSlot = slotIndex;
            break;
        }
        return rightSlot;
    }

    private static Player getCameraPlayer(Minecraft minecraft) {
        return !(minecraft.m_91288_() instanceof Player) ? null : (Player)minecraft.m_91288_();
    }

    private static void renderSlot(Minecraft minecraft, int p_168678_, int p_168679_, float p_168680_, Player p_168681_, ItemStack p_168682_) {
        if (!p_168682_.m_41619_()) {
            PoseStack posestack = RenderSystem.m_157191_();
            float f = (float)p_168682_.m_41612_() - p_168680_;
            if (f > 0.0f) {
                float f1 = 1.0f + f / 5.0f;
                posestack.m_85836_();
                posestack.m_85837_((double)(p_168678_ + 8), (double)(p_168679_ + 12), 0.0);
                posestack.m_85841_(1.0f / f1, (f1 + 1.0f) / 2.0f, 1.0f);
                posestack.m_85837_((double)(-(p_168678_ + 8)), (double)(-(p_168679_ + 12)), 0.0);
                RenderSystem.m_157182_();
            }
            minecraft.m_91291_().m_174229_((LivingEntity)p_168681_, p_168682_, p_168678_, p_168679_, 0);
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            if (f > 0.0f) {
                posestack.m_85849_();
                RenderSystem.m_157182_();
            }
            minecraft.m_91291_().m_115169_(minecraft.f_91062_, p_168682_, p_168678_, p_168679_);
        }
    }
}

