/*
 * Decompiled with CFR 0.152.
 */
package fuzs.slotcycler.util;

import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SlotUtil {
    public static int cycleHotbarSlotLeft(Player player) {
        return SlotUtil.cycleSlotLeft(player, player.m_150109_().f_35977_);
    }

    public static int cycleSlotLeft(Player player, int slot) {
        int rightSlot = -1;
        Inventory inventory = player.m_150109_();
        for (int i = 3; i > 0; --i) {
            int slotIndex = (i * 9 + slot) % 36;
            if (!Inventory.m_36045_((int)slotIndex) && ((ItemStack)inventory.f_35974_.get(slotIndex)).m_41619_()) continue;
            rightSlot = slotIndex;
            break;
        }
        return rightSlot;
    }

    public static int cycleHotbarSlotRight(Player player) {
        return SlotUtil.cycleSlotRight(player, player.m_150109_().f_35977_);
    }

    public static int cycleSlotRight(Player player, int slot) {
        int leftSlot = -1;
        Inventory inventory = player.m_150109_();
        for (int i = 1; i < 4; ++i) {
            int slotIndex = (i * 9 + slot) % 36;
            if (!Inventory.m_36045_((int)slotIndex) && ((ItemStack)inventory.f_35974_.get(slotIndex)).m_41619_()) continue;
            leftSlot = slotIndex;
            break;
        }
        return leftSlot;
    }

    public static boolean cycleSlotsRight(Player player) {
        return SlotUtil.cycleSlotsRight(player, SlotUtil::swapSlots);
    }

    public static boolean cycleSlotsRight(Player player, SlotSwapper slotSwapper) {
        if (SlotUtil.cycleHotbarSlotRight(player) != -1) {
            int currentSlot = SlotUtil.cycleSlotRight(player, player.m_150109_().f_35977_);
            while (!Inventory.m_36045_((int)currentSlot)) {
                int nextSlot = SlotUtil.cycleSlotRight(player, currentSlot);
                slotSwapper.swapSlots(player, currentSlot, nextSlot);
                currentSlot = nextSlot;
            }
            return true;
        }
        return false;
    }

    public static boolean cycleSlotsLeft(Player player) {
        return SlotUtil.cycleSlotsLeft(player, SlotUtil::swapSlots);
    }

    public static boolean cycleSlotsLeft(Player player, SlotSwapper slotSwapper) {
        if (SlotUtil.cycleHotbarSlotLeft(player) != -1) {
            int currentSlot = SlotUtil.cycleSlotLeft(player, player.m_150109_().f_35977_);
            while (!Inventory.m_36045_((int)currentSlot)) {
                int nextSlot = SlotUtil.cycleSlotLeft(player, currentSlot);
                slotSwapper.swapSlots(player, currentSlot, nextSlot);
                currentSlot = nextSlot;
            }
            return true;
        }
        return false;
    }

    private static void swapSlots(Player player, int currentSlot, int nextSlot) {
        NonNullList items = player.m_150109_().f_35974_;
        ItemStack itemstack = (ItemStack)items.get(nextSlot);
        items.set(nextSlot, (Object)((ItemStack)items.get(currentSlot)));
        items.set(currentSlot, (Object)itemstack);
    }

    public static interface SlotSwapper {
        public void swapSlots(Player var1, int var2, int var3);
    }
}

